/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.br;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public final class BrazilianAnalyzer
extends Analyzer {
    public static final String[] BRAZILIAN_STOP_WORDS = new String[]{"a", "ainda", "alem", "ambas", "ambos", "antes", "ao", "aonde", "aos", "apos", "aquele", "aqueles", "as", "assim", "com", "como", "contra", "contudo", "cuja", "cujas", "cujo", "cujos", "da", "das", "de", "dela", "dele", "deles", "demais", "depois", "desde", "desta", "deste", "dispoe", "dispoem", "diversa", "diversas", "diversos", "do", "dos", "durante", "e", "ela", "elas", "ele", "eles", "em", "entao", "entre", "essa", "essas", "esse", "esses", "esta", "estas", "este", "estes", "ha", "isso", "isto", "logo", "mais", "mas", "mediante", "menos", "mesma", "mesmas", "mesmo", "mesmos", "na", "nas", "nao", "nas", "nem", "nesse", "neste", "nos", "o", "os", "ou", "outra", "outras", "outro", "outros", "pelas", "pelas", "pelo", "pelos", "perante", "pois", "por", "porque", "portanto", "proprio", "propios", "quais", "qual", "qualquer", "quando", "quanto", "que", "quem", "quer", "se", "seja", "sem", "sendo", "seu", "seus", "sob", "sobre", "sua", "suas", "tal", "tambem", "teu", "teus", "toda", "todas", "todo", "todos", "tua", "tuas", "tudo", "um", "uma", "umas", "uns"};
    private Set stoptable = new HashSet();
    private Set excltable = new HashSet();

    public BrazilianAnalyzer() {
        this.stoptable = StopFilter.makeStopSet((String[])BRAZILIAN_STOP_WORDS);
    }

    public BrazilianAnalyzer(String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet((String[])stopwords);
    }

    public BrazilianAnalyzer(Map stopwords) {
        this.stoptable = new HashSet(stopwords.keySet());
    }

    public BrazilianAnalyzer(File stopwords) throws IOException {
        this.stoptable = WordlistLoader.getWordSet((File)stopwords);
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.excltable = StopFilter.makeStopSet((String[])exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(Map exclusionlist) {
        this.excltable = new HashSet(exclusionlist.keySet());
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.excltable = WordlistLoader.getWordSet((File)exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StandardFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stoptable);
        result = new BrazilianStemFilter((TokenStream)result, this.excltable);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(reader);
            streams.result = new LowerCaseFilter((TokenStream)streams.source);
            streams.result = new StandardFilter(streams.result);
            streams.result = new StopFilter(streams.result, this.stoptable);
            streams.result = new BrazilianStemFilter(streams.result, this.excltable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

