/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.rs.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.rtnext.rs.data.DiskuzniPrispevek;
import cz.triangle.domy.PolozkaMenu;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Lazy
public class DiskuzeService {
    @Autowired
    private SessionFactory sessionFactory;

    @Transactional
    public Map<String, Object> vlozitPrispevek(String nazev, String autor, String text, String gRecaptchaResponse, Integer idDiskuzniPrispevek, String idPolozkaMenu, String secret, String ip) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            if (this.captchaVerify(gRecaptchaResponse, secret)) {
                DiskuzniPrispevek rodic = null;
                PolozkaMenu polozkaMenu = (PolozkaMenu)this.sessionFactory.getCurrentSession().get(PolozkaMenu.class, (Serializable)((Object)idPolozkaMenu));
                if (idDiskuzniPrispevek > -1) {
                    rodic = (DiskuzniPrispevek)this.sessionFactory.getCurrentSession().get(DiskuzniPrispevek.class, (Serializable)idDiskuzniPrispevek);
                } else {
                    List tmpRodicList = this.sessionFactory.getCurrentSession().createQuery("from DiskuzniPrispevek dp where dp.diskuzniPrispevek is null and dp.polozkaMenu=:polozkaMenu").setEntity("polozkaMenu", (Object)polozkaMenu).list();
                    if (tmpRodicList.size() > 0) {
                        rodic = (DiskuzniPrispevek)tmpRodicList.get(0);
                    } else {
                        rodic = new DiskuzniPrispevek();
                        rodic.setNazev("root");
                        rodic.setPolozkaMenu(polozkaMenu);
                        this.sessionFactory.getCurrentSession().save((Object)rodic);
                    }
                }
                DiskuzniPrispevek dp = new DiskuzniPrispevek();
                dp.setDiskuzniPrispevek(rodic);
                dp.setAutor(autor);
                dp.setDatum(new Date());
                dp.setIp(ip);
                dp.setNazev(nazev);
                dp.setText(text);
                dp.setPolozkaMenu(polozkaMenu);
                this.sessionFactory.getCurrentSession().save((Object)dp);
                vysledek.put("uspech", "ano");
                vysledek.put("idDiskuzniPrispevek", idDiskuzniPrispevek);
                vysledek.put("idPolozkaMenu", idPolozkaMenu);
                vysledek.put("autor", dp.getAutor());
                SimpleDateFormat ft = new SimpleDateFormat("d.MMMM yyyy h:mm:ss");
                vysledek.put("datum", ft.format(dp.getDatum()));
                vysledek.put("ip", ip);
                vysledek.put("nazev", dp.getNazev());
                vysledek.put("text", dp.getText());
                vysledek.put("id", dp.getId());
                return vysledek;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        vysledek.put("uspech", "ne");
        return vysledek;
    }

    public boolean captchaVerify(String gRecaptchaResponse, String secret) throws IOException {
        if (gRecaptchaResponse == null || "".equals(gRecaptchaResponse)) {
            return false;
        }
        try {
            String inputLine;
            URL obj = new URL("https://www.google.com/recaptcha/api/siteverify");
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            String postParams = "secret=" + secret + "&response=" + gRecaptchaResponse;
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(postParams);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            System.out.println(response.toString());
            ObjectMapper mapper = new ObjectMapper();
            JsonFactory factory = mapper.getFactory();
            JsonParser jp = factory.createParser(response.toString());
            JsonNode actualObj = (JsonNode)mapper.readTree(jp);
            boolean vysledek = actualObj.get("success").asBoolean();
            return vysledek;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

