/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.context;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;

public abstract class AbstractMessageContext
implements MessageContext {
    private Map<String, Object> properties;

    @Override
    public boolean containsProperty(String name) {
        return this.getProperties().containsKey(name);
    }

    @Override
    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    @Override
    public String[] getPropertyNames() {
        return StringUtils.toStringArray(this.getProperties().keySet());
    }

    @Override
    public void removeProperty(String name) {
        this.getProperties().remove(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    private Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }
}

