/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.SheetNameFormatter;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;

final class ExternSheetNameResolver {
    private ExternSheetNameResolver() {
    }

    public static String prependSheetName(FormulaRenderingWorkbook book, int field_1_index_extern_sheet, String cellRefText) {
        StringBuffer sb;
        EvaluationWorkbook.ExternalSheet externalSheet = book.getExternalSheet(field_1_index_extern_sheet);
        if (externalSheet != null) {
            String wbName = externalSheet.getWorkbookName();
            String sheetName = externalSheet.getSheetName();
            sb = new StringBuffer(wbName.length() + sheetName.length() + cellRefText.length() + 4);
            SheetNameFormatter.appendFormat(sb, wbName, sheetName);
        } else {
            String sheetName = book.getSheetNameByExternSheet(field_1_index_extern_sheet);
            sb = new StringBuffer(sheetName.length() + cellRefText.length() + 4);
            if (sheetName.length() < 1) {
                sb.append("#REF");
            } else {
                SheetNameFormatter.appendFormat(sb, sheetName);
            }
        }
        sb.append('!');
        sb.append(cellRefText);
        return sb.toString();
    }
}

