/*
 * Decompiled with CFR 0.152.
 */
package cn.bluejoe.elfinder.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.ClassPathResource;

public abstract class MimeTypesUtils {
    private static Map<String, String> _map = new HashMap<String, String>();
    public static final String UNKNOWN_MIME_TYPE = "application/oct-stream";

    static {
        try {
            MimeTypesUtils.load();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String getMimeType(String ext) {
        return _map.get(ext.toLowerCase());
    }

    public static boolean isUnknownType(String mime) {
        return mime == null || UNKNOWN_MIME_TYPE.equals(mime);
    }

    private static void load() throws IOException {
        String line;
        InputStream is = new ClassPathResource("/mime.types").getInputStream();
        BufferedReader fr = new BufferedReader(new InputStreamReader(is));
        while ((line = fr.readLine()) != null) {
            String[] tokens;
            if ((line = line.trim()).startsWith("#") || line.isEmpty() || (tokens = line.split("\\s+")).length < 2) continue;
            int i = 1;
            while (i < tokens.length) {
                MimeTypesUtils.putMimeType(tokens[i], tokens[0]);
                ++i;
            }
        }
        is.close();
    }

    public static void putMimeType(String ext, String type) {
        if (ext == null || type == null) {
            return;
        }
        _map.put(ext.toLowerCase(), type);
    }
}

