/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.rs.web;

import cz.rtnext.rs.service.RestDataService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Lazy
public class RestDataController {
    @Autowired
    private ApplicationContext applicationContext;

    @RequestMapping(method={RequestMethod.GET}, value={"/rest/{nazevObjektu}"})
    @ResponseBody
    List<?> find(@RequestParam Map<String, String> allRequestParams, @PathVariable String nazevObjektu, @RequestHeader(value="Range", required=false) String range, HttpServletResponse response) throws ClassNotFoundException {
        String nazevTridy = StringUtils.capitalize((String)nazevObjektu);
        Class<?> trida = null;
        try {
            trida = Class.forName("cz.rtnext.rs.data." + nazevTridy);
        }
        catch (ClassNotFoundException e) {
            trida = Class.forName("cz.triangle.domy." + nazevTridy);
        }
        RestDataService restDataService = (RestDataService)this.applicationContext.getBean(RestDataService.class);
        int startIndex = -1;
        int pageSize = -1;
        try {
            if (range != null) {
                String tmp = range.substring(range.indexOf(61) + 1, range.length());
                int poziceMinusu = tmp.indexOf(45);
                startIndex = Integer.parseInt(tmp.substring(0, poziceMinusu));
                int endIndex = Integer.parseInt(tmp.substring(poziceMinusu + 1, tmp.length()));
                pageSize = endIndex - startIndex + 1;
            }
        }
        catch (Exception e) {
            startIndex = -1;
            pageSize = -1;
        }
        String sortBy = allRequestParams.get("sortBy");
        HashMap<String, Object> vysledek = restDataService.find(trida, startIndex, pageSize, sortBy);
        List seznam = (List)vysledek.get("list");
        response.setHeader("Content-Range", (String)vysledek.get("range"));
        return seznam;
    }
}

