/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xsd.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.commons.CommonsXsdSchemaException;
import org.w3c.dom.Document;

public class CommonsXsdSchema
implements XsdSchema {
    private final XmlSchema schema;
    private final XmlSchemaCollection collection;

    protected CommonsXsdSchema(XmlSchema schema) {
        this(schema, null);
    }

    protected CommonsXsdSchema(XmlSchema schema, XmlSchemaCollection collection) {
        Assert.notNull((Object)schema, (String)"'schema' must not be null");
        this.schema = schema;
        this.collection = collection;
    }

    public String getTargetNamespace() {
        return this.schema.getTargetNamespace();
    }

    public QName[] getElementNames() {
        ArrayList result = new ArrayList(this.schema.getElements().keySet());
        return result.toArray(new QName[result.size()]);
    }

    public Source getSource() {
        try {
            XmlSchemaSerializer serializer = (XmlSchemaSerializer)BeanUtils.instantiateClass(XmlSchemaSerializer.class);
            if (this.collection != null) {
                serializer.setExtReg(this.collection.getExtReg());
            }
            Document[] serializedSchemas = serializer.serializeSchema(this.schema, false);
            return new DOMSource(serializedSchemas[0]);
        }
        catch (BeanInstantiationException ex) {
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException ex) {
            // empty catch block
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.schema.write((OutputStream)bos);
        }
        catch (UnsupportedEncodingException ex) {
            throw new CommonsXsdSchemaException(ex.getMessage(), ex);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        return new StreamSource(bis);
    }

    public XmlValidator createValidator() throws IOException {
        UrlResource resource = new UrlResource(this.schema.getSourceURI());
        return XmlValidatorFactory.createValidator((Resource)resource, "http://www.w3.org/2001/XMLSchema");
    }

    public XmlSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CommonsXsdSchema");
        builder.append('{');
        builder.append(this.getTargetNamespace());
        builder.append('}');
        return builder.toString();
    }
}

