/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.workflow;

import fr.improve.struts.taglib.layout.skin.Skin;
import fr.improve.struts.taglib.layout.sort.SortAction;
import fr.improve.struts.taglib.layout.tab.TabAction;
import fr.improve.struts.taglib.layout.treeview.TreeviewAction;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ModuleConfig;

public class LayoutPlugin
implements PlugIn {
    private static final Log LOG = LogFactory.getLog(LayoutPlugin.class);
    private String skinResources = "Struts-Layout";
    private static final String SORT_PATH = "/sort";
    private static final String TREEVIEW_PATH = "/treeview";
    private static final String TAB_PATH = "/tab";

    public void destroy() {
        LOG.debug((Object)"Destroying Struts-Layout plugin");
    }

    public void init(ActionServlet in_servlet, ModuleConfig in_config) throws ServletException {
        LOG.debug((Object)("Setting skin properties name to " + this.skinResources));
        Skin.setResourcesName(this.skinResources);
        boolean sortAction = false;
        boolean treeAction = false;
        boolean tabAction = false;
        boolean sortPath = false;
        boolean treePath = false;
        boolean tabPath = false;
        ActionConfig[] configs = in_config.findActionConfigs();
        int i = 0;
        while (i < configs.length) {
            if (SortAction.class.getName().equals(configs[i].getType())) {
                sortAction = true;
                LOG.debug((Object)("Found Struts-Layout sort action mapped to " + configs[i].getPath()));
            }
            if (SORT_PATH.equals(configs[i].getPath())) {
                sortPath = true;
            }
            if (TreeviewAction.class.getName().equals(configs[i].getType())) {
                treeAction = true;
                LOG.debug((Object)("Found Struts-Layout treeview action mapped to " + configs[i].getPath()));
            }
            if (TREEVIEW_PATH.equals(configs[i].getPath())) {
                treePath = true;
            }
            if (TabAction.class.getName().equals(configs[i].getType())) {
                tabAction = true;
                LOG.debug((Object)("Found Struts-Layout tab action mapped to " + configs[i].getPath()));
            }
            if (TAB_PATH.equals(configs[i].getPath())) {
                tabPath = true;
            }
            ++i;
        }
        if (!sortAction) {
            if (!sortPath) {
                ActionMapping config = new ActionMapping();
                config.setPath(SORT_PATH);
                config.setType(SortAction.class.getName());
                in_config.addActionConfig((ActionConfig)config);
                LOG.debug((Object)"Mapping Struts-Layout sort action to /sort");
            } else {
                LOG.warn((Object)"Don't mapping Struts-Layout sort action : /sort is already used");
            }
        }
        if (!treeAction) {
            if (!treePath) {
                ActionMapping config = new ActionMapping();
                config.setPath(TREEVIEW_PATH);
                config.setType(TreeviewAction.class.getName());
                in_config.addActionConfig((ActionConfig)config);
                LOG.debug((Object)"Mapping Struts-Layout sort action to /treeview");
            } else {
                LOG.warn((Object)"Don't mapping Struts-Layout treeview action : /treeview is already used");
            }
        }
        if (!tabAction) {
            if (!tabPath) {
                ActionMapping config = new ActionMapping();
                config.setPath(TAB_PATH);
                config.setType(TabAction.class.getName());
                in_config.addActionConfig((ActionConfig)config);
                LOG.debug((Object)"Mapping Struts-Layout tab action to /tab");
            } else {
                LOG.warn((Object)"Don't mapping Struts-Layout tab action : /tab is already used");
            }
        }
        LOG.debug((Object)"Struts-Layout plugin initialized");
    }

    public void setSkinResources(String in_skinResources) {
        this.skinResources = in_skinResources;
    }
}

