/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSButton;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSDefineButton
extends FSDefineObject {
    private ArrayList buttonRecords = null;
    private ArrayList actions = null;
    private byte[] encodedActions = null;

    public FSDefineButton(FSCoder fSCoder) {
        super(7, 0);
        this.decode(fSCoder);
    }

    public FSDefineButton(int n, ArrayList arrayList, ArrayList arrayList2) {
        super(7, n);
        this.setButtonRecords(arrayList);
        this.setActions(arrayList2);
    }

    public FSDefineButton(FSDefineButton fSDefineButton) {
        super(fSDefineButton);
        this.buttonRecords = new ArrayList();
        Iterator iterator = fSDefineButton.buttonRecords.iterator();
        while (iterator.hasNext()) {
            this.buttonRecords.add(((FSButton)iterator.next()).clone());
        }
        if (this.actions != null) {
            this.actions = new ArrayList();
            iterator = fSDefineButton.actions.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            this.encodedActions = Transform.clone(fSDefineButton.encodedActions);
        }
    }

    public FSDefineButton(int n, ArrayList arrayList, byte[] byArray) {
        super(7, n);
        this.setButtonRecords(arrayList);
        this.setEncodedActions(byArray);
    }

    public void add(FSButton fSButton) {
        this.buttonRecords.add(fSButton);
    }

    public void add(FSActionObject fSActionObject) {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        this.actions.add(fSActionObject);
    }

    public ArrayList getButtonRecords() {
        return this.buttonRecords;
    }

    public ArrayList getActions() {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        return this.actions;
    }

    public void setButtonRecords(ArrayList arrayList) {
        this.buttonRecords = arrayList;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
        this.encodedActions = null;
    }

    public byte[] getEncodedActions() {
        return this.encodedActions;
    }

    public void setEncodedActions(byte[] byArray) {
        this.encodedActions = byArray;
        this.actions = null;
    }

    public Object clone() {
        FSDefineButton fSDefineButton = (FSDefineButton)super.clone();
        fSDefineButton.buttonRecords = new ArrayList();
        Iterator iterator = this.buttonRecords.iterator();
        while (iterator.hasNext()) {
            fSDefineButton.buttonRecords.add(((FSButton)iterator.next()).clone());
        }
        if (this.actions != null) {
            fSDefineButton.actions = new ArrayList();
            iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                fSDefineButton.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            fSDefineButton.encodedActions = Transform.clone(this.encodedActions);
        }
        return fSDefineButton;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineButton fSDefineButton = (FSDefineButton)object;
            bl = this.buttonRecords != null ? this.buttonRecords.equals(fSDefineButton.buttonRecords) : this.buttonRecords == fSDefineButton.buttonRecords;
            bl = this.actions != null ? this.actions.equals(fSDefineButton.actions) : Transform.equals(this.encodedActions, fSDefineButton.encodedActions);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "buttonRecords", this.buttonRecords, n);
            if (this.actions != null) {
                Transform.append(stringBuffer, "actions", this.actions, n);
            } else {
                stringBuffer.append("actions = <data>; ");
            }
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        Iterator iterator = this.buttonRecords.iterator();
        while (iterator.hasNext()) {
            this.length += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        ++this.length;
        if (this.actions != null) {
            iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                FSActionObject fSActionObject = (FSActionObject)iterator.next();
                this.length += fSActionObject.length(fSCoder);
                this.length += fSActionObject.getType() > 128 ? 3 : 1;
            }
        } else {
            this.length += this.encodedActions.length;
        }
        ++this.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        Iterator iterator = this.buttonRecords.iterator();
        while (iterator.hasNext()) {
            ((FSTransformObject)iterator.next()).encode(fSCoder);
        }
        fSCoder.writeWord(0, 1);
        if (this.actions != null) {
            iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                FSActionObject fSActionObject = (FSActionObject)iterator.next();
                int n = fSCoder.getPointer();
                int n2 = fSCoder.getPointer() + (fSActionObject.getType() > 128 ? 24 : 8);
                int n3 = n2 + (fSActionObject.getLength() << 3);
                fSActionObject.encode(fSCoder);
                fSCoder.setPointer(n3);
                int n4 = fSCoder.getPointer() - n3 >> 3;
                if (n4 == 0) continue;
                fSCoder.context[14] = 1;
                fSCoder.context[15] = fSActionObject.getType();
                fSCoder.context[16] = n >>> 3;
                fSCoder.context[17] = n3 - n >>> 3;
                fSCoder.context[13] = n4;
            }
        } else {
            fSCoder.writeBytes(this.encodedActions);
        }
        fSCoder.writeWord(0, 1);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        int n = fSCoder.getPointer();
        this.buttonRecords = new ArrayList();
        while (fSCoder.scanWord(1, false) != 0) {
            this.buttonRecords.add(new FSButton(fSCoder));
        }
        fSCoder.readWord(1, false);
        int n2 = fSCoder.getPointer() - n >>> 3;
        if (fSCoder.context[18] == 1) {
            this.actions = new ArrayList();
            for (int i = n2; i > 1; i -= fSCoder.getPointer() - n >>> 3) {
                n = fSCoder.getPointer();
                this.actions.add(FSMovie.decodeAction(fSCoder));
            }
        } else {
            this.encodedActions = new byte[n2 - 1];
            fSCoder.readBytes(this.encodedActions);
        }
        fSCoder.readWord(1, false);
        fSCoder.endObject(this.name());
    }
}

