/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSBitmapFill;
import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSFillStyle;
import com.flagstone.transform.FSGradientFill;
import com.flagstone.transform.FSLineStyle;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSSolidFill;
import com.flagstone.transform.FSSolidLine;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSDefineShape
extends FSDefineObject {
    private FSBounds bounds = null;
    private ArrayList fillStyles = null;
    private ArrayList lineStyles = null;
    private FSShape shape = null;

    public FSDefineShape(FSCoder fSCoder) {
        super(2, 0);
        this.decode(fSCoder);
    }

    public FSDefineShape(int n, FSBounds fSBounds, ArrayList arrayList, ArrayList arrayList2, FSShape fSShape) {
        super(2, n);
        this.setBounds(fSBounds);
        this.setFillStyles(arrayList);
        this.setLineStyles(arrayList2);
        this.setShape(fSShape);
    }

    public FSDefineShape(FSDefineShape fSDefineShape) {
        super(fSDefineShape);
        this.bounds = new FSBounds(fSDefineShape.bounds);
        this.fillStyles = new ArrayList();
        Iterator iterator = fSDefineShape.fillStyles.iterator();
        while (iterator.hasNext()) {
            this.fillStyles.add(((FSFillStyle)iterator.next()).clone());
        }
        this.lineStyles = new ArrayList();
        iterator = fSDefineShape.lineStyles.iterator();
        while (iterator.hasNext()) {
            this.lineStyles.add(((FSLineStyle)iterator.next()).clone());
        }
        this.shape = new FSShape(fSDefineShape.shape);
    }

    public void add(FSLineStyle fSLineStyle) {
        this.lineStyles.add(fSLineStyle);
    }

    public void add(FSFillStyle fSFillStyle) {
        this.fillStyles.add(fSFillStyle);
    }

    public FSBounds getBounds() {
        return this.bounds;
    }

    public ArrayList getFillStyles() {
        return this.fillStyles;
    }

    public ArrayList getLineStyles() {
        return this.lineStyles;
    }

    public FSShape getShape() {
        return this.shape;
    }

    public void setBounds(FSBounds fSBounds) {
        this.bounds = fSBounds;
    }

    public void setFillStyles(ArrayList arrayList) {
        this.fillStyles = arrayList;
    }

    public void setLineStyles(ArrayList arrayList) {
        this.lineStyles = arrayList;
    }

    public void setShape(FSShape fSShape) {
        this.shape = fSShape;
    }

    public Object clone() {
        FSDefineShape fSDefineShape = (FSDefineShape)super.clone();
        fSDefineShape.bounds = this.bounds != null ? (FSBounds)this.bounds.clone() : null;
        fSDefineShape.fillStyles = new ArrayList();
        Iterator iterator = this.fillStyles.iterator();
        while (iterator.hasNext()) {
            fSDefineShape.fillStyles.add(((FSFillStyle)iterator.next()).clone());
        }
        fSDefineShape.lineStyles = new ArrayList();
        iterator = this.lineStyles.iterator();
        while (iterator.hasNext()) {
            fSDefineShape.lineStyles.add(((FSLineStyle)iterator.next()).clone());
        }
        fSDefineShape.shape = this.shape != null ? (FSShape)this.shape.clone() : null;
        return fSDefineShape;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineShape fSDefineShape = (FSDefineShape)object;
            if (this.bounds != null) {
                bl = this.bounds.equals(fSDefineShape.bounds);
            } else {
                boolean bl2 = bl = this.bounds == fSDefineShape.bounds;
            }
            if (this.fillStyles != null) {
                bl = bl && this.fillStyles.equals(fSDefineShape.fillStyles);
            } else {
                boolean bl3 = bl = bl && this.fillStyles == fSDefineShape.fillStyles;
            }
            if (this.lineStyles != null) {
                bl = bl && this.lineStyles.equals(fSDefineShape.lineStyles);
            } else {
                boolean bl4 = bl = bl && this.lineStyles == fSDefineShape.lineStyles;
            }
            bl = this.shape != null ? bl && this.shape.equals(fSDefineShape.shape) : bl && this.shape == fSDefineShape.shape;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "bounds", this.bounds, n);
            Transform.append(stringBuffer, "fillStyles", this.fillStyles, n);
            Transform.append(stringBuffer, "lineStyles", this.lineStyles, n);
            Transform.append(stringBuffer, "shape", this.shape, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = FSCoder.size(this.fillStyles.size(), false);
        int n2 = FSCoder.size(this.lineStyles.size(), false);
        super.length(fSCoder);
        this.length += this.bounds.length(fSCoder);
        ++this.length;
        Iterator iterator = this.fillStyles.iterator();
        while (iterator.hasNext()) {
            this.length += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        ++this.length;
        iterator = this.lineStyles.iterator();
        while (iterator.hasNext()) {
            this.length += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        fSCoder.context[6] = n;
        fSCoder.context[7] = n2;
        this.length += this.shape.length(fSCoder);
        fSCoder.context[6] = 0;
        fSCoder.context[7] = 0;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        int n = FSCoder.size(this.fillStyles.size(), false);
        int n2 = FSCoder.size(this.lineStyles.size(), false);
        super.encode(fSCoder);
        this.bounds.encode(fSCoder);
        fSCoder.writeWord(this.fillStyles.size(), 1);
        Iterator iterator = this.fillStyles.iterator();
        while (iterator.hasNext()) {
            ((FSTransformObject)iterator.next()).encode(fSCoder);
        }
        fSCoder.writeWord(this.lineStyles.size(), 1);
        iterator = this.lineStyles.iterator();
        while (iterator.hasNext()) {
            ((FSTransformObject)iterator.next()).encode(fSCoder);
        }
        fSCoder.context[6] = n;
        fSCoder.context[7] = n2;
        this.shape.encode(fSCoder);
        fSCoder.context[6] = 0;
        fSCoder.context[7] = 0;
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        int n;
        int n2 = 0;
        int n3 = 0;
        super.decode(fSCoder);
        int n4 = fSCoder.getPointer() - 16;
        this.bounds = new FSBounds(fSCoder);
        n2 = fSCoder.readWord(1, false);
        this.fillStyles = new ArrayList(n2);
        this.fillStyles = new ArrayList();
        block9: for (n = 0; n < n2; ++n) {
            switch (fSCoder.scanWord(1, false)) {
                case 0: {
                    this.fillStyles.add(new FSSolidFill(fSCoder));
                    continue block9;
                }
                case 16: {
                    this.fillStyles.add(new FSGradientFill(fSCoder));
                    continue block9;
                }
                case 18: {
                    this.fillStyles.add(new FSGradientFill(fSCoder));
                    continue block9;
                }
                case 64: {
                    this.fillStyles.add(new FSBitmapFill(fSCoder));
                    continue block9;
                }
                case 65: {
                    this.fillStyles.add(new FSBitmapFill(fSCoder));
                    continue block9;
                }
                case 66: {
                    this.fillStyles.add(new FSBitmapFill(fSCoder));
                    continue block9;
                }
                case 67: {
                    this.fillStyles.add(new FSBitmapFill(fSCoder));
                    continue block9;
                }
            }
        }
        n3 = fSCoder.readWord(1, false);
        this.lineStyles = new ArrayList(n3);
        for (n = 0; n < n3; ++n) {
            this.lineStyles.add(new FSSolidLine(fSCoder));
        }
        n = fSCoder.getPointer() - n4 >> 3;
        this.shape = fSCoder.context[19] == 1 ? new FSShape(fSCoder) : new FSShape(fSCoder, this.length - n);
        fSCoder.endObject(this.name());
    }
}

