/*
 * Decompiled with CFR 0.152.
 */
package cn.bluejoe.elfinder.controller.executor;

import cn.bluejoe.elfinder.service.FsItem;
import cn.bluejoe.elfinder.service.FsService;
import cn.bluejoe.elfinder.service.FsVolume;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FsItemEx {
    private FsItem _f;
    private FsService _s;
    private FsVolume _v;

    public FsItemEx(FsItem fsi, FsService fsService) {
        this._f = fsi;
        this._v = fsi.getVolume();
        this._s = fsService;
    }

    public FsItemEx(FsItemEx parent, String name) throws IOException {
        this._v = parent._v;
        this._s = parent._s;
        this._f = this._v.fromPath(String.valueOf(this._v.getPath(parent._f)) + "/" + name);
    }

    public FsItemEx createChild(String name) throws IOException {
        return new FsItemEx(this, name);
    }

    public void createFile() throws IOException {
        this._v.createFile(this._f);
    }

    public void createFolder() throws IOException {
        this._v.createFolder(this._f);
    }

    public void delete() throws IOException {
        if (this._v.isFolder(this._f)) {
            this._v.deleteFolder(this._f);
        } else {
            this._v.deleteFile(this._f);
        }
    }

    public void deleteFile() throws IOException {
        this._v.deleteFile(this._f);
    }

    public void deleteFolder() throws IOException {
        this._v.deleteFolder(this._f);
    }

    public boolean exists() {
        return this._v.exists(this._f);
    }

    public String getHash() throws IOException {
        return this._s.getHash(this._f);
    }

    public long getLastModified() {
        return this._v.getLastModified(this._f);
    }

    public String getMimeType() {
        return this._v.getMimeType(this._f);
    }

    public String getName() {
        return this._v.getName(this._f);
    }

    public FsItemEx getParent() {
        return new FsItemEx(this._v.getParent(this._f), this._s);
    }

    public String getPath() throws IOException {
        return this._v.getPath(this._f);
    }

    public long getSize() {
        return this._v.getSize(this._f);
    }

    public String getVolumeId() {
        return this._s.getVolumeId(this._v);
    }

    public String getVolumnName() {
        return this._v.getName();
    }

    public boolean hasChildFolder() {
        return this._v.hasChildFolder(this._f);
    }

    public boolean isFolder() {
        return this._v.isFolder(this._f);
    }

    public boolean isLocked(FsItemEx fsi) throws IOException {
        return this._s.getSecurityChecker().isLocked(this._s, this._f);
    }

    public boolean isReadable(FsItemEx fsi) throws IOException {
        return this._s.getSecurityChecker().isReadable(this._s, this._f);
    }

    public boolean isRoot() {
        return this._v.isRoot(this._f);
    }

    public boolean isWritable(FsItemEx fsi) throws IOException {
        return this._s.getSecurityChecker().isWritable(this._s, this._f);
    }

    public List<FsItemEx> listChildren() {
        ArrayList<FsItemEx> list = new ArrayList<FsItemEx>();
        FsItem[] fsItemArray = this._v.listChildren(this._f);
        int n = fsItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            FsItem child = fsItemArray[n2];
            list.add(new FsItemEx(child, this._s));
            ++n2;
        }
        return list;
    }

    public InputStream openInputStream() throws IOException {
        return this._v.openInputStream(this._f);
    }

    public OutputStream openOutputStream() throws IOException {
        return this._v.openOutputStream(this._f);
    }

    public void renameTo(FsItemEx dst) throws IOException {
        this._v.rename(this._f, dst._f);
    }
}

