/*
 * Decompiled with CFR 0.152.
 */
package cn.bluejoe.elfinder.controller.executors;

import cn.bluejoe.elfinder.controller.executor.AbstractJsonCommandExecutor;
import cn.bluejoe.elfinder.controller.executor.CommandExecutor;
import cn.bluejoe.elfinder.controller.executor.FsItemEx;
import cn.bluejoe.elfinder.service.FsService;
import cn.bluejoe.elfinder.service.FsVolume;
import java.util.LinkedHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class OpenCommandExecutor
extends AbstractJsonCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(FsService fsService, HttpServletRequest request, ServletContext servletContext, JSONObject json) throws Exception {
        boolean init = request.getParameter("init") != null;
        boolean tree = request.getParameter("tree") != null;
        String target = request.getParameter("target");
        LinkedHashMap<String, FsItemEx> files = new LinkedHashMap<String, FsItemEx>();
        if (init) {
            json.put("api", 2.1);
            json.put("netDrivers", (Object)new Object[0]);
        }
        if (tree) {
            FsVolume[] fsVolumeArray = fsService.getVolumes();
            int n = fsVolumeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FsVolume v = fsVolumeArray[n2];
                FsItemEx root = new FsItemEx(v.getRoot(), fsService);
                files.put(root.getHash(), root);
                this.addSubfolders(files, root);
                ++n2;
            }
        }
        FsItemEx cwd = this.findCwd(fsService, target);
        files.put(cwd.getHash(), cwd);
        this.addChildren(files, cwd);
        json.put("files", (Object)this.files2JsonArray(request, files.values()));
        json.put("cwd", this.getFsItemInfo(request, cwd));
        json.put("options", this.getOptions(request, cwd));
    }
}

