/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.rs.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import cz.rtnext.rs.data.Obsah;
import cz.rtnext.rs.service.DefaultUpdateListener;
import java.beans.PropertyVetoException;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.orm.hibernate4.HibernateTransactionManager;
import org.springframework.orm.hibernate4.LocalSessionFactoryBuilder;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajSoapMessageFactory;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.HttpUrlConnectionMessageSender;

@Configuration
@ComponentScan(basePackages={"cz.rtnext.rs.service", "cz.rtnext.smartclient.service"})
@EnableTransactionManagement
@PropertySource(value={"classpath:META-INF/spring/database.properties", "classpath:cz/triangle/domy/ApplicationResources.properties"})
@Lazy
public class SpringApplicationConfig {
    @Autowired
    public Environment env;
    @Autowired
    private ApplicationContext ctx;
    @Autowired
    private DefaultUpdateListener defaultUpdateListener;

    @Bean
    public DataSource dataSource() throws PropertyVetoException {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(this.env.getProperty("database.driverClassName"));
        dataSource.setJdbcUrl(this.env.getProperty("database.url"));
        dataSource.setUser(this.env.getProperty("database.username"));
        dataSource.setPassword(this.env.getProperty("database.password"));
        dataSource.setMaxPoolSize(10);
        dataSource.setMaxStatements(0);
        dataSource.setMinPoolSize(5);
        return dataSource;
    }

    @Bean
    public SessionFactory sessionFactory() throws PropertyVetoException {
        LocalSessionFactoryBuilder sessionFactoryBuilder = new LocalSessionFactoryBuilder(this.dataSource());
        sessionFactoryBuilder.setNamingStrategy((NamingStrategy)new ImprovedNamingStrategy());
        String hibernateAuto = this.env.getProperty("hibernate.hbm2ddl.auto");
        if (hibernateAuto != null && hibernateAuto.trim().length() > 0) {
            sessionFactoryBuilder.setProperty("hibernate.hbm2ddl.auto", hibernateAuto);
        }
        sessionFactoryBuilder.setProperty("hibernate.dialect", "org.hibernate.dialect.PostgreSQLDialect");
        sessionFactoryBuilder.setProperty("hibernate.current_session_context_class", "org.springframework.orm.hibernate4.SpringSessionContext");
        sessionFactoryBuilder.scanPackages(new String[]{"cz.rtnext.rs.data"});
        sessionFactoryBuilder.scanPackages(new String[]{"cz.triangle.elementy"});
        sessionFactoryBuilder.addAnnotatedClass(Obsah.class);
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypProstor.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypPolozkyMenu.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/PolozkaMenu.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Dum.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypPodlazi.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Byt.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Rd.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypStavu.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Podlazi.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Lokalita.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypBloku.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Stanoviste.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/BytJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/RdJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/LokalitaJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/StanovisteJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypPodlaziJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypProstorJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypStavuJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Jazyk.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/NebytovaProstora.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/NebytovaProstoraJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypAktualityJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypAktuality.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Aktualita.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Fotogalerie.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Obrazek.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/ObrazekJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/SkupinaFotogalerie.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/SkupinaFotogalerieJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypOblastiJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypOblasti.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Upoutavka.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypStavuLokality.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Mistnost.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/MistnostJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/elementy/PolozkaObjektu.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/elementy/Objekt.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/elementy/ZasilaniObjektu.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/elementy/Historie.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/BlokDoplnek.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/Uzivatel.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypNebytoveProstoryJaz.hbm.xml");
        sessionFactoryBuilder.addResource("cz/triangle/domy/TypNebytoveProstory.hbm.xml");
        SessionFactory sessionFactory = sessionFactoryBuilder.buildSessionFactory();
        return sessionFactory;
    }

    @Bean
    @Primary
    public HibernateTransactionManager transactionManager() throws PropertyVetoException {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager(this.sessionFactory());
        return transactionManager;
    }

    @Bean
    SaajSoapMessageFactory messageFactory() {
        SaajSoapMessageFactory messageFactory = new SaajSoapMessageFactory();
        messageFactory.setSoapVersion(SoapVersion.SOAP_12);
        return messageFactory;
    }

    @Bean
    public Jaxb2Marshaller jaxbMarshaller() {
        Jaxb2Marshaller jaxbMarshaller = new Jaxb2Marshaller();
        jaxbMarshaller.setContextPath("cz.rtnext.rs.bwwsdl");
        return jaxbMarshaller;
    }

    @Bean
    public HttpUrlConnectionMessageSender messageSender() {
        HttpUrlConnectionMessageSender messageSender = new HttpUrlConnectionMessageSender();
        return messageSender;
    }

    @Bean
    public WebServiceTemplate webServiceTemplate() {
        WebServiceTemplate webServiceTemplate = new WebServiceTemplate((WebServiceMessageFactory)this.messageFactory());
        webServiceTemplate.setMessageSender((WebServiceMessageSender)this.messageSender());
        webServiceTemplate.setDefaultUri("http://webexport.realko.cz/WebExport.asmx");
        webServiceTemplate.setMarshaller((Marshaller)this.jaxbMarshaller());
        webServiceTemplate.setUnmarshaller((Unmarshaller)this.jaxbMarshaller());
        return webServiceTemplate;
    }
}

