/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.rs.service;

import cz.rtnext.rs.data.Estate;
import cz.triangle.domy.Byt;
import cz.triangle.domy.BytJaz;
import cz.triangle.domy.Dum;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Lokalita;
import cz.triangle.domy.NebytovaProstora;
import cz.triangle.domy.NebytovaProstoraJaz;
import cz.triangle.domy.Podlazi;
import cz.triangle.domy.Rd;
import cz.triangle.domy.RdJaz;
import cz.triangle.domy.TypBloku;
import cz.triangle.domy.TypNebytoveProstory;
import cz.triangle.domy.TypPodlazi;
import cz.triangle.domy.TypPodlaziJaz;
import cz.triangle.domy.TypProstor;
import cz.triangle.domy.TypProstorJaz;
import cz.triangle.domy.TypStavu;
import cz.triangle.domy.TypStavuJaz;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Lazy
public class EstateService {
    @Autowired
    private ApplicationContext ctx;
    @Autowired
    private SessionFactory sessionFactory;
    private static final Map<Integer, String> dispoziceMap;
    private static final Map<Integer, String> podlaziMap;

    static {
        HashMap<Integer, String> aMap = new HashMap<Integer, String>();
        aMap.put(1, "Garsoniera");
        aMap.put(2, "1+kk");
        aMap.put(3, "1+1");
        aMap.put(4, "2+kk");
        aMap.put(5, "2+1");
        aMap.put(6, "3+kk");
        aMap.put(7, "3+1");
        aMap.put(8, "4+kk");
        aMap.put(9, "4+1");
        aMap.put(10, "5+1");
        aMap.put(11, "4+2");
        aMap.put(12, "5+2");
        aMap.put(13, "6+1");
        aMap.put(14, "6+2");
        aMap.put(15, "7+1");
        aMap.put(16, "7+2");
        aMap.put(17, "8+1");
        aMap.put(18, "8+2");
        aMap.put(19, "9+1");
        aMap.put(20, "9+2");
        aMap.put(21, "V\u011bt\u0161\u00ed ne\u017e 9+2");
        aMap.put(22, "5+kk");
        aMap.put(23, "6+kk");
        aMap.put(24, "7+kk");
        dispoziceMap = Collections.unmodifiableMap(aMap);
        aMap = new HashMap();
        aMap.put(1, "1. patro");
        aMap.put(2, "2. patro");
        aMap.put(3, "3. patro");
        aMap.put(4, "4. patro");
        aMap.put(5, "5. patro");
        aMap.put(6, "6. patro");
        aMap.put(7, "7. patro");
        aMap.put(8, "8. patro");
        aMap.put(9, "9. patro");
        aMap.put(10, "10. patro");
        aMap.put(11, "11. patro");
        aMap.put(12, "12. patro");
        aMap.put(13, "13. patro");
        aMap.put(14, "14. patro");
        aMap.put(15, "15. patro");
        aMap.put(16, "16. patro");
        aMap.put(17, "17. patro");
        aMap.put(18, "18. patro");
        aMap.put(19, "19. patro");
        aMap.put(20, "20. patro");
        aMap.put(999, "Vy\u0161\u0161\u00ed");
        aMap.put(1000, "P\u0159\u00edzem\u00ed");
        aMap.put(1001, "Sn\u00ed\u017een\u00e9 p\u0159\u00edzem\u00ed");
        aMap.put(1002, "Suter\u00e9n");
        aMap.put(1004, "Zv\u00fd\u0161en\u00e9 p\u0159\u00edzem\u00ed");
        podlaziMap = Collections.unmodifiableMap(aMap);
    }

    @Transactional
    public void synchronizuj(Estate estate) {
        if (estate.getIdProjektu() == null) {
            return;
        }
        if (estate.getTypeOfRealEstateLong().equals(1L)) {
            this.synchronizujByt(estate);
        } else if (estate.getTypeOfRealEstateLong().equals(2L)) {
            this.synchronizujRd(estate);
        } else if (estate.getTypeOfRealEstateLong().equals(5L)) {
            this.synchronizujRd(estate);
        } else if (estate.getTypeOfRealEstateLong().equals(4L)) {
            this.synchronizujByt(estate);
        }
    }

    @Transactional
    private void synchronizujByt(Estate estate) {
        List lokality;
        if (estate.getFloorLong() == null) {
            return;
        }
        String nazevDomu = "A";
        if (estate.getUfProjektFaze() != null && estate.getUfProjektFaze().trim().length() > 0) {
            nazevDomu = estate.getUfProjektFaze();
        }
        boolean i = false;
        Jazyk jazyk = (Jazyk)this.sessionFactory.getCurrentSession().load(Jazyk.class, (Serializable)((Object)"cz"));
        TypBloku prazdnyTypBloku = (TypBloku)this.sessionFactory.getCurrentSession().load(TypBloku.class, (Serializable)new Integer(1));
        Byt byt = null;
        BytJaz bytJaz = null;
        if (estate.getByt() == null) {
            byt = new Byt();
            bytJaz = new BytJaz();
            bytJaz.setByt(byt);
            bytJaz.setJazyk(jazyk);
            byt.setTypBloku(prazdnyTypBloku);
        } else {
            byt = estate.getByt();
            bytJaz = (BytJaz)byt.getBytJazs().get(jazyk.getId());
        }
        TypProstor typProstor = null;
        if (estate.getTypeOfRealEstateLong().equals(4L)) {
            typProstor = (TypProstor)this.sessionFactory.getCurrentSession().load(TypProstor.class, (Serializable)new Integer(100));
        } else {
            Integer idDispozice = estate.getDispositionLong().intValue();
            String nazevDispozice = dispoziceMap.get(idDispozice);
            typProstor = (TypProstor)this.sessionFactory.getCurrentSession().get(TypProstor.class, (Serializable)idDispozice);
            if (typProstor == null) {
                typProstor = new TypProstor();
                typProstor.setId(idDispozice);
                this.sessionFactory.getCurrentSession().save((Object)typProstor);
                TypProstorJaz typProstorJaz = new TypProstorJaz();
                typProstorJaz.setId(idDispozice);
                typProstorJaz.setJazyk(jazyk);
                typProstorJaz.setNazev(nazevDispozice);
                typProstorJaz.setTypProstor(typProstor);
                this.sessionFactory.getCurrentSession().save((Object)typProstorJaz);
            }
        }
        HashMap<Long, String> typyStavuMap = new HashMap<Long, String>();
        typyStavuMap.put(2L, "volne");
        typyStavuMap.put(3L, "rezervace");
        typyStavuMap.put(4L, "prodano");
        String idTypStavus = (String)typyStavuMap.get(estate.getStatusOfCommissionLong());
        String nazevStavu = estate.getStatusOfCommissionString();
        TypStavu typStavu = (TypStavu)this.sessionFactory.getCurrentSession().get(TypStavu.class, (Serializable)((Object)idTypStavus));
        if (typStavu == null) {
            typStavu = new TypStavu();
            typStavu.setId(idTypStavus);
            this.sessionFactory.getCurrentSession().save((Object)typStavu);
            TypStavuJaz typStavuJaz = new TypStavuJaz();
            typStavuJaz.setJazyk(jazyk);
            typStavuJaz.setNazev(nazevStavu);
            typStavuJaz.setTypStavu(typStavu);
            this.sessionFactory.getCurrentSession().save((Object)typStavuJaz);
        }
        Integer idPodlazi = estate.getFloorLong().intValue();
        String nazevPodlazi = podlaziMap.get(idPodlazi);
        TypPodlazi typPodlazi = (TypPodlazi)this.sessionFactory.getCurrentSession().get(TypPodlazi.class, (Serializable)idPodlazi);
        if (typPodlazi == null) {
            typPodlazi = new TypPodlazi();
            typPodlazi.setId(idPodlazi);
            typPodlazi.setRazeni(idPodlazi);
            this.sessionFactory.getCurrentSession().save((Object)typPodlazi);
            TypPodlaziJaz typPodlaziJaz = new TypPodlaziJaz();
            typPodlaziJaz.setJazyk(jazyk);
            typPodlaziJaz.setNazev(nazevPodlazi);
            typPodlaziJaz.setTypPodlazi(typPodlazi);
            this.sessionFactory.getCurrentSession().save((Object)typPodlaziJaz);
        }
        if ((lokality = this.sessionFactory.getCurrentSession().createQuery("from Lokalita lokalita where lokalita.idProjektBw=?").setLong(0, estate.getIdProjektu().longValue()).list()).size() == 0) {
            return;
        }
        Lokalita lokalita = (Lokalita)lokality.get(0);
        List domy = this.sessionFactory.getCurrentSession().createQuery("from Dum dum where dum.lokalita=? and dum.nazev=?").setEntity(0, (Object)lokalita).setString(1, nazevDomu).list();
        Dum dum = null;
        if (domy.size() == 0) {
            dum = new Dum();
            dum.setLokalita(lokalita);
            dum.setNazev(nazevDomu);
            dum.setRazeni(10);
            this.sessionFactory.getCurrentSession().save((Object)dum);
        } else {
            dum = (Dum)domy.get(0);
        }
        List listPodlazi = this.sessionFactory.getCurrentSession().createQuery("from Podlazi podlazi where podlazi.dum=? and podlazi.typPodlazi=?").setEntity(0, (Object)dum).setInteger(1, typPodlazi.getId().intValue()).list();
        Podlazi podlazi = null;
        if (listPodlazi.size() == 0) {
            podlazi = new Podlazi();
            podlazi.setDum(dum);
            podlazi.setTypPodlazi(typPodlazi);
            this.sessionFactory.getCurrentSession().save((Object)podlazi);
        } else {
            podlazi = (Podlazi)listPodlazi.get(0);
        }
        byt.setPodlazi(podlazi);
        byt.setTypProstor(typProstor);
        byt.setBytovaPlocha(estate.getAreaFloor() != null ? estate.getAreaFloor().doubleValue() : 0.0);
        byt.setCenaSDph(estate.getPrice() != null ? estate.getPrice().doubleValue() : 0.0);
        byt.setCisloBytu(estate.getNumberOfApartment());
        byt.setPodlahovaPlocha(estate.getAreaFloor() != null ? estate.getAreaFloor().doubleValue() : 0.0);
        byt.setSklad(estate.getAreaOfStorage() != null ? estate.getAreaOfStorage().doubleValue() : 0.0);
        byt.setTerasa(estate.getAreaOfTerrace() != null ? estate.getAreaOfTerrace().doubleValue() : 0.0);
        byt.setTypStavu(typStavu);
        byt.setZmena(estate.getDateOfUpdateDate());
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)byt);
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)bytJaz);
        estate.setByt(byt);
    }

    @Transactional
    private void synchronizujRd(Estate estate) {
        Jazyk jazyk = (Jazyk)this.sessionFactory.getCurrentSession().load(Jazyk.class, (Serializable)((Object)"cz"));
        TypBloku prazdnyTypBloku = (TypBloku)this.sessionFactory.getCurrentSession().load(TypBloku.class, (Serializable)new Integer(1));
        List lokality = this.sessionFactory.getCurrentSession().createQuery("from Lokalita lokalita where lokalita.idProjektBw=?").setLong(0, estate.getIdProjektu().longValue()).list();
        if (lokality.size() == 0) {
            return;
        }
        Lokalita lokalita = (Lokalita)lokality.get(0);
        Rd rd = null;
        RdJaz rdJaz = null;
        if (estate.getRd() == null) {
            rd = new Rd();
            rd.setTypBloku(prazdnyTypBloku);
            rdJaz = new RdJaz();
            rdJaz.setRd(rd);
            rdJaz.setJazyk(jazyk);
        } else {
            rd = estate.getRd();
            rdJaz = (RdJaz)rd.getRdJazs().get(jazyk.getId());
        }
        Integer idTypStavu = estate.getStatusOfCommissionLong().intValue();
        String nazevStavu = estate.getStatusOfCommissionString();
        TypStavu typStavu = (TypStavu)this.sessionFactory.getCurrentSession().get(TypStavu.class, (Serializable)((Object)idTypStavu.toString()));
        if (typStavu == null) {
            typStavu = new TypStavu();
            typStavu.setId(idTypStavu.toString());
            this.sessionFactory.getCurrentSession().save((Object)typStavu);
            TypStavuJaz typStavuJaz = new TypStavuJaz();
            typStavuJaz.setJazyk(jazyk);
            typStavuJaz.setNazev(nazevStavu);
            typStavuJaz.setTypStavu(typStavu);
            this.sessionFactory.getCurrentSession().save((Object)typStavuJaz);
        }
        rd.setCenaSDph(estate.getPrice() != null ? estate.getPrice().doubleValue() : 0.0);
        rd.setCisloBytu(estate.getRegistrationNumber());
        rd.setDumPlocha(estate.getAreaBuiltUp() != null ? estate.getAreaBuiltUp().doubleValue() : 0.0);
        rd.setPozemekPlocha(estate.getAreaOfLot() != null ? estate.getAreaOfLot().doubleValue() : 0.0);
        rd.setLokalita(lokalita);
        rd.setTypStavu(typStavu);
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)rd);
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)rdJaz);
        estate.setRd(rd);
    }

    @Transactional
    private void synchronizujNebytovaProstora(Estate estate) {
        Jazyk jazyk = (Jazyk)this.sessionFactory.getCurrentSession().load(Jazyk.class, (Serializable)((Object)"cz"));
        TypBloku prazdnyTypBloku = (TypBloku)this.sessionFactory.getCurrentSession().load(TypBloku.class, (Serializable)new Integer(1));
        TypNebytoveProstory komercniTypNebytoveProstory = (TypNebytoveProstory)this.sessionFactory.getCurrentSession().load(TypNebytoveProstory.class, (Serializable)((Object)"komercni_plocha"));
        List lokality = this.sessionFactory.getCurrentSession().createQuery("from Lokalita lokalita where lokalita.idProjektBw=?").setLong(0, estate.getIdProjektu().longValue()).list();
        if (lokality.size() == 0) {
            return;
        }
        Lokalita lokalita = (Lokalita)lokality.get(0);
        String nazevDomu = "A";
        if (estate.getUfProjektFaze() != null && estate.getUfProjektFaze().trim().length() > 0) {
            nazevDomu = estate.getUfProjektFaze();
        }
        NebytovaProstora nebytovaProstora = null;
        NebytovaProstoraJaz nebytovaProstoraJaz = null;
        if (estate.getRd() == null) {
            nebytovaProstora = new NebytovaProstora();
            nebytovaProstora.setTypBloku(prazdnyTypBloku);
            nebytovaProstoraJaz = new NebytovaProstoraJaz();
            nebytovaProstoraJaz.setNebytovaProstora(nebytovaProstora);
            nebytovaProstoraJaz.setJazyk(jazyk);
        } else {
            nebytovaProstora = estate.getNebytovaProstora();
            nebytovaProstoraJaz = (NebytovaProstoraJaz)nebytovaProstora.getNebytovaProstoraJazs().get(jazyk.getId());
        }
        Integer idTypStavu = estate.getStatusOfCommissionLong().intValue();
        String nazevStavu = estate.getStatusOfCommissionString();
        TypStavu typStavu = (TypStavu)this.sessionFactory.getCurrentSession().get(TypStavu.class, (Serializable)((Object)idTypStavu.toString()));
        if (typStavu == null) {
            typStavu = new TypStavu();
            typStavu.setId(idTypStavu.toString());
            this.sessionFactory.getCurrentSession().save((Object)typStavu);
            TypStavuJaz typStavuJaz = new TypStavuJaz();
            typStavuJaz.setJazyk(jazyk);
            typStavuJaz.setNazev(nazevStavu);
            typStavuJaz.setTypStavu(typStavu);
            this.sessionFactory.getCurrentSession().save((Object)typStavuJaz);
        }
        List domy = this.sessionFactory.getCurrentSession().createQuery("from Dum dum where dum.lokalita=? and dum.nazev=?").setEntity(0, (Object)lokalita).setString(1, nazevDomu).list();
        Dum dum = null;
        if (domy.size() == 0) {
            dum = new Dum();
            dum.setLokalita(lokalita);
            dum.setNazev(nazevDomu);
            dum.setRazeni(10);
            this.sessionFactory.getCurrentSession().save((Object)dum);
        } else {
            dum = (Dum)domy.get(0);
        }
        nebytovaProstora.setDum(dum);
        nebytovaProstora.setOznaceni(estate.getRegistrationNumber());
        nebytovaProstora.setCenaSklad(estate.getPrice() != null ? estate.getPrice().doubleValue() : 0.0);
        nebytovaProstora.setSkladPlocha(estate.getAreaNonResidential() != null ? estate.getAreaNonResidential().doubleValue() : 0.0);
        nebytovaProstora.setTypStavu(typStavu);
        nebytovaProstora.setTypNebytoveProstory(komercniTypNebytoveProstory);
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)nebytovaProstora);
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)nebytovaProstoraJaz);
        estate.setNebytovaProstora(nebytovaProstora);
    }

    @Transactional
    public void synchronizujByty() {
        List seznamObjektu = this.sessionFactory.getCurrentSession().createQuery("from Estate estate where estate.idProjektu is not null").list();
        for (Estate estate : seznamObjektu) {
            this.synchronizuj(estate);
        }
    }

    @Transactional
    public void synchronizujByt(long estateId) {
        List seznamObjektu = this.sessionFactory.getCurrentSession().createQuery("from Estate estate where estate.id=?").setLong(0, estateId).list();
        if (seznamObjektu.size() > 0) {
            Estate estate = (Estate)seznamObjektu.get(0);
            this.synchronizuj(estate);
        }
    }
}

