/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.action;

import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.form.AdminObsahForm;
import cz.triangle.domy.www.ClankyDelegate;
import cz.triangle.domy.www.LokalitaDelegate;
import cz.triangle.domy.www.ObsahDelegate;
import cz.triangle.util.HibernateUtil;
import fr.improve.struts.taglib.layout.menu.MenuComponent;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class AdminObsahAction
extends Action {
    private final String AKCE_EDITACE_DOKUMENTU = "editace_dokumentu";
    private final String AKCE_NOVY_DOKUMENT = "novy_dokument";
    private final String AKCE_ZAPSAT_NOVY_DOKUMENT = "zapsat_novy_dokument";
    private final String AKCE_ZAPSAT_DOKUMENT = "zapsat_dokument";
    private final String AKCE_SMAZAT_DOKUMENT = "smazat_dokument";
    private final String AKCE = "akce";
    private final String FORM = "adminObsahForm";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("seznamJazyku", (Object)LokalitaDelegate.getSeznamJazyku(HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession()));
        String idJazyk = ClankyDelegate.nactiJazyk(request, HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession());
        String akce = request.getParameter("akce");
        if (akce != null) {
            if (akce.equalsIgnoreCase("sitemap")) {
                return this.sitemap(request, response, idJazyk);
            }
            if (akce.equalsIgnoreCase("editace_dokumentu")) {
                return this.editacePolozky(mapping, form, request, response, request.getParameter("id"), null, idJazyk);
            }
            if (akce.equalsIgnoreCase("novy_dokument")) {
                return this.novaPolozka(mapping, form, request, response, request.getParameter("id"), null, idJazyk);
            }
            if (akce.equalsIgnoreCase("zapsat_novy_dokument")) {
                return this.zapsatNovouPolozku(mapping, form, request, response, idJazyk);
            }
            if (akce.equalsIgnoreCase("zapsat_dokument")) {
                return this.zapsatPolozku(mapping, form, request, response, request.getParameter("id"), idJazyk);
            }
            if (akce.equalsIgnoreCase("smazat_dokument")) {
                return this.smazatPolozku(mapping, form, request, response, request.getParameter("id"), idJazyk);
            }
        }
        return this.vypis(mapping, form, request, response, null, null, "vypis", idJazyk);
    }

    private ActionForward sitemap(HttpServletRequest request, HttpServletResponse response, String idJazyk) {
        response.setContentType("text/xml;charset=UTF-8");
        try {
            SimpleDateFormat sitemapDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date();
            PrintWriter sitemapWriter = response.getWriter();
            String url = String.valueOf(request.getScheme()) + "://" + request.getServerName() + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort()) + (request.getContextPath().equalsIgnoreCase("/") ? "" : request.getContextPath());
            sitemapWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sitemapWriter.write("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n");
            List polozky = HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession().createQuery("from PolozkaMenu").list();
            for (PolozkaMenu polozkaMenu : polozky) {
                sitemapWriter.write("\t<url>\n");
                sitemapWriter.write("\t\t<loc><![CDATA[" + url + "/" + polozkaMenu.getKod() + "/" + "]]></loc>\n");
                sitemapWriter.write("\t\t<lastmod>" + sitemapDateFormat.format(date) + "</lastmod>\n");
                sitemapWriter.write("\t</url>\n");
            }
            sitemapWriter.write("</urlset>\n");
            sitemapWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ActionForward vypis(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String id, String typ, String obsah, String idJazyk) {
        ClankyDelegate cd = new ClankyDelegate(idJazyk, mapping.getPath(), this.getResources(request));
        Map vysledek = cd.nactiMenu(typ, id, HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession());
        if (vysledek.get("chyba") != null) {
            request.setAttribute("akce", null);
            return this.vypis(mapping, form, request, response, null, null, "vypis", idJazyk);
        }
        MenuComponent root = (MenuComponent)vysledek.get("strom");
        LayoutUtils.addMenuIntoSession((HttpServletRequest)request, (MenuComponent)root);
        cd.otevriVybrany();
        return mapping.findForward(obsah);
    }

    private ActionForward editacePolozky(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String id, AdminObsahForm f, String idJazyk) {
        ObsahDelegate dd = new ObsahDelegate(idJazyk, this.getResources(request));
        Map vysledek = dd.editacePolozky(id, f, HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession());
        this.ulozAtributy(request, vysledek);
        if (vysledek.get("chyba") != null) {
            request.setAttribute("akce", null);
            return this.vypis(mapping, form, request, response, null, null, "vypis", idJazyk);
        }
        request.setAttribute("akce", (Object)"editace_dokumentu");
        AdminObsahForm novyForm = (AdminObsahForm)((Object)vysledek.get("adminObsahForm"));
        return this.vypis(mapping, form, request, response, "dokument", novyForm.getAtribut("id"), "editace_dokumentu", idJazyk);
    }

    private ActionForward novaPolozka(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String id, AdminObsahForm f, String idJazyk) {
        ObsahDelegate dd = new ObsahDelegate(idJazyk, this.getResources(request));
        Map vysledek = dd.novaPolozka(id, f, HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession(), request.getParameter("trida"));
        this.ulozAtributy(request, vysledek);
        if (vysledek.get("chyba") != null) {
            request.setAttribute("akce", null);
            return this.vypis(mapping, form, request, response, null, null, "vypis", idJazyk);
        }
        request.setAttribute("akce", (Object)"novy_dokument");
        return this.vypis(mapping, form, request, response, "polozka", id, "editace_dokumentu", idJazyk);
    }

    private ActionForward zapsatNovouPolozku(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String idJazyk) {
        ObsahDelegate cd = new ObsahDelegate(idJazyk, this.getResources(request));
        String cesta = this.servlet.getServletContext().getRealPath("/");
        String user = request.getRemoteUser();
        Map vysledek = cd.zapsatNovouPolozku((AdminObsahForm)form, mapping, request, HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession(), cesta, user);
        this.ulozAtributy(request, vysledek);
        if (vysledek.get("validacni_chyba") != null) {
            AdminObsahForm f = (AdminObsahForm)((Object)vysledek.get("adminObsahForm"));
            request.setAttribute("akce", (Object)"novy_dokument");
            return this.novaPolozka(mapping, form, request, response, f.getAtribut("kodPolozka"), f, idJazyk);
        }
        if (vysledek.get("chyba") != null) {
            request.setAttribute("akce", null);
            return this.vypis(mapping, form, request, response, null, null, "vypis", idJazyk);
        }
        request.setAttribute("akce", (Object)"editace_dokumentu");
        Integer noveId = (Integer)vysledek.get("id");
        return this.editacePolozky(mapping, form, request, response, noveId.toString(), null, idJazyk);
    }

    private ActionForward zapsatPolozku(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String staryKod, String idJazyk) {
        ObsahDelegate dd = new ObsahDelegate(idJazyk, this.getResources(request));
        String cesta = this.servlet.getServletContext().getRealPath("/");
        String user = request.getRemoteUser();
        Map vysledek = dd.zapsatPolozku((AdminObsahForm)form, staryKod, mapping, request, HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession(), cesta, user);
        this.ulozAtributy(request, vysledek);
        if (vysledek.get("validacni_chyba") != null) {
            AdminObsahForm f = (AdminObsahForm)((Object)vysledek.get("adminObsahForm"));
            request.setAttribute("akce", (Object)"editace_dokumentu");
            return this.editacePolozky(mapping, form, request, response, staryKod, f, idJazyk);
        }
        if (vysledek.get("chyba") != null) {
            request.setAttribute("akce", null);
            return this.vypis(mapping, form, request, response, null, null, "vypis", idJazyk);
        }
        request.setAttribute("akce", (Object)"editace_dokumentu");
        Integer id = (Integer)vysledek.get("id");
        return this.editacePolozky(mapping, form, request, response, id.toString(), null, idJazyk);
    }

    private ActionForward smazatPolozku(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String staryKod, String idJazyk) {
        ObsahDelegate cd = new ObsahDelegate(idJazyk, this.getResources(request));
        String cesta = this.servlet.getServletContext().getRealPath("/");
        String user = request.getRemoteUser();
        Map vysledek = cd.smazatPolozku(staryKod, HibernateUtil.getSessionFactory(request.getSession().getServletContext()).getCurrentSession(), cesta, user);
        this.ulozAtributy(request, vysledek);
        if (vysledek.get("chyba") != null) {
            request.setAttribute("akce", (Object)"editace_dokumentu");
            return this.editacePolozky(mapping, form, request, response, staryKod, null, idJazyk);
        }
        request.setAttribute("akce", null);
        return this.vypis(mapping, form, request, response, null, null, "vypis", idJazyk);
    }

    private void ulozAtributy(HttpServletRequest request, Map atributy) {
        for (String klic : atributy.keySet()) {
            request.setAttribute(klic, atributy.get(klic));
        }
    }
}

