/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

enum Jpa21QueryCustomizer {
    INSTANCE;

    private static final Method GET_ENTITY_GRAPH_METHOD;
    private static final boolean JPA21_AVAILABLE;

    public void tryConfigureFetchGraph(EntityManager em, Query query, JpaEntityGraph entityGraph) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)entityGraph, (String)"EntityGraph must not be null!");
        Assert.isTrue((boolean)JPA21_AVAILABLE, (String)"The EntityGraph-Feature requires at least a JPA 2.1 persistence provider!");
        Assert.isTrue((GET_ENTITY_GRAPH_METHOD != null ? 1 : 0) != 0, (String)"It seems that you have the JPA 2.1 API but a JPA 2.0 implementation on the classpath!");
        EntityGraph graph = em.getEntityGraph(entityGraph.getName());
        if (graph == null) {
            return;
        }
        query.setHint(entityGraph.getType().getKey(), (Object)graph);
    }

    static {
        JPA21_AVAILABLE = ClassUtils.isPresent((String)"javax.persistence.NamedEntityGraph", (ClassLoader)Jpa21QueryCustomizer.class.getClassLoader());
        GET_ENTITY_GRAPH_METHOD = JPA21_AVAILABLE ? ReflectionUtils.findMethod(EntityManager.class, (String)"getEntityGraph", (Class[])new Class[]{String.class}) : null;
    }
}

