/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.NativeJpaQuery;
import org.springframework.data.jpa.repository.query.SimpleJpaQuery;
import org.springframework.data.jpa.repository.query.StoredProcedureJpaQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;

enum JpaQueryFactory {
    INSTANCE;

    private static final Logger LOG;

    AbstractJpaQuery fromQueryAnnotation(JpaQueryMethod queryMethod, EntityManager em, EvaluationContextProvider evaluationContextProvider) {
        LOG.debug("Looking up query for method {}", (Object)queryMethod.getName());
        return this.fromMethodWithQueryString(queryMethod, em, queryMethod.getAnnotatedQuery(), evaluationContextProvider);
    }

    AbstractJpaQuery fromMethodWithQueryString(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider) {
        if (queryString == null) {
            return null;
        }
        return method.isNativeQuery() ? new NativeJpaQuery(method, em, queryString, evaluationContextProvider) : new SimpleJpaQuery(method, em, queryString, evaluationContextProvider);
    }

    public StoredProcedureJpaQuery fromProcedureAnnotation(JpaQueryMethod method, EntityManager em) {
        if (!method.isProcedureQuery()) {
            return null;
        }
        return new StoredProcedureJpaQuery(method, em);
    }

    static {
        LOG = LoggerFactory.getLogger(JpaQueryFactory.class);
    }
}

