/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Byt;
import cz.triangle.domy.BytJaz;
import cz.triangle.domy.Dum;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Lokalita;
import cz.triangle.domy.Podlazi;
import cz.triangle.domy.form.AdminDumForm;
import cz.triangle.domy.www.LokalitaDelegate;
import cz.triangle.util.ConvertService;
import cz.triangle.util.HibernateUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class DumDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;

    public DumDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
    }

    public Map novaPolozka(AdminDumForm f, String id, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminDumForm form = f;
            if (form == null) {
                form = new AdminDumForm();
                form.setLokalitaId(id);
            }
            vysledek.put("adminDumForm", (Object)form);
            vysledek.put("seznamLokalit", this.getSeznamLokalit(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminDumForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Dum polozka = (Dum)hsess.load(Dum.class, (Serializable)new Integer(id));
            AdminDumForm form = f;
            if (form == null) {
                form = new AdminDumForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                form.setObrazekNazev(polozka.getObrazek());
                form.setSymbolNazev(polozka.getSymbol());
                ConvertService.odregistrujCeske();
                form.setLokalitaId(polozka.getLokalita().getId().toString());
            }
            vysledek.put("id", polozka.getId());
            vysledek.put("adminDumForm", (Object)form);
            vysledek.put("seznamLokalit", this.getSeznamLokalit(hsess));
            vysledek.put("seznamNebytovychProstor", this.getSeznamNebytovychProstor(id, hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminDumForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminDumForm", (Object)form);
                return vysledek;
            }
            Dum novaPolozka = new Dum();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminDumForm", (Object)form);
            Lokalita lokalita = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(form.getLokalitaId()));
            novaPolozka.setLokalita(lokalita);
            hsess.save((Object)novaPolozka);
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                novaPolozka.setObrazek(LokalitaDelegate.ulozSoubor(cesta, lokalita, privesek, file, "dum_obrazek"));
            }
            if ((file = form.getSymbolFile()) != null && file.getFileName().length() > 0) {
                novaPolozka.setSymbol(LokalitaDelegate.ulozSoubor(cesta, lokalita, privesek, file, "dum_symbol"));
            }
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminDumForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminDumForm", (Object)form);
                return vysledek;
            }
            Dum polozka = (Dum)hsess.load(Dum.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            Lokalita staraLokalita = polozka.getLokalita();
            Lokalita lokalita = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(form.getLokalitaId()));
            long privesek = Math.round(Math.random() * 1000.0);
            if (!lokalita.equals(staraLokalita)) {
                if (polozka.getObrazek() != null && polozka.getObrazek().length() > 0) {
                    LokalitaDelegate.kopirujSwf(cesta, polozka.getObrazek(), polozka.getObrazek(), staraLokalita.getId(), lokalita.getId());
                    LokalitaDelegate.smazatSwf(cesta, polozka.getLokalita().getId(), polozka.getObrazek());
                }
                if (polozka.getSymbol() != null && polozka.getSymbol().length() > 0) {
                    LokalitaDelegate.kopirujSwf(cesta, polozka.getSymbol(), polozka.getSymbol(), staraLokalita.getId(), lokalita.getId());
                    LokalitaDelegate.smazatSwf(cesta, polozka.getLokalita().getId(), polozka.getSymbol());
                }
            }
            polozka.setLokalita(lokalita);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                polozka.setObrazek(LokalitaDelegate.prepisSoubor(cesta, lokalita, privesek, file, polozka.getObrazek(), "dum_obrazek"));
            }
            if ((file = form.getSymbolFile()) != null && file.getFileName().length() > 0) {
                polozka.setSymbol(LokalitaDelegate.prepisSoubor(cesta, lokalita, privesek, file, polozka.getSymbol(), "dum_symbol"));
            }
            vysledek.put("adminDumForm", (Object)form);
            vysledek.put("id", polozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map kopirovatPolozku(String id, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Dum polozka = (Dum)hsess.load(Dum.class, (Serializable)new Integer(id));
            Dum novyDum = new Dum();
            BeanUtils.copyProperties((Object)novyDum, (Object)polozka);
            novyDum.setId(null);
            novyDum.setNazev(String.valueOf(polozka.getNazev()) + " kopie");
            novyDum.setLokalita(polozka.getLokalita());
            novyDum.setSwfid(polozka.getSwfid());
            HashSet<Podlazi> seznamPodlazi = new HashSet<Podlazi>();
            for (Podlazi podlazi : polozka.getPodlazis()) {
                Podlazi novePodlazi = new Podlazi();
                novePodlazi.setId(null);
                BeanUtils.copyProperties((Object)novePodlazi, (Object)podlazi);
                novePodlazi.setDum(novyDum);
                novePodlazi.setTypPodlazi(podlazi.getTypPodlazi());
                novePodlazi.setDum(novyDum);
                hsess.save((Object)novePodlazi);
                HashSet<Byt> seznamBytu = new HashSet<Byt>();
                for (Byt byt : podlazi.getByts()) {
                    Byt novyByt = new Byt();
                    BeanUtils.copyProperties((Object)novyByt, (Object)byt);
                    novyByt.setPodlazi(novePodlazi);
                    novyByt.setTypBloku(byt.getTypBloku());
                    novyByt.setTypProstor(byt.getTypProstor());
                    novyByt.setTypStavu(byt.getTypStavu());
                    HashMap jazykyMap = new HashMap();
                    for (BytJaz bytJaz : byt.getBytJazs().values()) {
                        BytJaz novyBytJaz = new BytJaz();
                        BeanUtils.copyProperties((Object)novyBytJaz, (Object)bytJaz);
                        novyBytJaz.setByt(novyByt);
                        novyBytJaz.setJazyk(bytJaz.getJazyk());
                        novyBytJaz.setId(null);
                    }
                    novyByt.setBytJazs(jazykyMap);
                    hsess.save((Object)novyByt);
                    seznamBytu.add(novyByt);
                }
                novePodlazi.setByts(seznamBytu);
                HashSet seznamNB = new HashSet();
                seznamPodlazi.add(podlazi);
            }
            novyDum.setPodlazis(seznamPodlazi);
            hsess.save((Object)novyDum);
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Dum staraPolozka = (Dum)hsess.load(Dum.class, (Serializable)new Integer(id));
            if (staraPolozka.getPodlazis() != null && staraPolozka.getPodlazis().size() > 0) {
                vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)this.res.getMessage("admin.chyba.smazani_polozky.existuji_podlazi")));
                return vysledek;
            }
            if (staraPolozka.getNebytovaProstoras() != null && staraPolozka.getNebytovaProstoras().size() > 0) {
                vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)this.res.getMessage("admin.chyba.smazani_polozky.existuji_nb")));
                return vysledek;
            }
            if (staraPolozka.getObrazek() != null && staraPolozka.getObrazek().length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, staraPolozka.getLokalita().getId(), staraPolozka.getObrazek());
            }
            if (staraPolozka.getSymbol() != null && staraPolozka.getSymbol().length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, staraPolozka.getLokalita().getId(), staraPolozka.getSymbol());
            }
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public List getSeznamLokalit(Session hsess) {
        return hsess.createQuery("from Lokalita lokalita order by lokalita.razeni").list();
    }

    public List getSeznamNebytovychProstor(String id, Session hsess) {
        Dum dum = (Dum)hsess.load(Dum.class, (Serializable)new Integer(id));
        return hsess.createQuery("from NebytovaProstora nb where nb.dum = ? order by nb.oznaceni").setEntity(0, (Object)dum).list();
    }
}

