/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.sort;

import fr.improve.struts.taglib.layout.skin.Skin;
import fr.improve.struts.taglib.layout.sort.BeanComparator;
import fr.improve.struts.taglib.layout.sort.SortException;
import fr.improve.struts.taglib.layout.sort.SortRules;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.RequestUtils;

public class SortUtil
implements Serializable {
    private static final Log LOG = LogFactory.getLog(SortUtil.class);
    public static final String SORT_UTIL_CLASS = "sortutil.class";
    public static final String SORTUTIL_KEY = "fr.improve.struts.taglib.layout.sort.SortUtil";
    private static final String SORTUTIL_COLLECTION = "layoutCollection";
    public static final String SORTUTIL_COLLECTION_ATTRIBUTE = "fr.improve.struts.taglib.layout.sort.SortUtil.SORTUTIL_COLLECTION_ATTRIBUTE";
    public static final String SORTUTIL_PROPERTY = "layoutCollectionProperty";
    public static final String SORT_UTIL_ACTION = "sortutil.action";
    protected Vector collections = new Vector();
    protected Map sortState = new HashMap();
    protected Map attributes = new HashMap();
    protected Map parameters = new HashMap();
    protected String url;
    protected int index = 0;
    protected SortRules sortRules;
    protected int hashCode;

    public static short getSortState(HttpServletRequest in_request, String in_property) {
        SortUtil lc_util = (SortUtil)in_request.getAttribute(SORTUTIL_KEY);
        if (lc_util == null || lc_util.sortState.isEmpty()) {
            return 0;
        }
        Object[] lc_sort = (Object[])lc_util.sortState.values().iterator().next();
        if (in_property.equals(lc_sort[0])) {
            return ((Integer)lc_sort[1]).shortValue();
        }
        return 0;
    }

    public void initSortUtil(HttpServletRequest in_request, String in_url) {
        String lc_key;
        Enumeration lc_enumeration = in_request.getParameterNames();
        boolean hasUrlParameter = in_url.indexOf(63) != -1;
        this.parameters.clear();
        while (lc_enumeration.hasMoreElements()) {
            lc_key = (String)lc_enumeration.nextElement();
            if (hasUrlParameter && in_url.indexOf(String.valueOf(lc_key) + "=") != -1) continue;
            this.parameters.put(lc_key, in_request.getParameter(lc_key));
        }
        lc_enumeration = in_request.getAttributeNames();
        this.attributes.clear();
        while (lc_enumeration.hasMoreElements()) {
            lc_key = lc_enumeration.nextElement();
            Object lc_value = in_request.getAttribute(lc_key.toString());
            if (lc_value instanceof Tag) {
                LOG.debug((Object)("Skipping JSP tag " + lc_key + " : " + lc_value));
                continue;
            }
            if ("fr.improve.struts.taglib.layout.util.ParentFinder".equals(lc_key)) {
                LOG.debug((Object)"Skipping JSP tags stack");
                continue;
            }
            if (fr.improve.struts.taglib.layout.util.RequestUtils.getLoadedIndicators().contains(lc_key)) {
                LOG.debug((Object)"Skipping runtime javascript code");
                continue;
            }
            if ("fr.improve.struts.taglib.layout.field.AbstractLayoutFieldTag.FIRST_ERROR_FIELD_FOCUS".equals(lc_key)) {
                LOG.debug((Object)"Skipping first field in error focus");
                continue;
            }
            if (lc_key.startsWith("javax.servlet")) {
                LOG.debug((Object)("Skipping servlet information " + lc_key));
                continue;
            }
            if (lc_key.startsWith("atg.servlet")) {
                LOG.debug((Object)("Skipping dynamo information " + lc_key));
                continue;
            }
            if (lc_key.startsWith("_") && lc_value != null && lc_value.getClass().getName().indexOf("atg.") != -1) {
                LOG.debug((Object)("Skipping unsafe atg data " + lc_key));
                continue;
            }
            if (lc_key.equals("org.apache.struts.action.ERROR") && !LayoutUtils.getSkin(in_request.getSession()).getSortKeepErrorMessage()) {
                LOG.debug((Object)("Skipping Struts error messages " + lc_key));
                continue;
            }
            if (lc_key.startsWith("fr.improve.struts.taglib.layout.tab.TabTag.ATG_FIX_KEY")) {
                LOG.debug((Object)"Skipping dynamo tabs cookie bug fix");
                continue;
            }
            LOG.debug((Object)("Adding " + lc_key + " : " + lc_value));
            this.attributes.put(lc_key, lc_value);
        }
        this.url = in_url;
    }

    public static void addCollection(Object in_list, HttpServletRequest in_request) {
        SortUtil lc_sortUtil = (SortUtil)in_request.getSession().getAttribute(SORTUTIL_KEY);
        if (lc_sortUtil == null || in_request.getAttribute("fr.improve.struts.taglib.layout.sort.SortUtilaaa") == null) {
            lc_sortUtil = SortUtil.createSortUtil(in_request);
            in_request.getSession().setAttribute(SORTUTIL_KEY, (Object)lc_sortUtil);
            in_request.setAttribute("fr.improve.struts.taglib.layout.sort.SortUtilaaa", (Object)"aaa");
        }
        lc_sortUtil.collections.add(in_list);
    }

    protected void buildRequest(HttpServletRequest in_request) {
        for (Object lc_key : this.attributes.keySet()) {
            in_request.setAttribute(lc_key.toString(), this.attributes.get(lc_key));
        }
    }

    protected void setCurrentPage(HttpServletRequest in_request) {
        String lc_name = in_request.getParameter("pagerSessionId");
        String lc_value = in_request.getParameter("pagerPage");
        if (lc_name != null && lc_value != null && in_request.getSession().getAttribute(lc_name) != null) {
            in_request.getSession().setAttribute(lc_name, (Object)lc_value);
        }
        String lc_collectionNumber = in_request.getParameter(SORTUTIL_COLLECTION);
        in_request.setAttribute(SORTUTIL_COLLECTION_ATTRIBUTE, (Object)lc_collectionNumber);
        in_request.setAttribute("fr.improve.struts.taglib.layout.pager.PaterTag.PAGE_NUMBER_ATTRIBUTE_KEY", (Object)lc_value);
    }

    protected String buildURL(HttpServletRequest in_request) {
        Iterator lc_iterator = this.parameters.keySet().iterator();
        StringBuffer lc_url = new StringBuffer(this.url);
        boolean hasParameter = this.url.indexOf(63) != -1;
        while (lc_iterator.hasNext()) {
            Object lc_key = lc_iterator.next();
            if ("pagerPage".equals(lc_key)) continue;
            if (hasParameter) {
                lc_url.append("&");
            } else {
                lc_url.append("?");
                hasParameter = true;
            }
            lc_url.append(LayoutUtils.encodeURL(lc_key.toString()));
            lc_url.append("=");
            Object lc_param = this.parameters.get(lc_key);
            if (lc_param == null) continue;
            lc_url.append(LayoutUtils.encodeURL(lc_param.toString()));
        }
        return lc_url.toString();
    }

    protected List getCollectionToSort(HttpServletRequest in_request) throws SortException {
        int lc_index;
        String lc_indexAsString = in_request.getParameter(SORTUTIL_COLLECTION);
        try {
            lc_index = Integer.parseInt(lc_indexAsString);
        }
        catch (NumberFormatException e) {
            throw new SortException("Impossible to find the collection to sort");
        }
        List lc_list = null;
        if (lc_index >= 0) {
            try {
                lc_list = (List)this.collections.get(lc_index);
            }
            catch (ClassCastException e) {
                throw new SortException("Impossible to sort a bean of type " + this.collections.get(lc_index).getClass());
            }
        }
        return lc_list;
    }

    protected String getPropertyToSort(HttpServletRequest in_request) throws SortException {
        return in_request.getParameter(SORTUTIL_PROPERTY);
    }

    public List getSortedCollection() {
        List lc_list = (List)this.collections.get(this.index);
        ++this.index;
        return lc_list;
    }

    public static String getURLForCollection(String in_property, HttpServletRequest in_request) {
        SortUtil lc_sortUtil = (SortUtil)in_request.getSession().getAttribute(SORTUTIL_KEY);
        if (lc_sortUtil == null || in_request.getAttribute("fr.improve.struts.taglib.layout.sort.SortUtilaaa") == null) {
            lc_sortUtil = SortUtil.createSortUtil(in_request);
            in_request.getSession().setAttribute(SORTUTIL_KEY, (Object)lc_sortUtil);
            in_request.setAttribute("fr.improve.struts.taglib.layout.sort.SortUtilaaa", (Object)"aaa");
        }
        String lc_action = null;
        try {
            lc_action = LayoutUtils.getSkin(in_request.getSession()).getProperty(SORT_UTIL_ACTION);
        }
        catch (MissingResourceException e) {
            lc_action = "sort.do";
        }
        StringBuffer lc_buffer = new StringBuffer(in_request.getContextPath());
        lc_buffer.append("/");
        lc_buffer.append(lc_action);
        lc_buffer.append("?");
        lc_buffer.append(SORTUTIL_COLLECTION);
        lc_buffer.append('=');
        lc_buffer.append(lc_sortUtil.collections.size() - 1);
        lc_buffer.append("&amp;");
        lc_buffer.append(SORTUTIL_PROPERTY);
        lc_buffer.append('=');
        lc_buffer.append(in_property);
        lc_buffer.append("&amp;");
        lc_buffer.append("layoutCollectionState");
        lc_buffer.append('=');
        lc_buffer.append(SortUtil.getRequestState(in_request));
        return lc_buffer.toString();
    }

    public String sort(HttpServletRequest in_request) throws SortException {
        this.validateRequest(in_request);
        List lc_collection = this.getCollectionToSort(in_request);
        String lc_property = this.getPropertyToSort(in_request);
        this.sortCollection(lc_collection, lc_property);
        this.buildRequest(in_request);
        this.setCurrentPage(in_request);
        in_request.getSession().removeAttribute(SORTUTIL_KEY);
        in_request.setAttribute(SORTUTIL_KEY, (Object)this);
        return this.buildURL(in_request);
    }

    protected void sortCollection(List in_collection, String in_property) {
        if (in_property != null && in_property.length() != 0) {
            ArrayList copy = new ArrayList(in_collection);
            Collections.sort(in_collection, new BeanComparator(in_property, this.sortRules));
            int order = 1;
            if (copy.equals(in_collection)) {
                Collections.reverse(in_collection);
                order = -1;
            }
            int index = this.collections.indexOf(in_collection);
            this.sortState.put(new Integer(index), new Object[]{in_property, new Integer(order)});
        }
    }

    private static final String getRequestState(HttpServletRequest in_request) {
        Integer lc_value = (Integer)in_request.getSession().getAttribute("fr.improve.struts.taglib.layout.sort.SortUtilbbb");
        if (lc_value == null) {
            lc_value = new Integer(0);
            in_request.getSession().setAttribute("fr.improve.struts.taglib.layout.sort.SortUtilbbb", (Object)lc_value);
        }
        return lc_value.toString();
    }

    protected final void validateRequest(HttpServletRequest in_request) throws SortException {
        Integer lc_integer = (Integer)in_request.getSession().getAttribute("fr.improve.struts.taglib.layout.sort.SortUtilbbb");
        if (lc_integer == null) {
            throw new SortException("session state unknown");
        }
        String lc_value = in_request.getParameter("layoutCollectionState");
        if (lc_value == null) {
            throw new SortException("bad request");
        }
        Skin lc_skin = LayoutUtils.getSkin(in_request.getSession());
        Integer lc_integerValue = new Integer(lc_value);
        if (lc_skin.isSortTokenRequired() && lc_integer.compareTo(lc_integerValue) > 0) {
            throw new SortException("bad session state");
        }
        in_request.getSession().setAttribute("fr.improve.struts.taglib.layout.sort.SortUtilbbb", (Object)new Integer(lc_integer + 1));
    }

    public static SortUtil createSortUtil(HttpServletRequest in_request) {
        SortUtil lc_sortUtil;
        try {
            String lc_sortUtilClass = LayoutUtils.getSkin(in_request.getSession()).getProperty(SORT_UTIL_CLASS);
            try {
                lc_sortUtil = (SortUtil)RequestUtils.applicationInstance((String)lc_sortUtilClass);
            }
            catch (Exception e) {
                e.printStackTrace();
                lc_sortUtil = new SortUtil();
            }
        }
        catch (MissingResourceException mre) {
            lc_sortUtil = new SortUtil();
        }
        lc_sortUtil.sortRules = SortUtil.getRules(in_request);
        lc_sortUtil.initSortUtil(in_request, in_request.getServletPath());
        return lc_sortUtil;
    }

    private static SortRules getRules(HttpServletRequest in_request) {
        Locale locale = LayoutUtils.getLocale(in_request);
        return LayoutUtils.getSkin(in_request.getSession()).getSortRules(locale);
    }

    public void recycleRequest() {
        this.index = 0;
    }
}

