/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.smartclient.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cz.rtnext.smartclient.mvc.SmartClientRequest;
import cz.rtnext.smartclient.service.LogService;
import cz.rtnext.smartclient.util.ScDateConverter;
import cz.rtnext.smartclient.util.ScDateTimeConverter;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.sql.JoinType;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Lazy
public class ScDataService {
    private static final Logger logger = Logger.getLogger(ScDataService.class);
    @Autowired
    protected SessionFactory sessionFactory;
    @Autowired
    private ApplicationContext applicationContext;

    public Map execute(SmartClientRequest parametry, Map<String, String> predaneAtributy, String cesta) throws Exception {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        vysledek.put("typ", parametry.get_operationType());
        vysledek.put("typDat", parametry.get_typDat());
        vysledek.put("status", new Integer(0));
        try {
            if (parametry.get_operationType().equalsIgnoreCase("fetch")) {
                this.fetch(parametry, predaneAtributy, vysledek);
            }
            if (parametry.get_operationType().equalsIgnoreCase("add")) {
                this.add(parametry, predaneAtributy, vysledek);
                this.log(this.getLogText("add", parametry, vysledek));
            }
            if (parametry.get_operationType().equalsIgnoreCase("update")) {
                this.update(parametry, predaneAtributy, vysledek);
                this.log(this.getLogText("update", parametry, vysledek));
            }
            if (parametry.get_operationType().equalsIgnoreCase("remove")) {
                this.remove(parametry, predaneAtributy, vysledek, cesta);
                this.log(this.getLogText("remove", parametry, vysledek));
            }
            if (parametry.get_operationType().equalsIgnoreCase("reorder")) {
                this.reorder(parametry, predaneAtributy, vysledek);
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", e.getMessage() != null ? e.getMessage() : "");
            vysledek.put("typ", "chyba");
        }
        catch (Exception e) {
            e.printStackTrace();
            vysledek.put("chyba", e.getMessage() != null ? e.getMessage() : "");
            vysledek.put("typ", "chyba");
        }
        return vysledek;
    }

    private String getSimpleLogText(String typ, SmartClientRequest parametry) {
        return String.valueOf(typ) + " object " + parametry.get_class().substring(parametry.get_class().lastIndexOf(46) + 1);
    }

    protected String getLogObjectDescription(Object zaznam) {
        return null;
    }

    protected String getLogText(String typ, SmartClientRequest parametry, Map vysledek) {
        block13: {
            if (typ.equalsIgnoreCase("add") || typ.equalsIgnoreCase("update")) {
                try {
                    Class<?> trida = Class.forName(parametry.get_class());
                    Object zaznam = vysledek.get("zaznam");
                    if (zaznam != null) {
                        Object id = trida.getMethod("getId", new Class[0]).invoke(zaznam, null);
                        String logText = String.valueOf(this.getSimpleLogText(typ, parametry)) + " (id = " + id;
                        String logObjectDescription = this.getLogObjectDescription(zaznam);
                        if (logObjectDescription != null) {
                            logText = String.valueOf(logText) + ", " + logObjectDescription;
                        }
                        logText = String.valueOf(logText) + ")";
                        return logText;
                    }
                    break block13;
                }
                catch (ClassNotFoundException e) {
                    return this.getSimpleLogText(typ, parametry);
                }
                catch (IllegalArgumentException e) {
                    return this.getSimpleLogText(typ, parametry);
                }
                catch (SecurityException e) {
                    return this.getSimpleLogText(typ, parametry);
                }
                catch (IllegalAccessException e) {
                    return this.getSimpleLogText(typ, parametry);
                }
                catch (InvocationTargetException e) {
                    return this.getSimpleLogText(typ, parametry);
                }
                catch (NoSuchMethodException e) {
                    return this.getSimpleLogText(typ, parametry);
                }
            }
            if (typ.equalsIgnoreCase("remove")) {
                Object id = "unknown";
                if (vysledek.get("id") != null) {
                    id = (Serializable)vysledek.get("id");
                }
                String logText = String.valueOf(this.getSimpleLogText(typ, parametry)) + " (id = " + id;
                String logObjectDescription = (String)vysledek.get("log");
                if (logObjectDescription != null) {
                    logText = String.valueOf(logText) + ", " + logObjectDescription;
                }
                logText = String.valueOf(logText) + ")";
                return logText;
            }
        }
        return this.getSimpleLogText(typ, parametry);
    }

    protected void log(String logtext) {
        if (this.applicationContext.containsBean("logService")) {
            LogService logService = (LogService)this.applicationContext.getBean("logService");
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String username = null;
            if (auth != null) {
                username = auth.getName();
            }
            logService.log(logtext, username);
        }
    }

    @Transactional
    public void reorder(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws Exception {
        Class<?> trida = Class.forName(parametry.get_class());
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(trida);
        for (String klic : predaneAtributy.keySet()) {
            if (klic.equalsIgnoreCase("id")) continue;
            String hodnota = new String(predaneAtributy.get(klic).getBytes("ISO-8859-1"), "utf-8");
            if (klic.startsWith("id_")) {
                String podklic = this.nazevAtributu(klic.substring(3));
                if (hodnota.equalsIgnoreCase("null") || hodnota.equalsIgnoreCase("-1")) {
                    Criterion itemNameRestriction = Restrictions.isNull((String)(String.valueOf(podklic) + ".id"));
                    criteria.add(itemNameRestriction);
                    continue;
                }
                Serializable idZavisleho = this.vratKonvertovanouHodnotu(trida, klic, hodnota);
                SimpleExpression zavislostNaObjektu = Restrictions.eq((String)(String.valueOf(podklic) + ".id"), (Object)idZavisleho);
                criteria.add((Criterion)zavislostNaObjektu);
                continue;
            }
            Criterion itemNameRestriction = Restrictions.ilike((String)klic, (String)hodnota, (MatchMode)MatchMode.ANYWHERE);
            criteria.add(itemNameRestriction);
        }
        criteria.addOrder(Order.asc((String)"razeni"));
        List matchingItems = criteria.list();
        Object polozka = this.sessionFactory.getCurrentSession().load(trida, (Serializable)new Integer(predaneAtributy.get("id")));
        this.predejPromenne(polozka, parametry, predaneAtributy, vysledek);
        int index = parametry.get_index();
        int vyhozeneRazeni = 0;
        vyhozeneRazeni = index == 0 ? 0 : (index == matchingItems.size() ? (Integer)PropertyUtils.getProperty(matchingItems.get(index - 1), (String)"razeni") + 1 : (Integer)PropertyUtils.getProperty(matchingItems.get(index), (String)"razeni"));
        PropertyUtils.setProperty((Object)polozka, (String)"razeni", (Object)vyhozeneRazeni);
        int noveRazeni = vyhozeneRazeni + 1;
        int i = index;
        while (i < matchingItems.size()) {
            Object tmpO = matchingItems.get(i);
            if (tmpO != polozka) {
                PropertyUtils.setProperty(tmpO, (String)"razeni", (Object)noveRazeni);
                ++noveRazeni;
            }
            ++i;
        }
        vysledek.put("zaznam", polozka);
    }

    @Transactional
    public void remove(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek, String cesta) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
        Class<?> trida = Class.forName(parametry.get_class());
        Serializable id = this.pripravId(trida, (Serializable)((Object)predaneAtributy.get("id")));
        Object polozka = this.sessionFactory.getCurrentSession().load(trida, id);
        vysledek.put("log", this.getLogObjectDescription(polozka));
        this.sessionFactory.getCurrentSession().delete(polozka);
        vysledek.put("id", id);
    }

    @Transactional
    public void fetch(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws Exception {
        if (parametry.get_typDat() != null && parametry.get_typDat().equalsIgnoreCase("sql")) {
            this.sqlFetch(vysledek, parametry, predaneAtributy);
        } else {
            vysledek.put("dodatecneAtributy", parametry.get_dodatecneAtributy());
            this.hibernateFetch(vysledek, parametry, predaneAtributy);
        }
    }

    @Transactional
    public void add(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception, InvocationTargetException, NoSuchMethodException {
        Class<?> trida = Class.forName(parametry.get_class());
        Object novaPolozka = trida.newInstance();
        if (!this.predejPromenne(novaPolozka, parametry, predaneAtributy, vysledek)) {
            return;
        }
        if (PropertyUtils.describe(novaPolozka).containsKey("razeni") && PropertyUtils.getProperty(novaPolozka, (String)"razeni") == null) {
            Integer nej = (Integer)this.sessionFactory.getCurrentSession().createQuery("select max(razeni) from " + novaPolozka.getClass().getSimpleName()).uniqueResult();
            nej = nej == null ? Integer.valueOf(0) : Integer.valueOf(nej + 1);
            PropertyUtils.setProperty(novaPolozka, (String)"razeni", (Object)nej);
        }
        vysledek.put("dodatecneAtributy", parametry.get_dodatecneAtributy());
        this.sessionFactory.getCurrentSession().save(novaPolozka);
        this.sessionFactory.getCurrentSession().flush();
        vysledek.put("zaznam", novaPolozka);
    }

    @Transactional
    public void update(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, Exception {
        Object polozka = this.get(parametry, predaneAtributy);
        if (!this.predejPromenne(polozka, parametry, predaneAtributy, vysledek)) {
            return;
        }
        vysledek.put("dodatecneAtributy", parametry.get_dodatecneAtributy());
        vysledek.put("zaznam", polozka);
    }

    @Transactional
    protected Object get(SmartClientRequest parametry, Map<String, String> predaneAtributy) throws ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
        Class<?> trida = Class.forName(parametry.get_class());
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(trida);
        Serializable id = this.pripravId(trida, (Serializable)((Object)predaneAtributy.get("id")));
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)id));
        if (parametry.get_joinObjekty() != null) {
            StringTokenizer st = new StringTokenizer(parametry.get_joinObjekty(), ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                criteria.createAlias(token, token, JoinType.LEFT_OUTER_JOIN);
            }
        }
        return criteria.uniqueResult();
    }

    @Transactional
    protected Map hibernateFetch(Map vysledek, SmartClientRequest parametry, Map<String, String> predaneAtributy) throws ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IntrospectionException, JsonProcessingException, IOException, InvocationTargetException, ParseException {
        String _sortByString;
        Long _startRow = parametry.get_startRow();
        Long _endRow = parametry.get_endRow();
        if (_startRow == null) {
            _startRow = 0L;
        }
        if (_endRow == null) {
            _endRow = 0L;
        }
        Class<?> trida = Class.forName(parametry.get_class());
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(trida);
        if (parametry.get_constructor() != null && parametry.get_constructor().equalsIgnoreCase("AdvancedCriteria")) {
            this.vytvorAdvancedCriteria(criteria, predaneAtributy.get("operator"), predaneAtributy.get("criteria"), trida);
        } else {
            for (String klic : predaneAtributy.keySet()) {
                String hodnota;
                if (klic.startsWith("_") || !this.specialniFiltr(klic, hodnota = predaneAtributy.get(klic), criteria)) continue;
                if (klic.startsWith("id_")) {
                    String podklic = this.nazevAtributu(klic.substring(3));
                    if (hodnota.equalsIgnoreCase("null") || hodnota.equalsIgnoreCase("-1")) {
                        Criterion itemNameRestriction = Restrictions.isNull((String)(String.valueOf(podklic) + ".id"));
                        criteria.add(itemNameRestriction);
                    } else {
                        Serializable idZavisleho = this.vratKonvertovanouHodnotu(trida, klic, hodnota);
                        SimpleExpression zavislostNaObjektu = Restrictions.eq((String)(String.valueOf(podklic) + ".id"), (Object)idZavisleho);
                        criteria.add((Criterion)zavislostNaObjektu);
                    }
                } else if (klic.equalsIgnoreCase("id")) {
                    Serializable id = this.pripravId(trida, (Serializable)((Object)hodnota));
                    criteria.add((Criterion)Restrictions.eq((String)klic, (Object)id));
                } else {
                    Object itemNameRestriction = null;
                    PropertyDescriptor pd = new PropertyDescriptor(klic, trida);
                    if (Collection.class.isAssignableFrom(pd.getPropertyType())) {
                        String[] hodnotaPole = hodnota.split(",");
                        ArrayList<Integer> hodnotaList = new ArrayList<Integer>(hodnotaPole.length);
                        String[] stringArray = hodnotaPole;
                        int n = hodnotaPole.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String idj = stringArray[n2];
                            hodnotaList.add(new Integer(idj));
                            ++n2;
                        }
                        criteria.createCriteria(klic).add(Restrictions.in((String)"id", hodnotaList));
                    } else {
                        String _textMatchStyle;
                        itemNameRestriction = hodnota.equalsIgnoreCase("false") || hodnota.equalsIgnoreCase("true") ? (hodnota.equalsIgnoreCase("false") ? Restrictions.or((Criterion)Restrictions.isNull((String)klic), (Criterion)Restrictions.eq((String)klic, (Object)new Boolean(hodnota))) : Restrictions.eq((String)klic, (Object)new Boolean(hodnota))) : ((_textMatchStyle = parametry.get_textMatchStyle()) != null && _textMatchStyle.equalsIgnoreCase("exactCase") ? Restrictions.eq((String)klic, (Object)hodnota) : Restrictions.ilike((String)klic, (String)hodnota, (MatchMode)MatchMode.ANYWHERE));
                    }
                    if (itemNameRestriction != null) {
                        criteria.add((Criterion)itemNameRestriction);
                    }
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("klic: " + klic + ", hodnota: " + hodnota));
            }
        }
        if (parametry.get_joinObjekty() != null) {
            StringTokenizer st = new StringTokenizer(parametry.get_joinObjekty(), ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                criteria.createAlias(token, token, JoinType.LEFT_OUTER_JOIN);
            }
        }
        if (parametry.get_distinct() != null && parametry.get_distinct().length() > 0) {
            criteria.setProjection((Projection)Projections.countDistinct((String)parametry.get_distinct()));
            vysledek.put("distinct", parametry.get_distinct());
        } else {
            criteria.setProjection(Projections.rowCount());
        }
        long totalRows = (Long)criteria.uniqueResult();
        _endRow = _endRow > 0L ? Long.valueOf(Math.min(_endRow, totalRows)) : Long.valueOf(totalRows);
        criteria.setProjection(null);
        if (parametry.get_distinct() != null && parametry.get_distinct().length() > 0) {
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)parametry.get_distinct())));
        }
        if ((_sortByString = parametry.get_sortBy()) != null) {
            String[] sortByArray = _sortByString.split(",");
            int i = 0;
            while (i < sortByArray.length) {
                String specialniRazeni;
                String _sortBy = sortByArray[i];
                if (_sortBy.startsWith("-")) {
                    specialniRazeni = this.getSpecialniRazeni(_sortBy = _sortBy.substring(1));
                    if (specialniRazeni != null) {
                        _sortBy = specialniRazeni;
                    }
                    criteria.addOrder(Order.desc((String)_sortBy));
                } else {
                    specialniRazeni = this.getSpecialniRazeni(_sortBy);
                    if (specialniRazeni != null) {
                        _sortBy = specialniRazeni;
                    }
                    criteria.addOrder(Order.asc((String)_sortBy));
                }
                ++i;
            }
        }
        criteria.setFirstResult(_startRow.intValue());
        if (_endRow.intValue() - _startRow.intValue() > 0) {
            criteria.setMaxResults(_endRow.intValue() - _startRow.intValue());
        }
        this.setTransformer(criteria);
        List matchingItems = criteria.list();
        if (parametry.get_atributy() != null) {
            vysledek.put("atributy", parametry.get_atributy());
        }
        vysledek.put("startRow", _startRow);
        vysledek.put("endRow", _endRow);
        vysledek.put("totalRows", totalRows);
        vysledek.put("seznam", matchingItems);
        return vysledek;
    }

    private void vytvorAdvancedCriteria(Criteria criteria, String operatorHlavni, String criteriaJsonString, Class trida) throws JsonProcessingException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParseException, IntrospectionException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter timeFormat = ISODateTimeFormat.dateTime();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree("[" + criteriaJsonString + "]");
        ArrayNode pole = (ArrayNode)root;
        int i = 0;
        while (i < pole.size()) {
            ObjectNode node = (ObjectNode)pole.get(i);
            String fieldName = node.get("fieldName").asText();
            String operator = node.get("operator").asText();
            String values = node.get("value").asText();
            Object value = values;
            PropertyDescriptor pd = new PropertyDescriptor(fieldName, trida);
            if (pd.getPropertyType() == Date.class) {
                value = dateFormat.parse(values);
            } else if (pd.getPropertyType() == Integer.class) {
                value = Integer.parseInt(values);
            } else if (pd.getPropertyType() == java.util.Date.class) {
                DateTime dateTime = timeFormat.parseDateTime(String.valueOf(values) + 'Z');
                value = dateTime.toDate();
            }
            SimpleExpression itemNameRestriction = null;
            if (operator.equalsIgnoreCase("greaterOrEqual")) {
                itemNameRestriction = Restrictions.ge((String)fieldName, (Object)value);
            } else if (operator.equalsIgnoreCase("greaterThan")) {
                itemNameRestriction = Restrictions.gt((String)fieldName, (Object)value);
            } else if (operator.equalsIgnoreCase("lessOrEqual")) {
                itemNameRestriction = Restrictions.le((String)fieldName, (Object)value);
            } else if (operator.equalsIgnoreCase("lessThan")) {
                itemNameRestriction = Restrictions.lt((String)fieldName, (Object)value);
            } else if (operator.equalsIgnoreCase("iContains")) {
                itemNameRestriction = Restrictions.ilike((String)fieldName, (String)values, (MatchMode)MatchMode.ANYWHERE);
            }
            if (itemNameRestriction != null) {
                criteria.add((Criterion)itemNameRestriction);
            }
            ++i;
        }
    }

    @Transactional
    protected Map sqlFetch(Map vysledek, SmartClientRequest parametry, Map<String, String> predaneAtributy) throws ClassNotFoundException, UnsupportedEncodingException {
        long startRow = 0L;
        long endRow = 0L;
        try {
            startRow = parametry.get_startRow();
            endRow = parametry.get_endRow();
        }
        catch (Exception e) {
            startRow = 0L;
            endRow = 0L;
        }
        String tabulka = parametry.get_class();
        String pole = new String(parametry.get_atributy().getBytes("ISO-8859-1"), "utf-8");
        StringBuffer podminka = new StringBuffer("1=1");
        int i = 0;
        for (String klic : predaneAtributy.keySet()) {
            String hodnota = new String(predaneAtributy.get(klic).getBytes("ISO-8859-1"), "utf-8");
            if (klic.startsWith("id_")) {
                if (i == 0) {
                    podminka.delete(0, podminka.length());
                } else {
                    podminka.append(", ");
                }
                podminka.append(String.valueOf(klic) + "=" + hodnota);
            } else {
                if (i == 0) {
                    podminka.delete(0, podminka.length());
                } else {
                    podminka.append(", ");
                }
                podminka.append("upper(" + klic + ") like upper('%" + hodnota + "%')");
            }
            ++i;
        }
        String sqlDotaz = "select count(*) from " + tabulka + " where " + podminka.toString();
        long totalRows = ((BigInteger)this.sessionFactory.getCurrentSession().createSQLQuery(sqlDotaz).uniqueResult()).intValue();
        endRow = endRow > 0L ? Math.min(endRow, totalRows) : totalRows;
        String sortByField = parametry.get_sortBy();
        String order = null;
        if (sortByField != null) {
            order = sortByField.startsWith("-") ? "order by " + sortByField.substring(1) + " desc" : "order by " + sortByField + " asc";
        }
        String limit = "limit " + endRow + " offset " + startRow;
        sqlDotaz = "select " + pole.replace(';', ',') + " from " + tabulka + " where " + podminka.toString() + " " + (order == null ? "" : String.valueOf(order) + " ") + limit;
        List matchingItems = this.sessionFactory.getCurrentSession().createSQLQuery(sqlDotaz).list();
        if (parametry.get_atributy() != null) {
            vysledek.put("atributy", parametry.get_atributy());
        }
        vysledek.put("startRow", startRow);
        vysledek.put("endRow", endRow);
        vysledek.put("totalRows", totalRows);
        vysledek.put("seznam", matchingItems);
        return vysledek;
    }

    @Transactional
    protected boolean predejPromenne(Object novaPolozka, SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws Exception {
        Class<?> trida = Class.forName(parametry.get_class());
        ConvertUtils.register((Converter)new ScDateTimeConverter(), java.util.Date.class);
        ConvertUtils.register((Converter)new ScDateConverter(), Date.class);
        for (String klic : predaneAtributy.keySet()) {
            if (klic.startsWith("_")) continue;
            String hodnota = predaneAtributy.get(klic);
            if (klic.equalsIgnoreCase("t") && hodnota.length() == 0) {
                PropertyUtils.setProperty((Object)novaPolozka, (String)klic, (Object)new java.util.Date());
                continue;
            }
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)novaPolozka, (String)klic);
            if (pd != null && Set.class.isAssignableFrom(PropertyUtils.getPropertyType((Object)novaPolozka, (String)klic))) {
                PropertyUtils.getPropertyType((Object)novaPolozka, (String)klic);
                if (novaPolozka instanceof HibernateProxy) {
                    novaPolozka = ((HibernateProxy)novaPolozka).getHibernateLazyInitializer().getImplementation();
                }
                Field field = trida.getDeclaredField(klic);
                System.out.println(klic);
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class clazz = (Class)pt.getActualTypeArguments()[0];
                HashSet<Object> novySet = new HashSet<Object>();
                StringTokenizer st = new StringTokenizer(hodnota, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    Object dite = this.sessionFactory.getCurrentSession().get(clazz, this.pripravId(clazz, (Serializable)((Object)token)));
                    novySet.add(dite);
                }
                PropertyUtils.setProperty((Object)novaPolozka, (String)klic, novySet);
                continue;
            }
            if (klic.startsWith("id_")) {
                String podklic = this.nazevAtributu(klic.substring(3));
                if (hodnota.equalsIgnoreCase("null") || hodnota.equalsIgnoreCase("-1")) {
                    try {
                        PropertyUtils.setProperty((Object)novaPolozka, (String)podklic, null);
                    }
                    catch (Exception e) {}
                    continue;
                }
                try {
                    Class navazanaTrida = this.getNavazanaTrida(trida, podklic);
                    Serializable idZavisleho = this.vratKonvertovanouHodnotu(trida, klic, hodnota);
                    Object podpolozka = this.sessionFactory.getCurrentSession().get(navazanaTrida, idZavisleho);
                    PropertyUtils.setProperty((Object)novaPolozka, (String)podklic, (Object)podpolozka);
                }
                catch (Exception e) {}
                continue;
            }
            try {
                if (hodnota.equalsIgnoreCase("null")) {
                    PropertyUtils.setProperty((Object)novaPolozka, (String)klic, null);
                    continue;
                }
                BeanUtils.copyProperty((Object)novaPolozka, (String)klic, (Object)hodnota);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ConvertUtils.deregister();
        return this.doupravPredani(novaPolozka, parametry, predaneAtributy, vysledek);
    }

    @Transactional
    protected boolean doupravPredani(Object novaPolozka, SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws Exception {
        return true;
    }

    public void setTransformer(Criteria criteria) {
        criteria.setResultTransformer(Criteria.ROOT_ENTITY);
    }

    public String getSpecialniRazeni(String sortByField) {
        return null;
    }

    public String[] getDodatecneAtributy() {
        return null;
    }

    protected Serializable pripravId(Class trida, Serializable id) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, NoSuchMethodException {
        Class<?> idClass = trida.getMethod("getId", new Class[0]).getReturnType();
        if (idClass == Integer.class || idClass == Integer.TYPE) {
            id = new Integer((String)((Object)id));
        }
        return id;
    }

    protected boolean specialniFiltr(String klic, String hodnota, Criteria criteria) {
        return true;
    }

    private Serializable vratKonvertovanouHodnotu(Class trida, String metoda, String hodnota) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, NoSuchMethodException, ClassNotFoundException {
        Class navazanaTrida = this.getNavazanaTrida(trida, this.nazevAtributu(metoda.substring(3)));
        Class<?> idClass = navazanaTrida.getMethod("getId", new Class[0]).getReturnType();
        Object vysledek = hodnota;
        if (idClass == Integer.class || idClass == Integer.TYPE) {
            vysledek = new Integer(hodnota);
        }
        return vysledek;
    }

    protected Class getNavazanaTrida(Class trida, String podklic) throws ClassNotFoundException {
        String podtrida = String.valueOf(podklic.substring(0, 1).toUpperCase()) + podklic.substring(1);
        int iby = podtrida.indexOf("By");
        if (iby > 0) {
            podtrida = podtrida.substring(0, iby);
        }
        Class<?> navazanaTrida = Class.forName(String.valueOf(trida.getPackage().getName()) + "." + podtrida);
        return navazanaTrida;
    }

    protected String nazevAtributu(String vstup) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < vstup.length()) {
            char znak = vstup.charAt(i);
            if (znak == '_' && vstup.length() > i + 1) {
                sb.append(vstup.substring(++i, i + 1).toUpperCase());
            } else {
                sb.append(vstup.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    @Transactional
    public Map executeQueue(SmartClientRequest smartClientRequest, List<List<Map<String, ?>>> operations, String cesta) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        vysledek.put("typ", smartClientRequest.get_operationType());
        try {
            if (smartClientRequest.get_operationType().equalsIgnoreCase("update")) {
                ArrayList zaznamyList = new ArrayList();
                for (List<Map<String, ?>> operation : operations) {
                    Map<String, String> predaneAtributy = operation.get(0);
                    HashMap vysledekDilci = new HashMap();
                    this.update(smartClientRequest, predaneAtributy, vysledekDilci);
                    this.log(this.getLogText("update", smartClientRequest, vysledekDilci));
                    Object zaznam = vysledekDilci.get("zaznam");
                    zaznamyList.add(zaznam);
                }
                vysledek.put("queuedRecords", zaznamyList);
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", e.getMessage() != null ? e.getMessage() : "");
            vysledek.put("typ", "chyba");
        }
        catch (Exception e) {
            e.printStackTrace();
            vysledek.put("chyba", e.getMessage() != null ? e.getMessage() : "");
            vysledek.put("typ", "chyba");
        }
        return vysledek;
    }

    public Map export(SmartClientRequest parametry, HashMap predaneAtributy, String cesta) throws Exception {
        HashMap vysledek = new HashMap();
        this.fetch(parametry, predaneAtributy, vysledek);
        List seznam = (List)vysledek.get("seznam");
        return vysledek;
    }
}

