/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.action;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class StrankaNalezenych {
    private String dotaz;
    private String dotazPocet;
    private int naStranku;
    private int stranka;
    private List seznam;
    private int pocet;
    private int celkemNalezenych;
    private Session hsess;

    public StrankaNalezenych(Session hsess, String dotaz, String dotazPocet, int naStranku, int stranka) throws HibernateException {
        this.dotaz = dotaz;
        this.stranka = stranka;
        this.hsess = hsess;
        this.dotazPocet = dotazPocet;
        if (stranka < 1) {
            this.stranka = 1;
        }
        this.naStranku = naStranku;
        if (naStranku < 1) {
            this.naStranku = 1;
        }
        this.seznam = new ArrayList();
        this.pocet = 0;
        this.najdi();
    }

    private void najdi() throws HibernateException {
        Query q = this.hsess.createQuery(this.dotaz);
        q.setFirstResult((this.stranka - 1) * this.naStranku);
        q.setMaxResults(this.naStranku);
        this.seznam = q.list();
        List pocetList = this.hsess.createQuery(this.dotazPocet).list();
        this.celkemNalezenych = 0;
        if (pocetList.size() > 0) {
            this.celkemNalezenych = ((Long)pocetList.get(0)).intValue();
        }
        this.pocet = this.seznam.size();
    }

    public int getPocet() {
        return this.pocet;
    }

    public int getStranka() {
        return this.stranka;
    }

    public String toString() {
        return this.seznam.toString();
    }

    public int getCelkemNalezenych() {
        return this.celkemNalezenych;
    }

    public List getSeznam() {
        return this.seznam;
    }

    public int getNaStranku() {
        return this.naStranku;
    }

    public int getPocetStranek() {
        int vysledek = this.celkemNalezenych / this.naStranku;
        if (this.celkemNalezenych % this.naStranku != 0) {
            ++vysledek;
        }
        return vysledek;
    }

    public int getMinNalezenec() {
        int vysledek = this.stranka * this.naStranku - this.naStranku + 1;
        return vysledek;
    }

    public int getMaxNalezenec() {
        int vysledek = this.stranka * this.naStranku;
        if (vysledek > this.celkemNalezenych) {
            vysledek = this.celkemNalezenych;
        }
        return vysledek;
    }
}

