/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.StromMenu;
import cz.triangle.util.HibernateUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.hibernate.classic.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConnectorServlet
extends HttpServlet {
    private static String baseDir;
    private static boolean relative;
    private static boolean debug;

    static {
        relative = false;
        debug = false;
    }

    public void init() throws ServletException {
        String realBaseDir;
        File baseFile;
        String relativeS = this.getInitParameter("relative");
        if (relativeS != null && relativeS.equalsIgnoreCase("true")) {
            relative = true;
        }
        baseDir = this.getInitParameter("baseDir");
        debug = new Boolean(this.getInitParameter("debug"));
        if (baseDir == null) {
            baseDir = "/UserFiles/";
        }
        if (!(baseFile = new File(realBaseDir = this.getServletContext().getRealPath(baseDir))).exists()) {
            baseFile.mkdir();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String typeStr = request.getParameter("Type");
        if (typeStr != null && typeStr.equalsIgnoreCase("File")) {
            this.doGetLink(request, response);
            return;
        }
        if (debug) {
            System.out.println("--- BEGIN DOGET ---");
        }
        response.setContentType("text/xml; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String commandStr = request.getParameter("Command");
        String currentFolderStr = request.getParameter("CurrentFolder");
        String currentPath = String.valueOf(baseDir) + typeStr + currentFolderStr;
        String currentDirPath = this.getServletContext().getRealPath(currentPath);
        File currentDir = new File(currentDirPath);
        if (!currentDir.exists()) {
            currentDir.mkdir();
        }
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        String urlPath = String.valueOf(request.getContextPath()) + currentPath;
        if (relative) {
            urlPath = currentPath;
        }
        Node root = this.CreateCommonXml(document, commandStr, typeStr, currentFolderStr, urlPath);
        if (debug) {
            System.out.println("Command = " + commandStr);
        }
        if (commandStr.equals("GetFolders")) {
            this.getFolders(currentDir, root, document);
        } else if (commandStr.equals("GetFoldersAndFiles")) {
            this.getFolders(currentDir, root, document);
            this.getFiles(currentDir, root, document);
        } else if (commandStr.equals("CreateFolder")) {
            String newFolderStr = request.getParameter("NewFolderName");
            File newFolder = new File(currentDir, newFolderStr);
            String retValue = "110";
            if (newFolder.exists()) {
                retValue = "101";
            } else {
                try {
                    boolean dirCreated = newFolder.mkdir();
                    retValue = dirCreated ? "0" : "102";
                }
                catch (SecurityException sex) {
                    retValue = "103";
                }
            }
            this.setCreateFolderResponse(retValue, root, document);
        }
        document.getDocumentElement().normalize();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            if (debug) {
                StreamResult dbgResult = new StreamResult(System.out);
                transformer.transform(source, dbgResult);
                System.out.println("");
                System.out.println("--- END DOGET ---");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.flush();
        out.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String typeStr = request.getParameter("Type");
        if (typeStr != null && typeStr.equalsIgnoreCase("File")) {
            this.doPostLink(request, response);
            return;
        }
        if (debug) {
            System.out.println("--- BEGIN DOPOST ---");
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String commandStr = request.getParameter("Command");
        String currentFolderStr = request.getParameter("CurrentFolder");
        String currentPath = String.valueOf(baseDir) + typeStr + currentFolderStr;
        String currentDirPath = this.getServletContext().getRealPath(currentPath);
        if (debug) {
            System.out.println(currentDirPath);
        }
        String retVal = "0";
        String newName = "";
        if (!commandStr.equals("FileUpload")) {
            retVal = "203";
        } else {
            DiskFileUpload upload = new DiskFileUpload();
            try {
                List items = upload.parseRequest(request);
                HashMap<String, String> fields = new HashMap<String, String>();
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        fields.put(item.getFieldName(), item.getString());
                        continue;
                    }
                    fields.put(item.getFieldName(), (String)item);
                }
                FileItem uplFile = (FileItem)fields.get("NewFile");
                String fileNameLong = uplFile.getName();
                fileNameLong = fileNameLong.replace('\\', '/');
                String[] pathParts = fileNameLong.split("/");
                String fileName = pathParts[pathParts.length - 1];
                String nameWithoutExt = ConnectorServlet.getNameWithoutExtension(fileName);
                String ext = this.getExtension(fileName);
                File pathToSave = new File(currentDirPath, fileName);
                int counter = 1;
                while (pathToSave.exists()) {
                    newName = String.valueOf(nameWithoutExt) + "(" + counter + ")" + "." + ext;
                    retVal = "201";
                    pathToSave = new File(currentDirPath, newName);
                    ++counter;
                }
                uplFile.write(pathToSave);
            }
            catch (Exception ex) {
                retVal = "203";
            }
        }
        out.println("<script type=\"text/javascript\">");
        out.println("window.parent.frames['frmUpload'].OnUploadCompleted(" + retVal + ",'" + newName + "');");
        out.println("</script>");
        out.flush();
        out.close();
        if (debug) {
            System.out.println("--- END DOPOST ---");
        }
    }

    private void setCreateFolderResponse(String retValue, Node root, Document doc) {
        Element myEl = doc.createElement("Error");
        myEl.setAttribute("number", retValue);
        root.appendChild(myEl);
    }

    private void getFolders(File dir, Node root, Document doc) {
        Element folders = doc.createElement("Folders");
        root.appendChild(folders);
        File[] fileList = dir.listFiles();
        int i = 0;
        while (i < fileList.length) {
            if (fileList[i].isDirectory()) {
                Element myEl = doc.createElement("Folder");
                myEl.setAttribute("name", fileList[i].getName());
                folders.appendChild(myEl);
            }
            ++i;
        }
    }

    private void getFiles(File dir, Node root, Document doc) {
        Element files = doc.createElement("Files");
        root.appendChild(files);
        File[] fileList = dir.listFiles();
        int i = 0;
        while (i < fileList.length) {
            if (fileList[i].isFile()) {
                Element myEl = doc.createElement("File");
                myEl.setAttribute("name", fileList[i].getName());
                myEl.setAttribute("size", "" + fileList[i].length() / 1024L);
                files.appendChild(myEl);
            }
            ++i;
        }
    }

    private Node CreateCommonXml(Document doc, String commandStr, String typeStr, String currentPath, String currentUrl) {
        Element root = doc.createElement("Connector");
        doc.appendChild(root);
        root.setAttribute("command", commandStr);
        root.setAttribute("resourceType", typeStr);
        Element myEl = doc.createElement("CurrentFolder");
        myEl.setAttribute("path", currentPath);
        myEl.setAttribute("url", currentUrl);
        root.appendChild(myEl);
        return root;
    }

    private static String getNameWithoutExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    private String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public void doGetLink(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String currentFolderStr;
        if (debug) {
            System.out.println("--- BEGIN DOGET ---");
        }
        response.setContentType("text/xml; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String commandStr = request.getParameter("Command");
        String typeStr = request.getParameter("Type");
        String currentPath = currentFolderStr = request.getParameter("CurrentFolder");
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        String urlPath = String.valueOf(request.getContextPath()) + currentPath;
        if (relative) {
            urlPath = currentPath;
        }
        Node root = this.CreateCommonXml(document, commandStr, typeStr, currentFolderStr, urlPath);
        if (debug) {
            System.out.println("Command = " + commandStr);
        }
        Session hsess = HibernateUtil.getSessionFactory().getCurrentSession();
        List polozky = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk='cz' order by polozka.razeni").list();
        StromMenu strom = new StromMenu(polozky);
        strom.vytvor(null, true);
        if (commandStr.equals("GetFolders")) {
            this.getFolders(currentPath, strom, root, document);
        } else if (commandStr.equals("GetFoldersAndFiles")) {
            this.getFolders(currentPath, strom, root, document);
            this.getFiles(currentPath, strom, root, document);
        } else if (commandStr.equals("CreateFolder")) {
            String retValue = "103";
            this.setCreateFolderResponseLink(retValue, root, document);
        }
        document.getDocumentElement().normalize();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            if (debug) {
                StreamResult dbgResult = new StreamResult(System.out);
                transformer.transform(source, dbgResult);
                System.out.println("");
                System.out.println("--- END DOGET ---");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        out.flush();
        out.close();
    }

    public void doPostLink(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (debug) {
            System.out.println("--- BEGIN DOPOST ---");
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        String commandStr = request.getParameter("Command");
        String typeStr = request.getParameter("Type");
        String currentFolderStr = request.getParameter("CurrentFolder");
        String currentPath = String.valueOf(baseDir) + typeStr + currentFolderStr;
        String currentDirPath = this.getServletContext().getRealPath(currentPath);
        if (debug) {
            System.out.println(currentDirPath);
        }
        String retVal = "203";
        out.flush();
        out.close();
        if (debug) {
            System.out.println("--- END DOPOST ---");
        }
    }

    private void setCreateFolderResponseLink(String retValue, Node root, Document doc) {
        Element myEl = doc.createElement("Error");
        myEl.setAttribute("number", retValue);
        root.appendChild(myEl);
    }

    private void getFolders(String kodRodic, StromMenu strom, Node root, Document doc) {
        Element folders = doc.createElement("Folders");
        root.appendChild(folders);
        List podmenu = null;
        if (kodRodic.equals("/")) {
            podmenu = (List)strom.getMenu().get(0);
        } else {
            kodRodic = kodRodic.substring(0, kodRodic.length() - 1);
            int posl = kodRodic.lastIndexOf(47);
            kodRodic = kodRodic.substring(posl + 1);
            podmenu = (List)strom.getPodmenu().get(kodRodic);
        }
        if (podmenu != null) {
            for (PolozkaMenu polozka : podmenu) {
                if (strom.getPodmenu().get(polozka.getKod()) == null) continue;
                Element myEl = doc.createElement("Folder");
                myEl.setAttribute("name", polozka.getKod());
                folders.appendChild(myEl);
            }
        }
    }

    private void getFiles(String kodRodic, StromMenu strom, Node root, Document doc) {
        Element files = doc.createElement("Files");
        root.appendChild(files);
        List podmenu = null;
        if (kodRodic.equals("/")) {
            podmenu = (List)strom.getMenu().get(0);
        } else {
            kodRodic = kodRodic.substring(0, kodRodic.length() - 1);
            int posl = kodRodic.lastIndexOf(47);
            kodRodic = kodRodic.substring(posl + 1);
            podmenu = (List)strom.getPodmenu().get(kodRodic);
        }
        if (podmenu != null) {
            for (PolozkaMenu polozka : podmenu) {
                Element myEl = doc.createElement("File");
                myEl.setAttribute("name", String.valueOf(polozka.getKod()) + ".html");
                myEl.setAttribute("size", "");
                myEl.setAttribute("url", String.valueOf(polozka.getKod()) + "/");
                files.appendChild(myEl);
            }
        }
    }
}

