/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.util;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class CeskyFloatConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;
    private NumberFormat nf = NumberFormat.getNumberInstance(new Locale("cs", "CZ"));

    public CeskyFloatConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public CeskyFloatConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof Number) {
            return new Float(((Number)value).floatValue());
        }
        try {
            return new Float(this.nf.parse(value.toString()).floatValue());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException((Throwable)e);
        }
    }
}

