/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.MissingResourceException;

public class CalendarData {
    private ICUResourceBundle fBundle;
    private String fMainType;
    private String fFallbackType;

    public CalendarData(ULocale loc, String type) {
        this((ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt40b", loc), type);
    }

    public CalendarData(ICUResourceBundle b, String type) {
        this.fBundle = b;
        if (type == null || type.equals("") || type.equals("gregorian")) {
            this.fMainType = "gregorian";
            this.fFallbackType = null;
        } else {
            this.fMainType = type;
            this.fFallbackType = "gregorian";
        }
    }

    public ICUResourceBundle get(String key) {
        try {
            return this.fBundle.getWithFallback("calendar/" + this.fMainType + "/" + key);
        }
        catch (MissingResourceException m) {
            if (this.fFallbackType != null) {
                return this.fBundle.getWithFallback("calendar/" + this.fFallbackType + "/" + key);
            }
            throw m;
        }
    }

    public ICUResourceBundle get(String key, String subKey) {
        try {
            return this.fBundle.getWithFallback("calendar/" + this.fMainType + "/" + key + "/format/" + subKey);
        }
        catch (MissingResourceException m) {
            if (this.fFallbackType != null) {
                return this.fBundle.getWithFallback("calendar/" + this.fFallbackType + "/" + key + "/format/" + subKey);
            }
            throw m;
        }
    }

    public ICUResourceBundle get(String key, String contextKey, String subKey) {
        try {
            return this.fBundle.getWithFallback("calendar/" + this.fMainType + "/" + key + "/" + contextKey + "/" + subKey);
        }
        catch (MissingResourceException m) {
            if (this.fFallbackType != null) {
                return this.fBundle.getWithFallback("calendar/" + this.fFallbackType + "/" + key + "/" + contextKey + "/" + subKey);
            }
            throw m;
        }
    }

    public String[] getStringArray(String key) {
        return this.get(key).getStringArray();
    }

    public String[] getStringArray(String key, String subKey) {
        return this.get(key, subKey).getStringArray();
    }

    public String[] getStringArray(String key, String contextKey, String subKey) {
        return this.get(key, contextKey, subKey).getStringArray();
    }

    public String[] getEras(String subkey) {
        ICUResourceBundle bundle = this.get("eras/" + subkey);
        return bundle.getStringArray();
    }

    public ULocale getULocale() {
        return this.fBundle.getULocale();
    }
}

