/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.textpaster;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.color.ColorGenerator;
import com.octo.captcha.component.image.color.SingleColorGenerator;
import com.octo.captcha.component.image.textpaster.ChangeableAttributedString;
import com.octo.captcha.component.image.textpaster.RandomTextPaster;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;

public class LineRandomTextPaster
extends RandomTextPaster {
    private Integer numberOfLinesPerGlyph = new Integer(3);
    private ColorGenerator linesColorGenerator = null;

    public LineRandomTextPaster(Integer minAcceptedWordLength, Integer maxAcceptedWordLength, Color textColor, Integer numberOfLinesPerGlyph, Color linesColor) {
        this(minAcceptedWordLength, maxAcceptedWordLength, (ColorGenerator)(textColor != null ? new SingleColorGenerator(textColor) : null), Boolean.FALSE, numberOfLinesPerGlyph, new SingleColorGenerator(linesColor != null ? linesColor : textColor));
    }

    public LineRandomTextPaster(Integer minAcceptedWordLength, Integer maxAcceptedWordLength, ColorGenerator colorGenerator, Integer numberOfLinesPerGlyph, Color linesColor) {
        this(minAcceptedWordLength, maxAcceptedWordLength, colorGenerator, Boolean.FALSE, numberOfLinesPerGlyph, new SingleColorGenerator(linesColor != null ? linesColor : colorGenerator.getNextColor()));
    }

    public LineRandomTextPaster(Integer minAcceptedWordLength, Integer maxAcceptedWordLength, ColorGenerator colorGenerator, Boolean manageColorPerGlyph, Integer numberOfLinesPerGlyph, Color linesColor) {
        this(minAcceptedWordLength, maxAcceptedWordLength, colorGenerator, manageColorPerGlyph, numberOfLinesPerGlyph, new SingleColorGenerator(linesColor != null ? linesColor : colorGenerator.getNextColor()));
    }

    public LineRandomTextPaster(Integer minAcceptedWordLength, Integer maxAcceptedWordLength, ColorGenerator colorGenerator, Boolean manageColorPerGlyph, Integer numberOfLinesPerGlyph, ColorGenerator linesColorGenerator) {
        super(minAcceptedWordLength, maxAcceptedWordLength, colorGenerator, manageColorPerGlyph);
        this.numberOfLinesPerGlyph = numberOfLinesPerGlyph != null ? numberOfLinesPerGlyph : this.numberOfLinesPerGlyph;
        this.linesColorGenerator = linesColorGenerator != null ? linesColorGenerator : colorGenerator;
    }

    public BufferedImage pasteText(BufferedImage background, AttributedString attributedWord) throws CaptchaException {
        BufferedImage out = this.copyBackground(background);
        Graphics2D g2 = this.pasteBackgroundAndSetTextColor(out, background);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ChangeableAttributedString newAttrString = new ChangeableAttributedString(g2, attributedWord, 20);
        newAttrString.useMinimumSpacing(20.0);
        newAttrString.moveToRandomSpot(background);
        if (this.isManageColorPerGlyph()) {
            newAttrString.drawString(g2, this.getColorGenerator());
        } else {
            newAttrString.drawString(g2);
        }
        g2.setColor(this.linesColorGenerator.getNextColor());
        for (int j = 0; j < attributedWord.getIterator().getEndIndex(); ++j) {
            Rectangle2D bounds = newAttrString.getBounds(j).getFrame();
            for (int i = 0; i < this.numberOfLinesPerGlyph; ++i) {
                double circlex = bounds.getMinX() + bounds.getWidth() * 0.7 * this.myRandom.nextDouble();
                double circley = bounds.getMinY() - bounds.getHeight() * 0.5 * this.myRandom.nextDouble();
                double width = 5 + this.myRandom.nextInt(25);
                double length = 5 + this.myRandom.nextInt(25);
                double angle = Math.PI * this.myRandom.nextDouble();
                AffineTransform transformation = new AffineTransform(Math.cos(angle), -Math.sin(angle), Math.sin(angle), Math.cos(angle), circlex, circley);
                QuadCurve2D.Double q = new QuadCurve2D.Double();
                ((QuadCurve2D)q).setCurve(0.0, 0.0, length / 2.0 + 15.0 * this.myRandom.nextDouble() * (double)(this.myRandom.nextBoolean() ? -1 : 1), width / 2.0 + 15.0 * this.myRandom.nextDouble() * (double)(this.myRandom.nextBoolean() ? -1 : 1), length, width);
                g2.setStroke(new BasicStroke(2 + this.myRandom.nextInt(4)));
                g2.draw(transformation.createTransformedShape(q));
            }
        }
        g2.dispose();
        return out;
    }
}

