/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class ChineseFilter
extends TokenFilter {
    public static final String[] STOP_WORDS;
    private Map stopTable = new HashMap(STOP_WORDS.length);
    static final /* synthetic */ boolean $assertionsDisabled;

    public ChineseFilter(TokenStream in) {
        super(in);
        for (int i = 0; i < STOP_WORDS.length; ++i) {
            this.stopTable.put(STOP_WORDS[i], STOP_WORDS[i]);
        }
    }

    public final Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        Token nextToken = this.input.next(reusableToken);
        while (nextToken != null) {
            String text = nextToken.term();
            if (this.stopTable.get(text) == null) {
                switch (Character.getType(text.charAt(0))) {
                    case 1: 
                    case 2: {
                        if (text.length() <= 1) break;
                        return nextToken;
                    }
                    case 5: {
                        return nextToken;
                    }
                }
            }
            nextToken = this.input.next(reusableToken);
        }
        return null;
    }

    static {
        $assertionsDisabled = !ChineseFilter.class.desiredAssertionStatus();
        STOP_WORDS = new String[]{"and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    }
}

