/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.pager;

import fr.improve.struts.taglib.layout.LayoutTag;
import fr.improve.struts.taglib.layout.LayoutTagSupport;
import fr.improve.struts.taglib.layout.collection.CollectionTag;
import fr.improve.struts.taglib.layout.el.Expression;
import fr.improve.struts.taglib.layout.event.EndLayoutEvent;
import fr.improve.struts.taglib.layout.event.LayoutEventListener;
import fr.improve.struts.taglib.layout.event.StartLayoutEvent;
import fr.improve.struts.taglib.layout.pager.PagerContainer;
import fr.improve.struts.taglib.layout.pager.PagerStatusEvent;
import fr.improve.struts.taglib.layout.pager.PagerStatusListener;
import fr.improve.struts.taglib.layout.skin.BadSkinConfigurationException;
import fr.improve.struts.taglib.layout.skin.Skin;
import fr.improve.struts.taglib.layout.sort.SortUtil;
import fr.improve.struts.taglib.layout.util.IPagerRenderer;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.TagUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;

public class PagerTag
extends LayoutTagSupport
implements LayoutEventListener,
PagerStatusListener {
    public static final String PAGE_NUMBER_KEY = "pagerPage";
    public static final String PAGE_NUMBER_ATTRIBUTE_KEY = "fr.improve.struts.taglib.layout.pager.PaterTag.PAGE_NUMBER_ATTRIBUTE_KEY";
    public static final String PAGER_SESSION_KEY = "pagerSessionId";
    protected static final String PAGER_INDEX = "fr.improve.struts.taglib.layout.pager.PagerTag.PAGER_INDEX";
    protected static final String PAGER_INDEX_CURRENT_PAGE = "fr.improve.struts.taglib.layout.pager.PagerTag.PAGER_INDEX_CURRENT_PAGE";
    protected static final String BOTTOM = "bottom";
    protected static final String TOP = "top";
    protected static final String BOTH = "both";
    protected String url;
    protected String maxPageItems;
    protected String jspMaxPageItems;
    protected int size;
    protected int numberOfPage;
    protected String linksLocation = "bottom";
    private String pagerId = null;
    protected String sessionPagerId = null;
    protected String previousMsgKey = "layout.pager.previous.label";
    protected String nextMsgKey = "layout.pager.next.label";
    protected String previousImgKey = "layout.pager.previous.img";
    protected String nextImgKey = "layout.pager.next.img";
    protected static final String MAX_PAGE_ITEMS_PROPERTY = "layout.pager.maxPageItems";
    protected static final String MAX_LINKS_PROPERTY = "layout.pager.maxLinks";
    public static final String DISPLAY_DIRECT_LINK = "layout.pager.displayDirect";
    protected String gotoProperty = "layout.pager.goto";
    protected String width;
    protected String align;
    protected String styleClass;
    protected String jspStyleClass;
    protected IPagerRenderer renderer;

    protected void initDynamicValues() {
        this.jspStyleClass = this.styleClass;
        if (this.styleClass == null) {
            this.styleClass = LayoutUtils.getSkin(this.pageContext.getSession()).getProperty("styleclass.pager", null);
        }
    }

    protected void reset() {
        this.styleClass = this.jspStyleClass;
        this.jspStyleClass = null;
    }

    public Object processPagerStatusEvent(PagerStatusEvent in_event) throws JspException {
        Integer[] lc_infos = new Integer[]{new Integer(this.getCurrentPage()), new Integer(this.numberOfPage), new Integer(this.size), new Integer(this.maxPageItems)};
        return lc_infos;
    }

    public Object processStartLayoutEvent(StartLayoutEvent in_event) throws JspException {
        LayoutTag lc_source = in_event.getSource();
        if (lc_source instanceof PagerContainer) {
            PagerContainer lc_pagerContainer = (PagerContainer)((Object)lc_source);
            lc_pagerContainer.setOffset(this.getIndexFirstItem());
            lc_pagerContainer.setLength(this.getIndexLastItem() - this.getIndexFirstItem());
            ((CollectionTag)lc_pagerContainer).setSortType(4);
            if (TOP.equalsIgnoreCase(this.getLinksLocation()) || BOTH.equalsIgnoreCase(this.getLinksLocation())) {
                new StartLayoutEvent(this, null).send();
                StringBuffer lc_pagerAnchor = new StringBuffer();
                lc_pagerAnchor.append("<td colspan=\"");
                lc_pagerAnchor.append(String.valueOf(LayoutUtils.getSkin(this.pageContext.getSession()).getFieldInterface().getColumnNumber()));
                if (this.styleClass != null) {
                    lc_pagerAnchor.append("\" class=\"");
                    lc_pagerAnchor.append(this.styleClass);
                }
                lc_pagerAnchor.append("\"><a id=\"");
                lc_pagerAnchor.append(String.valueOf(this.pagerId) + "Anchor");
                lc_pagerAnchor.append("\"/></td>");
                TagUtils.write(this.pageContext, lc_pagerAnchor.toString());
                new EndLayoutEvent(this, null).send();
            }
        }
        return in_event.sendToParent(this);
    }

    public Object processEndLayoutEvent(EndLayoutEvent in_event) throws JspException {
        LayoutTag lc_source = in_event.getSource();
        boolean lc_printPager = false;
        if (lc_source instanceof PagerContainer) {
            PagerContainer lc_pagerContainerTag = (PagerContainer)((Object)lc_source);
            this.setSize(lc_pagerContainerTag.getSize());
            this.url = SortUtil.getURLForCollection("", (HttpServletRequest)this.pageContext.getRequest());
            lc_printPager = true;
        }
        if (lc_printPager) {
            this.computePageNumbers();
            StringBuffer sb = new StringBuffer();
            this.doPrintTag(sb);
            TagUtils.write(this.pageContext, sb.toString());
            if (this.size >= Integer.parseInt(this.maxPageItems) && (TOP.equalsIgnoreCase(this.getLinksLocation()) || BOTH.equalsIgnoreCase(this.getLinksLocation()))) {
                StringBuffer js = new StringBuffer();
                js.append("<script>");
                js.append("document.getElementById('");
                js.append(String.valueOf(this.pagerId) + "Anchor");
                js.append("').parentNode.insertBefore(document.getElementById('");
                js.append(this.pagerId);
                js.append("').cloneNode(true), document.getElementById('");
                js.append(String.valueOf(this.pagerId) + "Anchor");
                js.append("'));");
                js.append("document.getElementById('");
                js.append(this.pagerId);
                js.append("').setAttribute('id','");
                js.append(String.valueOf(this.pagerId) + "Top");
                js.append("');");
                if (TOP.equalsIgnoreCase(this.getLinksLocation())) {
                    js.append("document.getElementById('");
                    js.append(this.pagerId);
                    js.append("').parentNode.removeChild(document.getElementById('");
                    js.append(this.pagerId);
                    js.append("'));");
                }
                js.append("</script>");
                TagUtils.write(this.pageContext, js.toString());
            }
        }
        return in_event.sendToParent(this);
    }

    public int doEndLayoutTag() throws JspException {
        this.url = null;
        this.size = 0;
        this.numberOfPage = 0;
        this.maxPageItems = this.jspMaxPageItems;
        this.jspMaxPageItems = null;
        return 6;
    }

    public int doStartLayoutTag() throws JspException {
        this.computeDefaultMaxPageItems();
        this.pagerId = "pager" + new Date().getTime();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addIndex();
        return 1;
    }

    protected void computeDefaultMaxPageItems() {
        this.jspMaxPageItems = this.maxPageItems;
        this.maxPageItems = Expression.evaluate(this.maxPageItems, this.pageContext);
        if (this.maxPageItems == null) {
            this.maxPageItems = LayoutUtils.getSkin(this.pageContext.getSession()).getProperty(MAX_PAGE_ITEMS_PROPERTY);
        }
    }

    protected void computePageNumbers() {
        int l_maxPageItems = Integer.parseInt(this.maxPageItems);
        this.numberOfPage = (int)Math.ceil((double)this.getSize() / (double)l_maxPageItems);
    }

    protected void addIndex() {
        String l_index = (String)this.pageContext.getAttribute(PAGER_INDEX);
        l_index = l_index == null ? "0" : String.valueOf(Integer.parseInt(l_index) + 1);
        this.pageContext.setAttribute(PAGER_INDEX, (Object)l_index);
    }

    public void release() {
        this.styleClass = null;
        this.maxPageItems = null;
        this.linksLocation = BOTTOM;
        this.pagerId = null;
        this.align = null;
        this.sessionPagerId = null;
        super.release();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl;
    }

    public String getMaxPageItems() {
        return this.maxPageItems;
    }

    public void setMaxPageItems(String in_maxPageItems) throws JspException {
        String l_errorMessageNumber = "PagerTag : invalid attribut : maxPageItems should be a number";
        String l_errorMessageNumberBiggerThanOne = "PagerTat : invalid attribut : maxPageItems should be a number bigger than 0";
        try {
            int l_maxPageItems = Integer.parseInt(in_maxPageItems);
            if (l_maxPageItems < 1) {
                throw new JspException(l_errorMessageNumberBiggerThanOne);
            }
        }
        catch (NumberFormatException enfe) {
            throw new JspException(l_errorMessageNumber);
        }
        this.maxPageItems = in_maxPageItems;
    }

    protected String getPagerIndex() {
        return (String)this.pageContext.getAttribute(PAGER_INDEX);
    }

    protected Integer getCurrentPagePagerIndex(String in_pagerIndex) {
        return (Integer)this.pageContext.getSession().getAttribute(String.valueOf(((HttpServletRequest)this.pageContext.getRequest()).getServletPath()) + PAGER_INDEX_CURRENT_PAGE + in_pagerIndex);
    }

    protected void setCurrentPagePagerIndex(String in_pagerIndex, int in_currentPage) {
        this.pageContext.getSession().setAttribute(String.valueOf(((HttpServletRequest)this.pageContext.getRequest()).getServletPath()) + PAGER_INDEX_CURRENT_PAGE + in_pagerIndex, (Object)new Integer(in_currentPage));
    }

    protected int getCurrentPage() {
        Integer lc_integerPossibleValue;
        String l_pagerIndex = this.getPagerIndex();
        String l_collectionIndex = (String)this.pageContext.getRequest().getAttribute("fr.improve.struts.taglib.layout.sort.SortUtil.SORTUTIL_COLLECTION_ATTRIBUTE");
        if (l_collectionIndex == null) {
            if (this.sessionPagerId != null && this.pageContext.getSession().getAttribute(this.sessionPagerId) != null) {
                return new Integer((String)this.pageContext.getSession().getAttribute(this.sessionPagerId));
            }
            return 0;
        }
        if (!l_pagerIndex.equals(l_collectionIndex)) {
            if (this.sessionPagerId != null && this.pageContext.getSession().getAttribute(this.sessionPagerId) != null) {
                return new Integer((String)this.pageContext.getSession().getAttribute(this.sessionPagerId));
            }
            if (this.getCurrentPagePagerIndex(l_pagerIndex) != null) {
                return this.getCurrentPagePagerIndex(l_pagerIndex);
            }
            return 0;
        }
        int lc_currentPage = -1;
        String lc_possibleValue = (String)this.pageContext.getRequest().getAttribute(PAGE_NUMBER_ATTRIBUTE_KEY);
        if (lc_possibleValue != null) {
            try {
                lc_currentPage = Integer.parseInt(lc_possibleValue);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (lc_currentPage == -1 && (lc_integerPossibleValue = (Integer)this.pageContext.getRequest().getAttribute(PAGE_NUMBER_KEY)) != null) {
            lc_currentPage = lc_integerPossibleValue;
        }
        if (lc_currentPage == -1) {
            lc_currentPage = 0;
        }
        this.setCurrentPagePagerIndex(l_pagerIndex, lc_currentPage);
        if (this.sessionPagerId != null && this.pageContext.getSession().getAttribute(this.sessionPagerId) != null) {
            this.pageContext.getSession().setAttribute(this.sessionPagerId, (Object)String.valueOf(lc_currentPage));
        }
        return lc_currentPage;
    }

    public String getURL(int in_page) {
        String l_url = this.url;
        l_url = l_url.indexOf("?") == -1 ? String.valueOf(l_url) + "?" : String.valueOf(l_url) + "&";
        l_url = String.valueOf(l_url) + PAGE_NUMBER_KEY;
        l_url = String.valueOf(l_url) + "=";
        l_url = String.valueOf(l_url) + in_page;
        if (this.sessionPagerId != null) {
            l_url = String.valueOf(l_url) + "&";
            l_url = String.valueOf(l_url) + PAGER_SESSION_KEY;
            l_url = String.valueOf(l_url) + "=";
            l_url = String.valueOf(l_url) + this.sessionPagerId;
        }
        return l_url;
    }

    public int getIndexFirstItem() {
        int l_currentPage = this.getCurrentPage();
        int l_maxPageItems = Integer.parseInt(this.maxPageItems);
        return l_currentPage * l_maxPageItems;
    }

    public int getIndexLastItem() {
        int l_currentPage = this.getCurrentPage();
        int l_maxPageItems = Integer.parseInt(this.maxPageItems);
        return (l_currentPage + 1) * l_maxPageItems;
    }

    public void setSize(int in_size) {
        this.size = in_size;
    }

    public int getSize() {
        return this.size;
    }

    public void doPrintTag(StringBuffer in_buffer) throws JspException {
        int l_maxPageItems = Integer.parseInt(this.maxPageItems);
        int l_currentPage = this.getCurrentPage();
        if (this.size < l_maxPageItems) {
            return;
        }
        Skin skin = LayoutUtils.getSkin(this.pageContext.getSession());
        this.renderer = skin.getPagerRenderer();
        this.renderer.doStartPager(this, in_buffer);
        this.doPrintPrevious(in_buffer, l_currentPage, skin);
        this.numberOfPage = this.doPrintMain(in_buffer, l_maxPageItems, l_currentPage);
        this.doPrintNext(in_buffer, l_maxPageItems, l_currentPage, skin);
        this.doPrintDirect(in_buffer, l_maxPageItems, l_currentPage, skin);
        this.renderer.doEndPager(this, in_buffer);
    }

    protected void doPrintPrevious(StringBuffer in_buffer, int in_currentPage, Skin in_skin) {
        this.renderer.doPrintPrevious(this, in_buffer, in_currentPage);
    }

    protected int doPrintMain(StringBuffer in_buffer, int in_maxPageItems, int in_currentPage) {
        this.renderer.doPrintMain(this, in_buffer, in_maxPageItems, in_currentPage);
        return this.numberOfPage;
    }

    protected void doPrintNext(StringBuffer in_buffer, int in_maxPageItems, int in_currentPage, Skin in_skin) {
        this.renderer.doPrintNext(this, in_buffer, in_maxPageItems, in_currentPage);
    }

    protected void doPrintDirect(StringBuffer in_buffer, int in_maxPageItems, int in_currentPage, Skin in_skin) throws JspException {
        if (Boolean.valueOf(LayoutUtils.getSkin(this.pageContext.getSession()).getProperty(DISPLAY_DIRECT_LINK)).booleanValue()) {
            this.renderer.doPrintDirect(this, in_buffer, in_maxPageItems, in_currentPage);
        }
    }

    public int computeMaxLinks() {
        int i;
        String s = LayoutUtils.getSkin(this.pageContext.getSession()).getProperty(MAX_LINKS_PROPERTY);
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new BadSkinConfigurationException("The layout.pager.maxLinksProperty is not a number: " + s);
        }
        return i;
    }

    public boolean shouldDisplay(int in_index, int in_displayed, int in_size, int in_maxSize) {
        if (in_maxSize > in_size) {
            return true;
        }
        if (in_index == 0) {
            return true;
        }
        if (in_index == in_size - 1) {
            return true;
        }
        if (in_displayed == in_index) {
            return true;
        }
        if (in_displayed == in_index - 1) {
            return true;
        }
        return in_displayed == in_index + 1;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public final String getLinksLocation() {
        return this.linksLocation;
    }

    public final void setLinksLocation(String linksLocation) {
        this.linksLocation = linksLocation;
    }

    public final String getPagerId() {
        return this.pagerId;
    }

    public void setAlign(String in_align) {
        this.align = in_align;
    }

    public String getAlign() {
        return this.align;
    }

    public String getSessionPagerId() {
        return this.sessionPagerId;
    }

    public void setSessionPagerId(String sessionPagerId) {
        this.sessionPagerId = sessionPagerId;
    }

    public String getNextImgKey() {
        return this.nextImgKey;
    }

    public void setNextImgKey(String nextImgKey) {
        this.nextImgKey = nextImgKey;
    }

    public String getNextMsgKey() {
        return this.nextMsgKey;
    }

    public void setNextMsgKey(String nextMsgKey) {
        this.nextMsgKey = nextMsgKey;
    }

    public String getPreviousImgKey() {
        return this.previousImgKey;
    }

    public void setPreviousImgKey(String previousImgKey) {
        this.previousImgKey = previousImgKey;
    }

    public String getPreviousMsgKey() {
        return this.previousMsgKey;
    }

    public void setPreviousMsgKey(String previousMsgKey) {
        this.previousMsgKey = previousMsgKey;
    }

    public String getGotoProperty() {
        return this.gotoProperty;
    }

    public void setGotoProperty(String gotoProperty) {
        this.gotoProperty = gotoProperty;
    }

    public String getWidth() {
        return this.width;
    }

    public int getNumberOfPage() {
        return this.numberOfPage;
    }
}

