/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.Transform;
import java.util.Hashtable;

public class FSDefineTextField
extends FSDefineObject {
    public static final String WordWrapped = "WordWrapped";
    public static final String Multiline = "Multiline";
    public static final String Password = "Password";
    public static final String ReadOnly = "ReadOnly";
    public static final String Selectable = "Selectable";
    public static final String Bordered = "Bordered";
    public static final String HTML = "HTML";
    public static final String UseFontGlyphs = "UseFontGlyphs";
    public static final String AutoSize = "AutoSize";
    public static final String FontIdentifier = "FontIdentifier";
    public static final String FontHeight = "FontHeight";
    public static final String Color = "Color";
    public static final String MaxLength = "MaxLength";
    public static final String LeftMargin = "LeftMargin";
    public static final String RightMargin = "RightMargin";
    public static final String Indent = "Indent";
    public static final String Leading = "Leading";
    public static final String VariableName = "VariableName";
    public static final String InitialText = "InitialText";
    public static final int AlignLeft = 0;
    public static final int AlignRight = 1;
    public static final int AlignCenter = 2;
    public static final int AlignJustify = 3;
    private FSBounds bounds = null;
    private boolean wordWrapped = false;
    private boolean multiline = false;
    private boolean password = false;
    private boolean readOnly = false;
    private int reserved1 = 0;
    private boolean selectable = false;
    private boolean bordered = false;
    private boolean reserved2 = false;
    private boolean html = false;
    private boolean useFontGlyphs = false;
    private boolean autoSize = false;
    private int fontIdentifier = 0;
    private int fontHeight = 0;
    private FSColor color = null;
    private int maxLength = 0;
    private int alignment = Integer.MIN_VALUE;
    private int leftMargin = Integer.MIN_VALUE;
    private int rightMargin = Integer.MIN_VALUE;
    private int indent = Integer.MIN_VALUE;
    private int leading = Integer.MIN_VALUE;
    private String variableName = "";
    private String initialText = "";

    public FSDefineTextField(FSCoder fSCoder) {
        super(37, 0);
        this.decode(fSCoder);
    }

    public FSDefineTextField(int n, FSBounds fSBounds) {
        super(37, n);
        this.setBounds(fSBounds);
    }

    public FSDefineTextField(int n, FSBounds fSBounds, Hashtable hashtable) {
        super(37, n);
        this.setBounds(fSBounds);
        this.setAttributes(hashtable);
    }

    public FSDefineTextField(FSDefineTextField fSDefineTextField) {
        super(fSDefineTextField);
        this.bounds = new FSBounds(fSDefineTextField.bounds);
        this.wordWrapped = fSDefineTextField.wordWrapped;
        this.multiline = fSDefineTextField.multiline;
        this.password = fSDefineTextField.password;
        this.readOnly = fSDefineTextField.readOnly;
        this.reserved1 = fSDefineTextField.reserved1;
        this.selectable = fSDefineTextField.selectable;
        this.bordered = fSDefineTextField.bordered;
        this.reserved2 = fSDefineTextField.reserved2;
        this.html = fSDefineTextField.html;
        this.useFontGlyphs = fSDefineTextField.useFontGlyphs;
        this.autoSize = fSDefineTextField.autoSize;
        this.fontIdentifier = fSDefineTextField.fontIdentifier;
        this.fontHeight = fSDefineTextField.fontHeight;
        this.color = new FSColor(fSDefineTextField.color);
        this.maxLength = fSDefineTextField.maxLength;
        this.alignment = fSDefineTextField.alignment;
        this.leftMargin = fSDefineTextField.leftMargin;
        this.rightMargin = fSDefineTextField.rightMargin;
        this.indent = fSDefineTextField.indent;
        this.leading = fSDefineTextField.leading;
        this.variableName = new String(fSDefineTextField.variableName);
        this.initialText = new String(fSDefineTextField.initialText);
    }

    public FSBounds getBounds() {
        return this.bounds;
    }

    public boolean isWordWrapped() {
        return this.wordWrapped;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public boolean isHTML() {
        return this.html;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean bl) {
        this.autoSize = bl;
    }

    public boolean useFontGlyphs() {
        return this.useFontGlyphs;
    }

    public int getFontIdentifier() {
        return this.fontIdentifier;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public FSColor getColor() {
        return this.color;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getIndent() {
        return this.indent;
    }

    public int getLeading() {
        return this.leading;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getInitialText() {
        return this.initialText;
    }

    public Hashtable getAttributes() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(WordWrapped, new Boolean(this.isWordWrapped()));
        hashtable.put(Multiline, new Boolean(this.isMultiline()));
        hashtable.put(Password, new Boolean(this.isPassword()));
        hashtable.put(ReadOnly, new Boolean(this.isReadOnly()));
        hashtable.put(AutoSize, new Boolean(this.isAutoSize()));
        hashtable.put(Selectable, new Boolean(this.isSelectable()));
        hashtable.put(Bordered, new Boolean(this.isBordered()));
        hashtable.put(HTML, new Boolean(this.isHTML()));
        hashtable.put(UseFontGlyphs, new Boolean(this.useFontGlyphs()));
        hashtable.put(FontIdentifier, new Integer(this.getFontIdentifier()));
        hashtable.put(FontHeight, new Integer(this.getFontHeight()));
        hashtable.put(Color, this.getColor());
        hashtable.put(MaxLength, new Integer(this.getMaxLength()));
        hashtable.put(LeftMargin, new Integer(this.getLeftMargin()));
        hashtable.put(RightMargin, new Integer(this.getRightMargin()));
        hashtable.put(Indent, new Integer(this.getIndent()));
        hashtable.put(Leading, new Integer(this.getLeading()));
        hashtable.put(VariableName, this.getVariableName());
        hashtable.put(InitialText, this.getInitialText());
        return hashtable;
    }

    public void setBounds(FSBounds fSBounds) {
        this.bounds = fSBounds;
    }

    public void setWordWrapped(boolean bl) {
        this.wordWrapped = bl;
    }

    public void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    public void setPassword(boolean bl) {
        this.password = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setSelectable(boolean bl) {
        this.selectable = !bl;
    }

    public void setBordered(boolean bl) {
        this.bordered = bl;
    }

    public void setHTML(boolean bl) {
        this.html = bl;
    }

    public void setUseFontGlyphs(boolean bl) {
        this.useFontGlyphs = bl;
    }

    public void setFontIdentifier(int n) {
        this.fontIdentifier = n;
    }

    public void setFontHeight(int n) {
        this.fontHeight = n;
    }

    public void setColor(FSColor fSColor) {
        this.color = fSColor;
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    public void setRightMargin(int n) {
        this.rightMargin = n;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void setLeading(int n) {
        this.leading = n;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public void setInitialText(String string) {
        this.initialText = string;
    }

    public void setAttributes(Hashtable hashtable) {
        if (hashtable.get(WordWrapped) != null) {
            this.setWordWrapped((Boolean)hashtable.get(WordWrapped));
        }
        if (hashtable.get(Multiline) != null) {
            this.setMultiline((Boolean)hashtable.get(Multiline));
        }
        if (hashtable.get(Password) != null) {
            this.setPassword((Boolean)hashtable.get(Password));
        }
        if (hashtable.get(ReadOnly) != null) {
            this.setReadOnly((Boolean)hashtable.get(ReadOnly));
        }
        if (hashtable.get(Selectable) != null) {
            this.setSelectable((Boolean)hashtable.get(Selectable));
        }
        if (hashtable.get(Bordered) != null) {
            this.setBordered((Boolean)hashtable.get(Bordered));
        }
        if (hashtable.get(HTML) != null) {
            this.setHTML((Boolean)hashtable.get(HTML));
        }
        if (hashtable.get(AutoSize) != null) {
            this.setAutoSize((Boolean)hashtable.get(AutoSize));
        }
        if (hashtable.get(UseFontGlyphs) != null) {
            this.setUseFontGlyphs((Boolean)hashtable.get(UseFontGlyphs));
        }
        if (hashtable.get(FontIdentifier) != null) {
            this.setFontIdentifier((Integer)hashtable.get(FontIdentifier));
        }
        if (hashtable.get(FontHeight) != null) {
            this.setFontHeight((Integer)hashtable.get(FontHeight));
        }
        if (hashtable.get(Color) != null) {
            this.setColor((FSColor)hashtable.get(Color));
        }
        if (hashtable.get(MaxLength) != null) {
            this.setMaxLength((Integer)hashtable.get(MaxLength));
        }
        if (hashtable.get(LeftMargin) != null) {
            this.setLeftMargin((Integer)hashtable.get(LeftMargin));
        }
        if (hashtable.get(RightMargin) != null) {
            this.setRightMargin((Integer)hashtable.get(RightMargin));
        }
        if (hashtable.get(Indent) != null) {
            this.setIndent((Integer)hashtable.get(Indent));
        }
        if (hashtable.get(Leading) != null) {
            this.setLeading((Integer)hashtable.get(Leading));
        }
        if (hashtable.get(VariableName) != null) {
            this.setVariableName((String)hashtable.get(VariableName));
        }
        if (hashtable.get(InitialText) != null) {
            this.setInitialText((String)hashtable.get(InitialText));
        }
    }

    public Object clone() {
        FSDefineTextField fSDefineTextField = (FSDefineTextField)super.clone();
        fSDefineTextField.bounds = this.bounds != null ? (FSBounds)this.bounds.clone() : null;
        fSDefineTextField.color = this.color != null ? (FSColor)this.color.clone() : null;
        return fSDefineTextField;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineTextField fSDefineTextField = (FSDefineTextField)object;
            bl = this.bounds != null ? this.bounds.equals(fSDefineTextField.bounds) : this.bounds == fSDefineTextField.bounds;
            bl = bl && this.wordWrapped == fSDefineTextField.wordWrapped;
            bl = bl && this.multiline == fSDefineTextField.multiline;
            bl = bl && this.password == fSDefineTextField.password;
            bl = bl && this.readOnly == fSDefineTextField.readOnly;
            bl = bl && this.reserved1 == fSDefineTextField.reserved1;
            bl = bl && this.autoSize == fSDefineTextField.autoSize;
            bl = bl && this.selectable == fSDefineTextField.selectable;
            bl = bl && this.bordered == fSDefineTextField.bordered;
            bl = bl && this.reserved2 == fSDefineTextField.reserved2;
            bl = bl && this.html == fSDefineTextField.html;
            bl = bl && this.useFontGlyphs == fSDefineTextField.useFontGlyphs;
            bl = bl && this.fontIdentifier == fSDefineTextField.fontIdentifier;
            boolean bl2 = bl = bl && this.fontHeight == fSDefineTextField.fontHeight;
            bl = this.color != null ? bl && this.color.equals(fSDefineTextField.color) : bl && this.color == fSDefineTextField.color;
            boolean bl3 = bl = bl && this.maxLength == fSDefineTextField.maxLength;
            if (this.containsLayoutInfo()) {
                bl = bl && this.alignment == fSDefineTextField.alignment;
                bl = bl && this.leftMargin == fSDefineTextField.leftMargin;
                bl = bl && this.rightMargin == fSDefineTextField.rightMargin;
                bl = bl && this.indent == fSDefineTextField.indent;
                boolean bl4 = bl = bl && this.leading == fSDefineTextField.leading;
            }
            if (this.variableName != null) {
                bl = bl && this.variableName.equals(fSDefineTextField.variableName);
            } else {
                boolean bl5 = bl = bl && this.variableName == fSDefineTextField.variableName;
            }
            bl = this.initialText != null ? bl && this.initialText.equals(fSDefineTextField.initialText) : bl && this.initialText == fSDefineTextField.initialText;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "bounds", this.bounds, n);
            Transform.append(stringBuffer, "wordWrapped", this.wordWrapped);
            Transform.append(stringBuffer, "multiline", this.multiline);
            Transform.append(stringBuffer, "password", this.password);
            Transform.append(stringBuffer, "readOnly", this.readOnly);
            Transform.append(stringBuffer, "autoSize", this.autoSize);
            Transform.append(stringBuffer, "selectable", this.selectable);
            Transform.append(stringBuffer, "bordered", this.bordered);
            Transform.append(stringBuffer, HTML, this.html);
            Transform.append(stringBuffer, "useFontGlyphs", this.useFontGlyphs);
            Transform.append(stringBuffer, "fontIdentifier", this.fontIdentifier);
            Transform.append(stringBuffer, "fontHeight", this.fontHeight);
            Transform.append(stringBuffer, "color", this.color, n);
            Transform.append(stringBuffer, "maxLength", this.maxLength);
            Transform.append(stringBuffer, "alignment", this.alignment);
            Transform.append(stringBuffer, "leftMargin", this.leftMargin);
            Transform.append(stringBuffer, "rightMargin", this.rightMargin);
            Transform.append(stringBuffer, "indent", this.indent);
            Transform.append(stringBuffer, "leading", this.leading);
            Transform.append(stringBuffer, "variableName", this.variableName);
            Transform.append(stringBuffer, "initalText", this.initialText);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        boolean bl = this.containsFont();
        boolean bl2 = this.containsColor();
        boolean bl3 = this.containsMaxLength();
        boolean bl4 = this.containsText();
        super.length(fSCoder);
        fSCoder.context[0] = 1;
        this.length += this.bounds.length(fSCoder);
        this.length += 2;
        this.length += bl ? 4 : 0;
        this.length += bl2 ? this.color.length(fSCoder) : 0;
        this.length += bl3 ? 2 : 0;
        this.length += this.containsLayoutInfo() ? 9 : 0;
        this.length += FSCoder.strlen(this.variableName, true);
        this.length += bl4 ? FSCoder.strlen(this.initialText, true) : 0;
        fSCoder.context[0] = 0;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        boolean bl = this.containsFont();
        boolean bl2 = this.containsColor();
        boolean bl3 = this.containsMaxLength();
        boolean bl4 = this.containsText();
        super.encode(fSCoder);
        fSCoder.context[0] = 1;
        this.bounds.encode(fSCoder);
        fSCoder.writeBits(bl4 ? 1 : 0, 1);
        fSCoder.writeBits(this.wordWrapped ? 1 : 0, 1);
        fSCoder.writeBits(this.multiline ? 1 : 0, 1);
        fSCoder.writeBits(this.password ? 1 : 0, 1);
        fSCoder.writeBits(this.readOnly ? 1 : 0, 1);
        fSCoder.writeBits(bl2 ? 1 : 0, 1);
        fSCoder.writeBits(bl3 ? 1 : 0, 1);
        fSCoder.writeBits(bl ? 1 : 0, 1);
        fSCoder.writeBits(0, 1);
        fSCoder.writeBits(this.autoSize ? 1 : 0, 1);
        fSCoder.writeBits(this.containsLayoutInfo() ? 1 : 0, 1);
        fSCoder.writeBits(this.selectable ? 1 : 0, 1);
        fSCoder.writeBits(this.bordered ? 1 : 0, 1);
        fSCoder.writeBits(0, 1);
        fSCoder.writeBits(this.html ? 1 : 0, 1);
        fSCoder.writeBits(this.useFontGlyphs ? 1 : 0, 1);
        if (bl) {
            fSCoder.writeWord(this.fontIdentifier, 2);
            fSCoder.writeWord(this.fontHeight, 2);
        }
        if (bl2) {
            this.color.encode(fSCoder);
        }
        if (bl3) {
            fSCoder.writeWord(this.maxLength, 2);
        }
        if (this.containsLayoutInfo()) {
            fSCoder.writeWord(this.alignment != Integer.MIN_VALUE ? this.alignment : 0, 1);
            fSCoder.writeWord(this.leftMargin != Integer.MIN_VALUE ? this.leftMargin : 0, 2);
            fSCoder.writeWord(this.rightMargin != Integer.MIN_VALUE ? this.rightMargin : 0, 2);
            fSCoder.writeWord(this.indent != Integer.MIN_VALUE ? this.indent : 0, 2);
            fSCoder.writeWord(this.leading != Integer.MIN_VALUE ? this.leading : 0, 2);
        }
        fSCoder.writeString(this.variableName);
        fSCoder.writeWord(0, 1);
        if (bl4) {
            fSCoder.writeString(this.initialText);
            fSCoder.writeWord(0, 1);
        }
        fSCoder.context[0] = 0;
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        super.decode(fSCoder);
        fSCoder.context[0] = 1;
        this.bounds = new FSBounds(fSCoder);
        bl4 = fSCoder.readBits(1, false) != 0;
        this.wordWrapped = fSCoder.readBits(1, false) != 0;
        this.multiline = fSCoder.readBits(1, false) != 0;
        this.password = fSCoder.readBits(1, false) != 0;
        this.readOnly = fSCoder.readBits(1, false) != 0;
        bl2 = fSCoder.readBits(1, false) != 0;
        bl3 = fSCoder.readBits(1, false) != 0;
        bl = fSCoder.readBits(1, false) != 0;
        this.reserved1 = fSCoder.readBits(1, false);
        this.autoSize = fSCoder.readBits(1, false) != 0;
        bl5 = fSCoder.readBits(1, false) != 0;
        this.selectable = fSCoder.readBits(1, false) != 0;
        this.bordered = fSCoder.readBits(1, false) != 0;
        this.reserved2 = fSCoder.readBits(1, false) != 0;
        this.html = fSCoder.readBits(1, false) != 0;
        boolean bl6 = this.useFontGlyphs = fSCoder.readBits(1, false) != 0;
        if (bl) {
            this.fontIdentifier = fSCoder.readWord(2, false);
            this.fontHeight = fSCoder.readWord(2, false);
        }
        if (bl2) {
            this.color = new FSColor(fSCoder);
        }
        if (bl3) {
            this.maxLength = fSCoder.readWord(2, false);
        }
        if (bl5) {
            this.alignment = fSCoder.readWord(1, false);
            this.leftMargin = fSCoder.readWord(2, false);
            this.rightMargin = fSCoder.readWord(2, false);
            this.indent = fSCoder.readWord(2, false);
            this.leading = fSCoder.readWord(2, false);
        }
        this.variableName = fSCoder.readString();
        if (bl4) {
            this.initialText = fSCoder.readString();
        }
        fSCoder.context[0] = 0;
        fSCoder.endObject(this.name());
    }

    private boolean containsColor() {
        return this.color != null;
    }

    private boolean containsFont() {
        return this.fontIdentifier != 0 && this.fontHeight != 0;
    }

    private boolean containsMaxLength() {
        return this.maxLength > 0;
    }

    private boolean containsLayoutInfo() {
        boolean bl = false;
        bl = this.alignment != Integer.MIN_VALUE;
        bl = bl || this.leftMargin != Integer.MIN_VALUE;
        bl = bl || this.rightMargin != Integer.MIN_VALUE;
        bl = bl || this.indent != Integer.MIN_VALUE;
        bl = bl || this.leading != Integer.MIN_VALUE;
        return bl;
    }

    private boolean containsText() {
        return this.initialText != null && this.initialText.length() > 0;
    }
}

