/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;

public class FSLine
extends FSTransformObject {
    private int x = 0;
    private int y = 0;

    public FSLine(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSLine(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public FSLine(FSLine fSLine) {
        this.x = fSLine.x;
        this.y = fSLine.y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setPoint(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSLine fSLine = (FSLine)object;
            bl = this.x == fSLine.x;
            bl = bl && this.y == fSLine.y;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "x", this.x);
            Transform.append(stringBuffer, "y", this.y);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = 7;
        int n2 = FSCoder.size(new int[]{this.x, this.y, 1}, true);
        n = this.containsGeneralLine() ? (n += n2 * 2) : (n += 1 + n2);
        fSCoder.context[10] = fSCoder.context[10] + n;
        return n;
    }

    public void encode(FSCoder fSCoder) {
        boolean bl = this.containsGeneralLine();
        boolean bl2 = this.containsVerticalLine();
        int n = FSCoder.size(new int[]{this.x, this.y, 1}, true);
        fSCoder.writeBits(1, 1);
        fSCoder.writeBits(1, 1);
        fSCoder.writeBits(n - 2, 4);
        fSCoder.writeBits(bl ? 1 : 0, 1);
        if (bl) {
            fSCoder.writeBits(this.x, n);
            fSCoder.writeBits(this.y, n);
        } else {
            fSCoder.writeBits(bl2 ? 1 : 0, 1);
            fSCoder.writeBits(bl2 ? this.y : this.x, n);
        }
    }

    public void decode(FSCoder fSCoder) {
        boolean bl;
        fSCoder.readBits(1, false);
        fSCoder.readBits(1, false);
        int n = fSCoder.readBits(4, false) + 2;
        boolean bl2 = bl = fSCoder.readBits(1, false) != 0;
        if (bl) {
            this.x = fSCoder.readBits(n, true);
            this.y = fSCoder.readBits(n, true);
        } else {
            boolean bl3;
            boolean bl4 = bl3 = fSCoder.readBits(1, false) != 0;
            if (bl3) {
                this.y = fSCoder.readBits(n, true);
            } else {
                this.x = fSCoder.readBits(n, true);
            }
        }
    }

    private boolean containsGeneralLine() {
        return this.x != 0 && this.y != 0;
    }

    private boolean containsVerticalLine() {
        return this.x == 0;
    }
}

