/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSDoAction
extends FSMovieObject {
    private ArrayList actions = null;
    private byte[] encodedActions = null;

    public FSDoAction(FSCoder fSCoder) {
        super(12);
        this.decode(fSCoder);
    }

    public FSDoAction(ArrayList arrayList) {
        super(12);
        this.setActions(arrayList);
    }

    public FSDoAction(byte[] byArray) {
        super(12);
        this.setEncodedActions(byArray);
    }

    public FSDoAction(FSDoAction fSDoAction) {
        super(fSDoAction);
        if (fSDoAction.actions != null) {
            this.actions = new ArrayList(fSDoAction.actions.size());
            Iterator iterator = fSDoAction.actions.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            this.encodedActions = Transform.clone(fSDoAction.encodedActions);
        }
    }

    public void add(FSActionObject fSActionObject) {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        this.actions.add(fSActionObject);
    }

    public ArrayList getActions() {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        return this.actions;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
        this.encodedActions = null;
    }

    public byte[] getEncodedActions() {
        return this.encodedActions;
    }

    public void setEncodedActions(byte[] byArray) {
        this.encodedActions = byArray;
        this.actions = null;
    }

    public Object clone() {
        FSDoAction fSDoAction = (FSDoAction)super.clone();
        if (this.actions != null) {
            fSDoAction.actions = new ArrayList();
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                fSDoAction.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            fSDoAction.encodedActions = Transform.clone(this.encodedActions);
        }
        return fSDoAction;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDoAction fSDoAction = (FSDoAction)object;
            bl = this.actions != null ? this.actions.equals(fSDoAction.actions) : Transform.equals(this.encodedActions, fSDoAction.encodedActions);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            if (this.actions != null) {
                Transform.append(stringBuffer, "actions", this.actions, n);
            } else {
                stringBuffer.append("actions = <data>; ");
            }
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        if (this.actions != null) {
            for (int i = 0; i < this.actions.size(); ++i) {
                FSActionObject fSActionObject = (FSActionObject)this.actions.get(i);
                this.length += fSActionObject.length(fSCoder);
                this.length += fSActionObject.getType() > 128 ? 3 : 1;
            }
        } else {
            this.length += this.encodedActions.length;
        }
        ++this.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        if (this.actions != null) {
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                FSActionObject fSActionObject = (FSActionObject)iterator.next();
                int n = fSCoder.getPointer();
                int n2 = fSCoder.getPointer() + (fSActionObject.getType() > 128 ? 24 : 8);
                int n3 = n2 + (fSActionObject.getLength() << 3);
                fSActionObject.encode(fSCoder);
                int n4 = fSCoder.getPointer() - n3 >> 3;
                if (n4 != 0) {
                    fSCoder.context[14] = 1;
                    fSCoder.context[15] = fSActionObject.getType();
                    fSCoder.context[16] = n >>> 3;
                    fSCoder.context[17] = n3 - n >>> 3;
                    fSCoder.context[13] = n4;
                }
                fSCoder.setPointer(n3);
            }
        } else {
            fSCoder.writeBytes(this.encodedActions);
        }
        fSCoder.writeWord(0, 1);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        if (fSCoder.context[18] == 1) {
            int n;
            this.actions = new ArrayList();
            for (int i = this.length; i > 1; i -= fSCoder.getPointer() - n >>> 3) {
                n = fSCoder.getPointer();
                this.actions.add(FSMovie.decodeAction(fSCoder));
            }
        } else {
            this.encodedActions = new byte[this.length - 1];
            fSCoder.readBytes(this.encodedActions);
        }
        fSCoder.readWord(1, false);
        fSCoder.endObject(this.name());
    }
}

