/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSBitmapFill;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSFillStyle;
import com.flagstone.transform.FSGradientFill;
import com.flagstone.transform.FSLineStyle;
import com.flagstone.transform.FSSolidFill;
import com.flagstone.transform.FSSolidLine;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSShapeStyle
extends FSTransformObject {
    private int moveX = Integer.MIN_VALUE;
    private int moveY = Integer.MIN_VALUE;
    private int fillStyle = Integer.MIN_VALUE;
    private int altFillStyle = Integer.MIN_VALUE;
    private int lineStyle = Integer.MIN_VALUE;
    private ArrayList fillStyles = null;
    private ArrayList lineStyles = null;

    public FSShapeStyle(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSShapeStyle(int n, int n2, int n3) {
        this.setLineStyle(n);
        this.setFillStyle(n2);
        this.setAltFillStyle(n3);
    }

    public FSShapeStyle(int n, int n2) {
        this.setMoveX(n);
        this.setMoveY(n2);
    }

    public FSShapeStyle(ArrayList arrayList, ArrayList arrayList2) {
        this.setLineStyles(arrayList);
        this.setFillStyles(arrayList2);
    }

    public FSShapeStyle(int n, int n2, int n3, int n4, int n5) {
        this.setLineStyle(n);
        this.setFillStyle(n2);
        this.setAltFillStyle(n3);
        this.setMoveX(n4);
        this.setMoveY(n5);
    }

    public FSShapeStyle(int n, int n2, int n3, ArrayList arrayList, ArrayList arrayList2) {
        this.setLineStyle(n);
        this.setFillStyle(n2);
        this.setAltFillStyle(n3);
        this.setLineStyles(arrayList);
        this.setFillStyles(arrayList2);
    }

    public FSShapeStyle(int n, int n2, int n3, int n4, int n5, ArrayList arrayList, ArrayList arrayList2) {
        this.setLineStyle(n);
        this.setFillStyle(n2);
        this.setAltFillStyle(n3);
        this.setMoveX(n4);
        this.setMoveY(n5);
        this.setLineStyles(arrayList);
        this.setFillStyles(arrayList2);
    }

    public FSShapeStyle(FSShapeStyle fSShapeStyle) {
        Iterator iterator;
        this.moveX = fSShapeStyle.moveX;
        this.moveY = fSShapeStyle.moveY;
        this.fillStyle = fSShapeStyle.fillStyle;
        this.altFillStyle = fSShapeStyle.altFillStyle;
        this.lineStyle = fSShapeStyle.lineStyle;
        if (fSShapeStyle.fillStyles != null) {
            this.fillStyles = new ArrayList();
            iterator = fSShapeStyle.fillStyles.iterator();
            while (iterator.hasNext()) {
                this.fillStyles.add(((FSFillStyle)iterator.next()).clone());
            }
        }
        if (fSShapeStyle.lineStyles != null) {
            this.lineStyles = new ArrayList();
            iterator = fSShapeStyle.lineStyles.iterator();
            while (iterator.hasNext()) {
                this.lineStyles.add(((FSLineStyle)iterator.next()).clone());
            }
        }
    }

    public void add(FSLineStyle fSLineStyle) {
        this.lineStyles.add(fSLineStyle);
    }

    public void add(FSFillStyle fSFillStyle) {
        this.fillStyles.add(fSFillStyle);
    }

    public int getMoveX() {
        return this.moveX;
    }

    public int getMoveY() {
        return this.moveY;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public int getAltFillStyle() {
        return this.altFillStyle;
    }

    public ArrayList getLineStyles() {
        return this.lineStyles;
    }

    public ArrayList getFillStyles() {
        return this.fillStyles;
    }

    public void setMoveX(int n) {
        this.moveX = n;
    }

    public void setMoveY(int n) {
        this.moveY = n;
    }

    public void setMove(int n, int n2) {
        this.moveX = n;
        this.moveY = n2;
    }

    public void setFillStyle(int n) {
        this.fillStyle = n;
    }

    public void setAltFillStyle(int n) {
        this.altFillStyle = n;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public void setLineStyles(ArrayList arrayList) {
        this.lineStyles = arrayList;
    }

    public void setFillStyles(ArrayList arrayList) {
        this.fillStyles = arrayList;
    }

    public Object clone() {
        Iterator iterator;
        FSShapeStyle fSShapeStyle = (FSShapeStyle)super.clone();
        if (this.fillStyles != null) {
            fSShapeStyle.fillStyles = new ArrayList();
            iterator = this.fillStyles.iterator();
            while (iterator.hasNext()) {
                fSShapeStyle.fillStyles.add(((FSFillStyle)iterator.next()).clone());
            }
        }
        if (this.lineStyles != null) {
            fSShapeStyle.lineStyles = new ArrayList();
            iterator = this.lineStyles.iterator();
            while (iterator.hasNext()) {
                fSShapeStyle.lineStyles.add(((FSLineStyle)iterator.next()).clone());
            }
        }
        return fSShapeStyle;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSShapeStyle fSShapeStyle = (FSShapeStyle)object;
            bl = this.moveX == fSShapeStyle.moveX;
            bl = bl && this.moveY == fSShapeStyle.moveY;
            bl = bl && this.fillStyle == fSShapeStyle.fillStyle;
            bl = bl && this.altFillStyle == fSShapeStyle.altFillStyle;
            boolean bl2 = bl = bl && this.lineStyle == fSShapeStyle.lineStyle;
            if (this.fillStyles != null) {
                bl = bl && this.fillStyles.equals(fSShapeStyle.fillStyles);
            } else {
                boolean bl3 = bl = bl && this.fillStyles == fSShapeStyle.fillStyles;
            }
            bl = this.lineStyles != null ? bl && this.lineStyles.equals(fSShapeStyle.lineStyles) : bl && this.lineStyles == fSShapeStyle.lineStyles;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "moveX", this.moveX);
            Transform.append(stringBuffer, "moveY", this.moveY);
            Transform.append(stringBuffer, "fillStyle", this.fillStyle);
            Transform.append(stringBuffer, "altFillStyle", this.altFillStyle);
            Transform.append(stringBuffer, "lineStyle", this.lineStyle);
            Transform.append(stringBuffer, "fillStyles", this.fillStyles, n);
            Transform.append(stringBuffer, "lineStyles", this.lineStyles, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n;
        boolean bl = this.containsStyles();
        boolean bl2 = this.containsLineStyle();
        boolean bl3 = this.containsAltFillStyle();
        boolean bl4 = this.containsFillStyle();
        boolean bl5 = this.containsMove();
        int n2 = 0;
        n2 += 6;
        if (bl5) {
            n = FSCoder.size(new int[]{this.moveX, this.moveY}, true);
            n2 += 5 + n * 2;
        }
        n2 += bl4 ? fSCoder.context[6] : 0;
        n2 += bl3 ? fSCoder.context[6] : 0;
        fSCoder.context[10] = fSCoder.context[10] + (n2 += bl2 ? fSCoder.context[7] : 0);
        if (bl) {
            n = FSCoder.size(this.fillStyles.size(), false);
            int n3 = FSCoder.size(this.lineStyles.size(), false);
            boolean bl6 = fSCoder.context[11] != 0;
            int n4 = 0;
            int n5 = fSCoder.context[10];
            n4 += n5 % 8 > 0 ? 8 - n5 % 8 : 0;
            n4 += bl6 && this.fillStyles.size() >= 255 ? 24 : 8;
            Iterator iterator = this.fillStyles.iterator();
            while (iterator.hasNext()) {
                n4 += ((FSTransformObject)iterator.next()).length(fSCoder) * 8;
            }
            n4 += bl6 && this.lineStyles.size() >= 255 ? 24 : 8;
            iterator = this.lineStyles.iterator();
            while (iterator.hasNext()) {
                n4 += ((FSTransformObject)iterator.next()).length(fSCoder) * 8;
            }
            fSCoder.context[6] = n;
            fSCoder.context[7] = n3;
            fSCoder.context[10] = fSCoder.context[10] + (n4 += 8);
            n2 += n4;
        }
        return n2;
    }

    public void encode(FSCoder fSCoder) {
        int n;
        boolean bl = this.containsStyles();
        boolean bl2 = this.containsLineStyle();
        boolean bl3 = this.containsAltFillStyle();
        boolean bl4 = this.containsFillStyle();
        boolean bl5 = this.containsMove();
        int n2 = fSCoder.context[6];
        int n3 = fSCoder.context[7];
        fSCoder.writeBits(0, 1);
        fSCoder.writeBits(bl ? 1 : 0, 1);
        fSCoder.writeBits(bl2 ? 1 : 0, 1);
        fSCoder.writeBits(bl3 ? 1 : 0, 1);
        fSCoder.writeBits(bl4 ? 1 : 0, 1);
        fSCoder.writeBits(bl5 ? 1 : 0, 1);
        if (bl5) {
            n = FSCoder.size(new int[]{this.moveX, this.moveY}, true);
            fSCoder.writeBits(n, 5);
            fSCoder.writeBits(this.moveX, n);
            fSCoder.writeBits(this.moveY, n);
        }
        if (bl4) {
            fSCoder.writeBits(this.fillStyle, n2);
        }
        if (bl3) {
            fSCoder.writeBits(this.altFillStyle, n2);
        }
        if (bl2) {
            fSCoder.writeBits(this.lineStyle, n3);
        }
        if (bl) {
            n = fSCoder.context[11] != 0 ? 1 : 0;
            fSCoder.alignToByte();
            if (n != 0 && this.fillStyles.size() >= 255) {
                fSCoder.writeBits(255, 8);
                fSCoder.writeBits(this.fillStyles.size(), 16);
            } else {
                fSCoder.writeBits(this.fillStyles.size(), 8);
            }
            Iterator iterator = this.fillStyles.iterator();
            while (iterator.hasNext()) {
                ((FSTransformObject)iterator.next()).encode(fSCoder);
            }
            if (n != 0 && this.lineStyles.size() >= 255) {
                fSCoder.writeBits(255, 8);
                fSCoder.writeBits(this.lineStyles.size(), 16);
            } else {
                fSCoder.writeBits(this.lineStyles.size(), 8);
            }
            iterator = this.lineStyles.iterator();
            while (iterator.hasNext()) {
                ((FSTransformObject)iterator.next()).encode(fSCoder);
            }
            n2 = FSCoder.size(this.fillStyles.size(), false);
            n3 = FSCoder.size(this.lineStyles.size(), false);
            fSCoder.writeBits(n2, 4);
            fSCoder.writeBits(n3, 4);
            fSCoder.context[6] = n2;
            fSCoder.context[7] = n3;
        }
    }

    public void decode(FSCoder fSCoder) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = fSCoder.context[6];
        int n3 = fSCoder.context[7];
        fSCoder.readBits(1, false);
        bl = fSCoder.readBits(1, false) != 0;
        bl2 = fSCoder.readBits(1, false) != 0;
        bl3 = fSCoder.readBits(1, false) != 0;
        bl4 = fSCoder.readBits(1, false) != 0;
        boolean bl6 = bl5 = fSCoder.readBits(1, false) != 0;
        if (bl5) {
            n = fSCoder.readBits(5, false);
            this.moveX = fSCoder.readBits(n, true);
            this.moveY = fSCoder.readBits(n, true);
        }
        if (bl4) {
            this.fillStyle = fSCoder.readBits(n2, false);
        }
        if (bl3) {
            this.altFillStyle = fSCoder.readBits(n2, false);
        }
        if (bl2) {
            this.lineStyle = fSCoder.readBits(n3, false);
        }
        if (bl) {
            int n4;
            fSCoder.alignToByte();
            this.fillStyles = new ArrayList();
            this.lineStyles = new ArrayList();
            n = fSCoder.readWord(1, false);
            if (fSCoder.context[11] != 0 && n == 255) {
                n = fSCoder.readWord(2, false);
            }
            this.fillStyles = new ArrayList();
            block9: for (n4 = 0; n4 < n; ++n4) {
                switch (fSCoder.scanWord(1, false)) {
                    case 0: {
                        this.fillStyles.add(new FSSolidFill(fSCoder));
                        continue block9;
                    }
                    case 16: {
                        this.fillStyles.add(new FSGradientFill(fSCoder));
                        continue block9;
                    }
                    case 18: {
                        this.fillStyles.add(new FSGradientFill(fSCoder));
                        continue block9;
                    }
                    case 64: {
                        this.fillStyles.add(new FSBitmapFill(fSCoder));
                        continue block9;
                    }
                    case 65: {
                        this.fillStyles.add(new FSBitmapFill(fSCoder));
                        continue block9;
                    }
                    case 66: {
                        this.fillStyles.add(new FSBitmapFill(fSCoder));
                        continue block9;
                    }
                    case 67: {
                        this.fillStyles.add(new FSBitmapFill(fSCoder));
                        continue block9;
                    }
                }
            }
            n4 = fSCoder.readWord(1, false);
            if (fSCoder.context[11] != 0 && n4 == 255) {
                n4 = fSCoder.readWord(2, false);
            }
            for (int i = 0; i < n4; ++i) {
                this.lineStyles.add(new FSSolidLine(fSCoder));
            }
            n2 = fSCoder.readBits(4, false);
            n3 = fSCoder.readBits(4, false);
            fSCoder.context[6] = n2;
            fSCoder.context[7] = n3;
        }
    }

    private boolean containsStyles() {
        return this.lineStyles != null && this.lineStyles.size() > 0 || this.fillStyles != null && this.fillStyles.size() > 0;
    }

    private boolean containsLineStyle() {
        return this.lineStyle != Integer.MIN_VALUE;
    }

    private boolean containsAltFillStyle() {
        return this.altFillStyle != Integer.MIN_VALUE;
    }

    private boolean containsFillStyle() {
        return this.fillStyle != Integer.MIN_VALUE;
    }

    private boolean containsMove() {
        return this.moveX != Integer.MIN_VALUE && this.moveY != Integer.MIN_VALUE;
    }
}

