/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.action;

import cz.rtnext.eshop.data.Objednavka;
import cz.rtnext.eshop.data.PolozkaObjednavky;
import cz.rtnext.util.HibernateUtil;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.classic.Session;

public class CetelemAction
extends Action {
    private static Log log = LogFactory.getLog(CetelemAction.class);

    private Timestamp nyni() {
        Calendar cal = Calendar.getInstance(new Locale("cs", "CZ"));
        return new Timestamp(cal.getTimeInMillis());
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session hsess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionMessages errors = new ActionMessages();
        try {
            MessageResources mr = this.getResources(request);
            if (request.getAttribute("objednavka") == null) {
                throw new Exception("Neexistuje objednavka v requestu");
            }
            Objednavka obj = (Objednavka)request.getAttribute("objednavka");
            Integer cisloObj = obj.getId();
            String order_code = this.omez(cisloObj.toString(), 10);
            float celkovaCena = 0.0f;
            for (PolozkaObjednavky polozka : obj.getPolozkaObjednavkies()) {
                celkovaCena = (float)((double)celkovaCena + polozka.getCenaKusPoSleve() * (double)polozka.getKs().intValue());
            }
            celkovaCena = (float)((double)celkovaCena + obj.getDopravne());
            NumberFormat nf = NumberFormat.getNumberInstance(new Locale("cs"));
            nf.setGroupingUsed(false);
            String ourIshopHome = String.valueOf(request.getRequestURL().substring(0, request.getRequestURL().lastIndexOf("/") + 1)) + "obj_ulozena.do";
            request.setAttribute("cenaZbozi", (Object)nf.format(celkovaCena));
            request.setAttribute("url_back_ok", (Object)ourIshopHome);
            request.setAttribute("obj", (Object)order_code);
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.homecredit"));
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        return mapping.findForward("objednavkaUlozena");
    }

    public String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            int j = bytes[i];
            if (j < 0) {
                j += 256;
            }
            if (j < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(j));
            ++i;
        }
        return buf.toString();
    }

    private String omez(String vstup, int delka) {
        String vysledek = vstup;
        if (vysledek == null) {
            return "";
        }
        if (vysledek.length() > delka) {
            vysledek = vysledek.substring(0, delka);
        }
        return vysledek;
    }
}

