/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.action;

import cz.rtnext.eshop.data.Objednavka;
import cz.rtnext.eshop.data.PolozkaObjednavky;
import cz.rtnext.util.HibernateUtil;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.classic.Session;

public class HomecreditAction
extends Action {
    private static Log log = LogFactory.getLog(HomecreditAction.class);

    private Timestamp nyni() {
        Calendar cal = Calendar.getInstance(new Locale("cs", "CZ"));
        return new Timestamp(cal.getTimeInMillis());
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session hsess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionMessages errors = new ActionMessages();
        try {
            MessageResources mr = this.getResources(request);
            if (request.getAttribute("objednavka") == null) {
                throw new Exception("Neexistuje objednavka v requestu");
            }
            Objednavka obj = (Objednavka)request.getAttribute("objednavka");
            String shop = mr.getMessage("homecredit.shop");
            Integer cisloObj = obj.getId();
            String order_code = this.omez(cisloObj.toString(), 10);
            float celkovaCena = 0.0f;
            float nejvyssiCena = -1.0f;
            PolozkaObjednavky nejdrazsiPolozka = null;
            String nazevVyrobku = "";
            String znackaVyrobku = "";
            for (PolozkaObjednavky polozka : obj.getPolozkaObjednavkies()) {
                if (polozka.getCenaKusPoSleve() > (double)nejvyssiCena) {
                    nejdrazsiPolozka = polozka;
                }
                celkovaCena = (float)((double)celkovaCena + polozka.getCenaKusPoSleve() * (double)polozka.getKs().intValue());
            }
            celkovaCena = (float)((double)celkovaCena + obj.getDopravne());
            if (nejdrazsiPolozka != null) {
                nazevVyrobku = nejdrazsiPolozka.getNazev();
                znackaVyrobku = nejdrazsiPolozka.getZnacka();
            }
            NumberFormat nf = NumberFormat.getNumberInstance(new Locale("cs"));
            nf.setGroupingUsed(false);
            String order_price = nf.format(celkovaCena);
            String client_name = this.omez(obj.getJmeno(), 30);
            String client_surname = this.omez(obj.getPrijmeni(), 30);
            String goods_name = this.omez(nazevVyrobku, 60);
            String goods_producer = this.omez(znackaVyrobku, 60);
            String time_request = new SimpleDateFormat("dd.MM.yyyy-HH:mm:ss").format(new Date());
            String secret_code = mr.getMessage("homecredit.secret");
            String plainText = String.valueOf(shop) + order_code + order_price + client_name + client_surname + goods_name + goods_producer + time_request + secret_code;
            byte[] wholeBytes = plainText.getBytes("UTF-8");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(wholeBytes);
            byte[] md5Bytes = md5.digest();
            String hash = this.toHexString(md5Bytes);
            String ishopEntryPoint = mr.getMessage("homecredit.entry.ishop");
            String ourIshopHome = String.valueOf(request.getRequestURL().substring(0, request.getRequestURL().lastIndexOf("/") + 1)) + "obj_ulozena.do";
            String client_phone = this.omez(obj.getTelefon(), 30);
            String client_email = this.omez(obj.getEmail(), 30);
            String client_p_street = this.omez(obj.getUlice(), 30);
            String client_p_num = this.omez(obj.getCislo(), 10);
            String client_p_city = this.omez(obj.getMesto(), 30);
            String client_p_zip = this.omez(obj.getPsc(), 5);
            String client_c_street = client_p_street;
            String client_c_num = client_p_num;
            String client_c_city = client_p_city;
            String client_c_zip = client_p_zip;
            String url = String.valueOf(ishopEntryPoint) + "?shop=" + shop + "&o_code=" + order_code + "&o_price=" + order_price + "&c_name=" + URLEncoder.encode(client_name, "UTF-8") + "&c_surname=" + URLEncoder.encode(client_surname, "UTF-8") + "&g_name=" + URLEncoder.encode(goods_name, "UTF-8") + "&g_producer=" + URLEncoder.encode(goods_producer, "UTF-8") + "&ret_url=" + URLEncoder.encode(ourIshopHome, "UTF-8") + "&time_request=" + time_request + "&sh=" + hash + "&c_p_street=" + URLEncoder.encode(client_p_street, "UTF-8") + "&c_p_num=" + client_p_num + "&c_p_city=" + URLEncoder.encode(client_p_city, "UTF-8") + "&c_p_zip=" + client_p_zip + "&c_c_street=" + URLEncoder.encode(client_c_street, "UTF-8") + "&c_c_num=" + client_c_num + "&c_c_city=" + URLEncoder.encode(client_c_city, "UTF-8") + "&c_c_zip=" + client_c_zip + "&c_phone=" + URLEncoder.encode(client_phone, "UTF-8") + "&c_email=" + URLEncoder.encode(client_email, "UTF-8");
            try {
                response.sendRedirect(url);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.homecredit"));
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        return mapping.findForward("objednavkaUlozena");
    }

    public String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            int j = bytes[i];
            if (j < 0) {
                j += 256;
            }
            if (j < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(j));
            ++i;
        }
        return buf.toString();
    }

    private String omez(String vstup, int delka) {
        String vysledek = vstup;
        if (vysledek == null) {
            return "";
        }
        if (vysledek.length() > delka) {
            vysledek = vysledek.substring(0, delka);
        }
        return vysledek;
    }
}

