/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.administrace.action;

import cz.rtnext.util.HibernateUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.EntityMode;
import org.hibernate.metadata.ClassMetadata;

public class ClientResponse {
    private String typ = null;
    private long startRow;
    private long endRow;
    private long totalRows;
    private List seznam;
    private int status = 0;
    private Object zaznam;
    private Integer id;
    private String pole;
    private boolean hibernate;
    private String[] dodatecneAtributy = null;
    private String atributy;
    private Map atributyMap = new HashMap();

    public ClientResponse(String typ, boolean hibernate) {
        this.typ = typ;
        this.hibernate = hibernate;
    }

    public void vypis(Writer writer) throws IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        writer.write("<response>");
        if (this.typ.equalsIgnoreCase("fetch")) {
            writer.write("<status>" + this.status + "</status>");
            writer.write("<startRow>" + this.startRow + "</startRow>");
            writer.write("<endRow>" + this.endRow + "</endRow>");
            writer.write("<totalRows>" + this.totalRows + "</totalRows>");
            writer.write("<data>");
            if (this.pole == null) {
                Iterator iterator = this.seznam.iterator();
                while (iterator.hasNext()) {
                    writer.write("<record>");
                    Object type = iterator.next();
                    this.vypisAtributy(type, writer);
                    writer.write("</record>");
                }
            } else {
                Iterator iterator = this.seznam.iterator();
                while (iterator.hasNext()) {
                    writer.write("<record>");
                    Object[] type = (Object[])iterator.next();
                    this.vypisSQLRadek(type, writer);
                    writer.write("</record>");
                }
            }
            writer.write("</data>");
        }
        if (this.typ.equalsIgnoreCase("add") || this.typ.equalsIgnoreCase("update") || this.typ.equalsIgnoreCase("reorder")) {
            writer.write("<status>" + this.status + "</status>");
            writer.write("<data>");
            writer.write("<record>");
            this.vypisAtributy(this.zaznam, writer);
            writer.write("</record>");
            writer.write("</data>");
        }
        if (this.typ.equalsIgnoreCase("remove")) {
            writer.write("<status>" + this.status + "</status>");
            writer.write("<data>");
            writer.write("<record>");
            writer.write("<id>" + this.id + "</id>");
            writer.write("</record>");
            writer.write("</data>");
        }
        writer.write("</response>");
    }

    private void vypisSQLRadek(Object[] type, Writer writer) throws IOException {
        StringTokenizer st = new StringTokenizer(this.pole, ",");
        String token = null;
        int i = 0;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            writer.write("<" + token + ">" + type[i] + "</" + token + ">");
            ++i;
        }
    }

    public void setStartRow(long startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(long endRow) {
        this.endRow = endRow;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public void setSeznam(List seznam) {
        this.seznam = seznam;
    }

    private void vypisObjekt(Object bean, Writer writer) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object result;
        String klic;
        ClassMetadata metadata = HibernateUtil.getSessionFactory().getClassMetadata(HibernateUtil.getSessionFactory().getCurrentSession().getEntityName(bean));
        String[] nazvyAtributu = metadata.getPropertyNames();
        writer.write("<id>" + metadata.getIdentifier(bean, EntityMode.POJO) + "</id>");
        int i = 0;
        while (i < nazvyAtributu.length) {
            klic = nazvyAtributu[i];
            if (this.atributyMap == null || this.atributyMap.size() <= 0 || this.atributyMap.containsKey(klic)) {
                result = metadata.getPropertyValue(bean, klic, EntityMode.POJO);
                if (result == null) {
                    if (metadata.getPropertyType(klic).toString().indexOf("cz.rtnext") > -1) {
                        writer.write("<id_" + klic + ">-1</id_" + klic + ">");
                    } else if (metadata.getPropertyType(klic).getReturnedClass() == Boolean.class) {
                        writer.write("<" + klic + ">false</" + klic + ">");
                    } else {
                        writer.write("<" + klic + "></" + klic + ">");
                    }
                } else if (ClientResponse.isStandardProperty(result.getClass())) {
                    if (result.getClass() == String.class) {
                        writer.write("<" + klic + "><![CDATA[" + result + "]]></" + klic + ">");
                    } else {
                        writer.write("<" + klic + ">" + ConvertUtils.convert((Object)result) + "</" + klic + ">");
                    }
                } else if (result.getClass().getPackage().getName().startsWith("cz.rtnext")) {
                    writer.write("<id_" + klic + ">" + result.getClass().getMethod("getId", null).invoke(result, null) + "</id_" + klic + ">");
                }
            }
            ++i;
        }
        if (this.dodatecneAtributy != null) {
            i = 0;
            while (i < this.dodatecneAtributy.length) {
                klic = this.dodatecneAtributy[i];
                result = PropertyUtils.getProperty((Object)bean, (String)klic);
                if (ClientResponse.isStandardProperty(result.getClass())) {
                    if (result.getClass() == String.class) {
                        writer.write("<" + klic + "><![CDATA[" + result + "]]></" + klic + ">");
                    } else {
                        writer.write("<" + klic + ">" + result + "</" + klic + ">");
                    }
                }
                ++i;
            }
        }
    }

    private void vypisAtributy(Object bean, Writer writer) throws IllegalArgumentException, SecurityException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (this.hibernate) {
            this.vypisObjekt(bean, writer);
        } else {
            this.populateInternalMap(bean, true, writer);
        }
    }

    private void populateInternalMap(Object bean, boolean includeSuperClass, Writer writer) {
        Class<?> klass = bean.getClass();
        if (klass.getClassLoader() == null) {
            includeSuperClass = false;
        }
        Method[] methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            try {
                Method method = methods[i];
                if (Modifier.isPublic(method.getModifiers())) {
                    String name = method.getName();
                    String key = "";
                    if (name.startsWith("get")) {
                        key = name.substring(3);
                    } else if (name.startsWith("is")) {
                        key = name.substring(2);
                    }
                    if (key.length() > 0 && Character.isUpperCase(key.charAt(0)) && method.getParameterTypes().length == 0) {
                        if (key.length() == 1) {
                            key = key.toLowerCase();
                        } else if (!Character.isUpperCase(key.charAt(1))) {
                            key = String.valueOf(key.substring(0, 1).toLowerCase()) + key.substring(1);
                        }
                        Object result = method.invoke(bean, null);
                        if (result == null) {
                            if (method.getGenericReturnType().toString().indexOf("cz.rtnext") > -1) {
                                writer.write("<id_" + key + ">-1</id_" + key + ">");
                            } else {
                                writer.write("<" + key + "></" + key + ">");
                            }
                        } else if (!(result.getClass().isArray() || result instanceof Collection || result instanceof Map)) {
                            if (ClientResponse.isStandardProperty(result.getClass())) {
                                writer.write("<" + key + ">" + ConvertUtils.convert((Object)result) + "</" + key + ">");
                            } else if (result.getClass().getPackage().getName().startsWith("cz.rtnext")) {
                                writer.write("<id_" + key + ">" + result.getClass().getMethod("getId", null).invoke(result, null) + "</id_" + key + ">");
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
    }

    static boolean isStandardProperty(Class clazz) {
        return clazz.isPrimitive() || clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(String.class) || clazz.isAssignableFrom(Boolean.class);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setZaznam(Object zaznam) {
        this.zaznam = zaznam;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPole() {
        return this.pole;
    }

    public void setPole(String pole) {
        this.pole = pole;
    }

    public String[] getDodatecneAtributy() {
        return this.dodatecneAtributy;
    }

    public void setDodatecneAtributy(String[] dodatecneAtributy) {
        this.dodatecneAtributy = dodatecneAtributy;
    }

    public void setAtributy(String atributy) {
        this.atributy = atributy;
        this.atributyMap.clear();
        if (atributy != null && atributy.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(atributy, ",");
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken();
                this.atributyMap.put(tmp, tmp);
            }
        }
    }
}

