/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.www;

import cz.rtnext.eshop.data.Clanek;
import cz.rtnext.eshop.data.Informace2;
import cz.rtnext.eshop.data.Kategorie;
import cz.rtnext.eshop.data.Parametr;
import cz.rtnext.eshop.data.Vyrobek;
import cz.rtnext.util.NastaveniAplikace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class IndexovaniService {
    SimpleDateFormat sitemapDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public void indexuj(Session hsess, String index_dir, String rootDir, String url) throws HibernateException, IOException, ParseException {
        String obchod = (String)NastaveniAplikace.getHodnota("obchod");
        String podminkaObchod = "1=1";
        if (obchod != null && obchod.trim().length() > 0) {
            podminkaObchod = "vyrobek.kategorieByIdKategorie2.obchod.id = '" + obchod + "'";
        }
        List kategorie = hsess.createQuery("from Kategorie where kategorie.obchod.id='" + obchod + "'").list();
        List vlastnosti = hsess.createQuery("select distinct vyrobek from Vyrobek vyrobek left join fetch vyrobek.vyrobekObrazekPrvnis left join fetch vyrobek.parametry left join fetch vyrobek.pheByIdPhe1 left join fetch vyrobek.pheByIdPhe2 where " + podminkaObchod + " " + "and (vyrobek.smazano is null or vyrobek.smazano=false) " + "and (vyrobek.suplik is null or vyrobek.suplik=false)").list();
        IndexWriter writer = new IndexWriter(index_dir, (Analyzer)new CzechAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
        String cestaSitemap = String.valueOf(rootDir) + "dbimg" + File.separator;
        PrintWriter sitemapWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(cestaSitemap) + "sitemap.xml"), "UTF-8"));
        this.sitemapVlozHlavicku(sitemapWriter);
        this.indexVyrobky(writer, vlastnosti, sitemapWriter, url);
        this.sitemapVlozKategorie(sitemapWriter, kategorie, url);
        this.sitemapVlozInformace(sitemapWriter, hsess, url, obchod);
        this.sitemapVlozClanky(sitemapWriter, hsess, url, obchod);
        this.sitemapVlozPaticku(sitemapWriter);
        sitemapWriter.close();
        writer.optimize();
        writer.close();
    }

    private void indexVyrobky(IndexWriter writer, List vyrobky, PrintWriter sitemapWriter, String url) throws IOException {
        int i = 0;
        for (Vyrobek vyrobek : vyrobky) {
            this.indexVyrobek(writer, vyrobek, sitemapWriter, url);
            ++i;
        }
    }

    private void indexVyrobek(IndexWriter writer, Vyrobek vyrobek, PrintWriter sitemapWriter, String url) throws IOException {
        try {
            Document doc = new Document();
            doc.add((Fieldable)new Field("ostatniInformace", vyrobek.getOstatniInformace() == null ? "" : vyrobek.getOstatniInformace(), Field.Store.NO, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("idVyrobku", vyrobek.getId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field("nazev", vyrobek.getNazevUpraveny() != null && vyrobek.getNazevUpraveny().trim().length() > 0 ? vyrobek.getNazevUpraveny() : vyrobek.getNazev(), Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("nazevUpraveny", this.rozsirNazevString(vyrobek.getNazev()), Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("znacka", vyrobek.getZnacka() == null ? "" : vyrobek.getZnacka(), Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("cena", vyrobek.getCena().toString(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("cenai", vyrobek.getCenaiPrevedena().toString(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("pheByIdPhe1", vyrobek.getPheByIdPhe1() == null ? "0.0" : vyrobek.getPheByIdPhe1().getCena().toString(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("pheByIdPhe2", vyrobek.getPheByIdPhe2() == null ? "0.0" : vyrobek.getPheByIdPhe2().getCena().toString(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("nazevKategorie", vyrobek.getKategorieByIdKategorie2().getDlouhyNazev(), Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("nazevObchodu", vyrobek.getKategorieByIdKategorie2().getObchod().getNazev(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("idObchodu", vyrobek.getKategorieByIdKategorie2().getKategorie().getObchod().getId(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("nazevOptimalizovany", vyrobek.getNazevOptimalizovany(), Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("obrazek", vyrobek.getPrvniObrazek() != null ? vyrobek.getPrvniObrazek().getSoubor() : "", Field.Store.YES, Field.Index.NO));
            Parametr parametr = (Parametr)vyrobek.getParametry().get("novinka");
            doc.add((Fieldable)new Field("novinka", parametr != null ? parametr.getHodnota() : "", Field.Store.YES, Field.Index.NO));
            parametr = (Parametr)vyrobek.getParametry().get("specialni");
            doc.add((Fieldable)new Field("specialni", parametr != null ? parametr.getHodnota() : "", Field.Store.YES, Field.Index.NO));
            parametr = (Parametr)vyrobek.getParametry().get("do_vyprodani");
            doc.add((Fieldable)new Field("do_vyprodani", parametr != null ? parametr.getHodnota() : "", Field.Store.YES, Field.Index.NO));
            parametr = (Parametr)vyrobek.getParametry().get("akcni_cena");
            doc.add((Fieldable)new Field("akcni_cena", parametr != null ? parametr.getHodnota() : "", Field.Store.YES, Field.Index.NO));
            parametr = (Parametr)vyrobek.getParametry().get("akcni_nabidka");
            doc.add((Fieldable)new Field("akcni_nabidka", parametr != null ? parametr.getHodnota() : "", Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("popis", vyrobek.getPopisUpraveny() != null && vyrobek.getPopisUpraveny().trim().length() > 0 ? vyrobek.getPopisUpraveny() : (vyrobek.getPopis() == null ? "" : vyrobek.getPopis()), Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("popis2", vyrobek.getPopis2() == null ? "" : vyrobek.getPopis2(), Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("dostupnost", vyrobek.getDostupnost() != null ? vyrobek.getDostupnost().toString() : "-1", Field.Store.YES, Field.Index.NO));
            String odkaz = "/" + vyrobek.getLink();
            doc.add((Fieldable)new Field("odkaz", String.valueOf(vyrobek.getKategorieByIdKategorie2().getObchod().getId()) + odkaz, Field.Store.YES, Field.Index.NO));
            writer.addDocument(doc);
            sitemapWriter.write("\t<url>\n");
            sitemapWriter.write("\t\t<loc>http://" + url + "/" + vyrobek.getLink() + "</loc>\n");
            sitemapWriter.write("\t\t<lastmod>" + this.sitemapDateFormat.format(vyrobek.getT()) + "</lastmod>\n");
            sitemapWriter.write("\t</url>\n");
        }
        catch (Exception e) {
            return;
        }
    }

    private String rozsirRetezec(String vstup) {
        StringBuffer vystup = new StringBuffer();
        if (vstup != null) {
            vstup = vstup.trim();
            int i = 0;
            while (i < vstup.length()) {
                if (i > 0) {
                    vystup.append(" ");
                }
                vystup.append(vstup.substring(i));
                ++i;
            }
        }
        return vystup.toString();
    }

    private String rozsirNazevString(String vstup) {
        StringBuffer vystup = new StringBuffer();
        vystup.append(this.rozsirRetezec(vstup));
        vystup.append(" ");
        vystup.append(this.rozsirRetezec(vstup.replaceAll("[- ]", "")));
        return vystup.toString();
    }

    private void sitemapVlozHlavicku(PrintWriter sitemapWriter) {
        sitemapWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sitemapWriter.write("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n");
    }

    private void sitemapVlozPaticku(PrintWriter sitemapWriter) {
        sitemapWriter.write("</urlset>\n");
    }

    public void sitemapVlozKategorie(PrintWriter sitemapWriter, List seznamKategorii, String url) {
        for (Kategorie kategorie : seznamKategorii) {
            sitemapWriter.write("\t<url>\n");
            sitemapWriter.write("\t\t<loc>http://" + url + "/" + kategorie.getObchod().getPrefixCesta() + "oddeleni-" + kategorie.getDlouhyKod() + ".do?id=" + kategorie.getId() + "</loc>\n");
            sitemapWriter.write("\t\t<lastmod>" + this.sitemapDateFormat.format(kategorie.getT()) + "</lastmod>\n");
            sitemapWriter.write("\t</url>\n");
        }
    }

    public void sitemapVlozInformace(PrintWriter sitemapWriter, Session hsess, String url, String id_obchod) {
        List informace = hsess.createQuery("from Informace2 informace where informace.obchod.id=? order by informace.razeni").setString(0, id_obchod).list();
        for (Informace2 informace2 : informace) {
            sitemapWriter.write("\t<url>\n");
            sitemapWriter.write("\t\t<loc>http://" + url + "/" + "informace-" + informace2.getKod() + ".do" + "</loc>\n");
            sitemapWriter.write("\t</url>\n");
        }
    }

    public void sitemapVlozClanky(PrintWriter sitemapWriter, Session hsess, String url, String id_obchod) {
        List seznamClanku = hsess.createQuery("from Clanek clanek where clanek.obchod.id=?order by clanek.razeni").setString(0, id_obchod).list();
        if (seznamClanku.size() > 0) {
            sitemapWriter.write("\t<url>\n");
            sitemapWriter.write("\t\t<loc>http://" + url + "/clanky-seznam.do</loc>\n");
            sitemapWriter.write("\t</url>\n");
        }
        for (Clanek clanek : seznamClanku) {
            sitemapWriter.write("\t<url>\n");
            sitemapWriter.write("\t\t<loc>http://" + url + "/" + "clanky-" + clanek.getLink() + ".do" + "</loc>\n");
            sitemapWriter.write("\t</url>\n");
        }
    }

    public static void main(String[] args) {
        IndexovaniService is = new IndexovaniService();
        System.out.println(is.rozsirNazevString("TX-P42X10Y"));
    }
}

