/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.www;

import cz.rtnext.eshop.data.Kupon;
import cz.rtnext.eshop.data.Vyrobek;
import cz.rtnext.eshop.form.KosikForm;
import cz.rtnext.eshop.www.Kosik;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;

public class KosikService {
    public Map pridatDoKosiku(Kosik kosik, String idVyrobku, int pocet, Session hsess) {
        HashMap<String, Kosik> vysledek = new HashMap<String, Kosik>();
        if (kosik == null) {
            return vysledek;
        }
        Vyrobek vyrobek = null;
        try {
            vyrobek = (Vyrobek)hsess.get(Vyrobek.class, (Serializable)((Object)idVyrobku));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vyrobek != null) {
            int novyPocet = 0;
            Integer staryPocet = (Integer)kosik.getPocty().get(idVyrobku);
            if (staryPocet != null) {
                int staryPocetI = staryPocet;
                novyPocet = staryPocetI + pocet;
                if (novyPocet < 1) {
                    kosik.getPocty().remove(idVyrobku);
                }
            } else {
                novyPocet = pocet;
            }
            if (novyPocet > 0) {
                kosik.getPocty().put(idVyrobku, new Integer(novyPocet));
            }
            vysledek.put("kosik", kosik);
        }
        return vysledek;
    }

    public Map odebratZKosiku(Kosik kosik, String idVyrobku, int pocet, Session hsess) {
        HashMap<String, Kosik> vysledek = new HashMap<String, Kosik>();
        if (kosik == null) {
            return vysledek;
        }
        if (idVyrobku != null) {
            int novyPocet = 0;
            Integer staryPocet = (Integer)kosik.getPocty().get(idVyrobku);
            if (staryPocet != null) {
                int staryPocetI = staryPocet;
                novyPocet = staryPocetI - pocet;
                if (novyPocet < 1) {
                    kosik.getPocty().remove(idVyrobku);
                }
            } else {
                novyPocet = pocet;
            }
            if (novyPocet > 0) {
                kosik.getPocty().put(idVyrobku, new Integer(novyPocet));
            }
            vysledek.put("kosik", kosik);
        }
        return vysledek;
    }

    public Map prepocitejKosik(Kosik kosik, Session hsess, String kuponNazev, MessageResources res) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        if (kosik == null) {
            return null;
        }
        float celkovaCena = 0.0f;
        float celkovaSleva = 0.0f;
        float celkovaCenaPoSleve = 0.0f;
        Kupon kupon = null;
        double procento = 0.0;
        HashMap<String, String> kuponVyrobky = null;
        String kuponZnacka = null;
        double nejvyssiDopravne = 0.0;
        if (kuponNazev != null && kuponNazev.trim().length() > 0) {
            Iterator iter = hsess.createQuery("from Kupon kupon where upper(nazev)=? and platnostOd<=current_date() and platnostDo>=current_date()").setString(0, kuponNazev.trim().toUpperCase()).iterate();
            if (iter.hasNext()) {
                kuponVyrobky = new HashMap<String, String>();
                kupon = (Kupon)iter.next();
                procento = kupon.getProcento();
                if (kupon.getVyrobky() != null && kupon.getVyrobky().trim().length() > 0) {
                    if (kupon.getVyrobky().startsWith("@znacka=")) {
                        kuponZnacka = kupon.getVyrobky().substring(8);
                    } else {
                        StringTokenizer st = new StringTokenizer(kupon.getVyrobky(), ",");
                        while (st.hasMoreTokens()) {
                            String idVyrobku = st.nextToken();
                            kuponVyrobky.put(idVyrobku, idVyrobku);
                        }
                    }
                }
            } else if (res != null) {
                vysledek.put("chyba", res.getMessage("validace.kupon"));
            }
        }
        if (kosik.getPocty().size() > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            int celkovyPocet = 0;
            for (String klic : kosik.getPocty().keySet()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("'" + klic + "'");
                try {
                    celkovyPocet += ((Integer)kosik.getPocty().get(klic)).intValue();
                }
                catch (Exception e) {
                    kosik.getPocty().remove(klic);
                }
                ++i;
            }
            kosik.setPocet(new Integer(celkovyPocet));
            List vyrobky = hsess.createQuery("from Vyrobek vyrobek where vyrobek in (" + sb.toString() + ")").list();
            vysledek.put("vyrobky", vyrobky);
            for (Vyrobek vyrobek : vyrobky) {
                int pocet = 0;
                try {
                    pocet = (Integer)kosik.getPocty().get(vyrobek.getId());
                }
                catch (Exception e) {
                    pocet = 0;
                }
                float cenaVyrobku = new Float(vyrobek.getCenaiPrevedena().floatValue()).floatValue();
                float slevaVyrobek = 0.0f;
                double procentoVyrobek = 0.0;
                if (kupon != null) {
                    if (kuponVyrobky.size() > 0) {
                        procentoVyrobek = 0.0;
                        if (kuponVyrobky.get(vyrobek.getId()) != null) {
                            procentoVyrobek = procento;
                        }
                    } else if (kuponZnacka != null && kuponZnacka.trim().length() > 0) {
                        if (vyrobek.getZnacka().equalsIgnoreCase(kuponZnacka)) {
                            procentoVyrobek = procento;
                        }
                    } else {
                        procentoVyrobek = procento;
                    }
                }
                slevaVyrobek = new Float(Math.round(vyrobek.getCenaiPrevedena() * procentoVyrobek)).floatValue();
                float cenaVyrobkuPoSleve = cenaVyrobku - slevaVyrobek;
                if (vyrobek.getCenaDoprava() != null && vyrobek.getCenaDoprava() > nejvyssiDopravne) {
                    nejvyssiDopravne = vyrobek.getCenaDoprava();
                }
                celkovaCena += cenaVyrobku * (float)pocet;
                celkovaSleva += slevaVyrobek * (float)pocet;
                celkovaCenaPoSleve += cenaVyrobkuPoSleve * (float)pocet;
            }
        }
        kosik.setCelkovaCena(new Float(celkovaCena));
        kosik.setCelkovaSleva(Float.valueOf(celkovaSleva));
        kosik.setCelkovaCenaPoSleve(Float.valueOf(celkovaCenaPoSleve));
        kosik.setNejvyssiDopravne(nejvyssiDopravne);
        vysledek.put("kosik", kosik);
        return vysledek;
    }

    public KosikForm naplnFormular(Kosik kosik) {
        KosikForm form = new KosikForm();
        if (kosik != null) {
            for (String klic : kosik.getPocty().keySet()) {
                form.setPocet(klic, ((Integer)kosik.getPocty().get(klic)).toString());
                form.setVyprazdnit(klic, "false");
            }
        }
        return form;
    }

    public Kosik naplnVyprazdniKosik(KosikForm kosikForm, Kosik kosik, boolean odstranit) {
        for (String klic : kosikForm.getPocetMap().keySet()) {
            String vyprazdnit;
            try {
                int pocet = Integer.parseInt((String)kosikForm.getPocet(klic));
                if (pocet > 0) {
                    kosik.getPocty().put(klic, new Integer(pocet));
                }
                if (pocet == 0) {
                    kosik.getPocty().remove(klic);
                }
            }
            catch (Exception pocet) {
                // empty catch block
            }
            if (!odstranit || (vyprazdnit = (String)kosikForm.getVyprazdnit(klic)) == null || !vyprazdnit.equalsIgnoreCase("true")) continue;
            kosik.getPocty().remove(klic);
        }
        return kosik;
    }

    public Kosik naplnKosik(KosikForm kosikForm, Kosik kosik) {
        return this.naplnVyprazdniKosik(kosikForm, kosik, true);
    }

    public Kosik vyprazdniKosik(Kosik kosik) {
        kosik.getPocty().clear();
        kosik.setPocet(new Integer(0));
        kosik.setCelkovaCena(new Float(0.0));
        return kosik;
    }
}

