/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.www;

import cz.rtnext.eshop.data.Doprava;
import cz.rtnext.eshop.data.Kupon;
import cz.rtnext.eshop.data.Objednavka;
import cz.rtnext.eshop.data.Platba;
import cz.rtnext.eshop.data.PolozkaObjednavky;
import cz.rtnext.eshop.data.Uzivatel;
import cz.rtnext.eshop.data.Vyrobek;
import cz.rtnext.eshop.form.ObjednavkaForm;
import cz.rtnext.eshop.form.ObjednavkaKrok1Form;
import cz.rtnext.eshop.form.ObjednavkaKrok2Form;
import cz.rtnext.eshop.www.Kosik;
import cz.rtnext.util.ConvertService;
import cz.rtnext.util.HibernateUtil;
import cz.rtnext.util.UpravaRetezce;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;

public class ObjednavkaService {
    public Map nacti(org.hibernate.Session hsess, Integer id, ObjednavkaForm form) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        if (form == null) {
            form = new ObjednavkaForm();
        }
        try {
            if (id != null) {
                Uzivatel polozka = (Uzivatel)hsess.get(Uzivatel.class, (Serializable)id);
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                ConvertService.odregistrujCeske();
            }
            vysledek.put("objednavkaForm", (Object)form);
        }
        catch (Exception e) {
            vysledek.put("chyba", e.getMessage());
        }
        return vysledek;
    }

    public Map nactiKrok1(org.hibernate.Session hsess, Integer id, ObjednavkaKrok1Form form, ObjednavkaForm objednavkaForm) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        if (form == null) {
            form = new ObjednavkaKrok1Form();
        }
        try {
            ConvertService.registrujCeske();
            if (objednavkaForm != null) {
                BeanUtils.copyProperties((Object)((Object)form), (Object)((Object)objednavkaForm));
            }
            if (id != null) {
                Uzivatel polozka = (Uzivatel)hsess.get(Uzivatel.class, (Serializable)id);
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                BeanUtils.copyProperties((Object)((Object)objednavkaForm), (Object)polozka);
            }
            ConvertService.odregistrujCeske();
            vysledek.put("objednavkaKrok1Form", (Object)form);
            vysledek.put("objednavkaForm", (Object)objednavkaForm);
        }
        catch (Exception e) {
            vysledek.put("chyba", e.getMessage());
        }
        return vysledek;
    }

    public Map nactiKrok2(org.hibernate.Session hsess, Integer id, ObjednavkaKrok1Form form, ObjednavkaForm objednavkaForm, ActionMapping mapping, HttpServletRequest request, MessageResources res) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ConvertService.registrujCeske();
            ObjednavkaKrok2Form objednavkaKrok2Form = new ObjednavkaKrok2Form();
            if (request.getParameter("akce") != null && request.getParameter("akce").equalsIgnoreCase("odeslan_formular")) {
                BeanUtils.copyProperties((Object)((Object)objednavkaForm), (Object)((Object)form));
                ActionErrors errors = form.validate(mapping, request);
                if (errors != null && !errors.isEmpty()) {
                    vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors, res));
                    vysledek.put("validacni_chyby", this.validacniChyby((ActionMessages)errors, res));
                    vysledek.put("objednavkaKrok1Form", (Object)form);
                    return vysledek;
                }
                errors = new ActionMessages();
            }
            BeanUtils.copyProperties((Object)((Object)objednavkaKrok2Form), (Object)((Object)objednavkaForm));
            if (id != null) {
                Uzivatel polozka = (Uzivatel)hsess.get(Uzivatel.class, (Serializable)id);
                BeanUtils.copyProperties((Object)((Object)objednavkaKrok2Form), (Object)polozka);
                BeanUtils.copyProperties((Object)((Object)objednavkaForm), (Object)polozka);
            }
            ConvertService.odregistrujCeske();
            vysledek.put("objednavkaKrok2Form", (Object)objednavkaKrok2Form);
            vysledek.put("objednavkaForm", (Object)objednavkaForm);
        }
        catch (Exception e) {
            vysledek.put("chyba", e.getMessage());
        }
        return vysledek;
    }

    public Map nactiKrok3(org.hibernate.Session hsess, Integer id, ObjednavkaKrok2Form form, ObjednavkaForm objednavkaForm, ActionMapping mapping, HttpServletRequest request, MessageResources res) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Iterator iter;
            ActionErrors errors;
            ConvertService.registrujCeske();
            if (objednavkaForm != null) {
                BeanUtils.copyProperties((Object)((Object)objednavkaForm), (Object)((Object)form));
            }
            if ((errors = form.validate(mapping, request)) != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors, res));
                vysledek.put("validacni_chyby", this.validacniChyby((ActionMessages)errors, res));
                vysledek.put("objednavkaKrok2Form", (Object)form);
                return vysledek;
            }
            errors = new ActionMessages();
            if (form.getKupon() != null && form.getKupon().trim().length() > 0 && !(iter = hsess.createQuery("from Kupon kupon where upper(nazev)=? and platnostOd<=current_date() and platnostDo>=current_date()").setString(0, form.getKupon().trim().toUpperCase()).iterate()).hasNext()) {
                vysledek.put("validacni_chyba", res.getMessage("validace.kupon"));
                vysledek.put("validacni_chyby", res.getMessage("validace.kupon"));
                vysledek.put("objednavkaForm", (Object)form);
                return vysledek;
            }
            if (objednavkaForm != null) {
                BeanUtils.copyProperties((Object)((Object)objednavkaForm), (Object)((Object)form));
            }
            ConvertService.odregistrujCeske();
            vysledek.put("objednavkaForm", (Object)objednavkaForm);
        }
        catch (Exception e) {
            vysledek.put("chyba", e.getMessage());
        }
        return vysledek;
    }

    public Map uloz(Kosik kosik, ObjednavkaForm form, ActionMapping mapping, HttpServletRequest request, org.hibernate.Session hsess, MessageResources res, String sablonaCisla, String cesta, String mobil, String kuponNazev, String idObchod) {
        return this.uloz(kosik, form, mapping, request, hsess, res, sablonaCisla, cesta, mobil, kuponNazev, idObchod, true);
    }

    public Map uloz(Kosik kosik, ObjednavkaForm form, ActionMapping mapping, HttpServletRequest request, org.hibernate.Session hsess, MessageResources res, String sablonaCisla, String cesta, String mobil, String kuponNazev, String idObchod, boolean ulozit) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            boolean registrovan = false;
            registrovan = kosik.getUzivatelId() != null;
            if (registrovan && (form.getJmeno() == null || form.getJmeno().trim().length() == 0)) {
                form = (ObjednavkaForm)((Object)this.nacti(hsess, kosik.getUzivatelId(), form).get("objednavkaForm"));
                Uzivatel uzivatel = (Uzivatel)hsess.load(Uzivatel.class, (Serializable)kosik.getUzivatelId());
            }
            ActionErrors errors = null;
            if (ulozit) {
                errors = form.validate(mapping, request);
            }
            Kupon kupon = null;
            double procento = 0.0;
            HashMap<String, String> kuponVyrobky = null;
            String kuponZnacka = null;
            if (kuponNazev != null && kuponNazev.trim().length() > 0) {
                Iterator iter = hsess.createQuery("from Kupon kupon where upper(nazev)=? and platnostOd<=current_date() and platnostDo>=current_date()").setString(0, kuponNazev.trim().toUpperCase()).iterate();
                if (!iter.hasNext()) {
                    vysledek.put("validacni_chyba", res.getMessage("validace.kupon"));
                    vysledek.put("validacni_chyby", res.getMessage("validace.kupon"));
                    vysledek.put("objednavkaForm", (Object)form);
                    return vysledek;
                }
                kuponVyrobky = new HashMap<String, String>();
                kupon = (Kupon)iter.next();
                procento = kupon.getProcento();
                if (kupon.getVyrobky() != null && kupon.getVyrobky().trim().length() > 0) {
                    if (kupon.getVyrobky().startsWith("@znacka=")) {
                        kuponZnacka = kupon.getVyrobky().substring(8);
                    } else {
                        StringTokenizer st = new StringTokenizer(kupon.getVyrobky(), ",");
                        while (st.hasMoreTokens()) {
                            String idVyrobku = st.nextToken();
                            kuponVyrobky.put(idVyrobku, idVyrobku);
                        }
                    }
                }
            }
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors, res));
                vysledek.put("validacni_chyby", this.validacniChyby((ActionMessages)errors, res));
                vysledek.put("objednavkaForm", (Object)form);
                return vysledek;
            }
            errors = new ActionMessages();
            Objednavka objednavka = new Objednavka();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)objednavka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            double naklady = 0.0;
            if (form.getPlatba() != null && form.getPlatba().length() > 0) {
                Platba platba = (Platba)hsess.get(Platba.class, (Serializable)((Object)form.getPlatba()));
                objednavka.setPlatba(platba.getNazev());
                naklady += platba.getCastka().doubleValue();
            }
            Doprava doprava = null;
            if (form.getDoprava() != null && form.getDoprava().length() > 0) {
                doprava = (Doprava)hsess.get(Doprava.class, (Serializable)((Object)form.getDoprava()));
                naklady += doprava.getCastka().doubleValue();
                objednavka.setDopravaNazev(doprava.getNazev());
                objednavka.setIdDoprava(doprava.getId());
            }
            if (kosik.getUzivatelId() != null) {
                Uzivatel uzivatel = null;
                try {
                    uzivatel = (Uzivatel)hsess.get(Uzivatel.class, (Serializable)kosik.getUzivatelId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                objednavka.setUzivatel(uzivatel);
            }
            objednavka.setDatum(new Date());
            objednavka.setPrecteno(Boolean.FALSE);
            if (form.getOdkudSeznam() != null && form.getOdkudSeznam().equalsIgnoreCase("nezadano")) {
                objednavka.setOdkud(form.getOdkud());
            } else {
                objednavka.setOdkud(form.getOdkudSeznam());
            }
            if (ulozit) {
                this.upravitObjednavkuPredUlozenim(objednavka);
                hsess.save((Object)objednavka);
            }
            if (kosik.getPocty().size() > 0) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                for (String klic : kosik.getPocty().keySet()) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append("'" + klic + "'");
                    ++i;
                }
                List vyrobky = hsess.createQuery("from Vyrobek vyrobek where vyrobek in (" + sb.toString() + ")").list();
                double celkovaCastka = 0.0;
                double celkovaSleva = 0.0;
                double celkovaCenaPoSleve = 0.0;
                double nejvyssiDopravne = 0.0;
                for (Vyrobek vyrobek : vyrobky) {
                    int pocet = 0;
                    try {
                        pocet = (Integer)kosik.getPocty().get(vyrobek.getId());
                    }
                    catch (Exception e) {
                        pocet = 0;
                    }
                    if (pocet <= 0) continue;
                    double cenaVyrobku = new Float(vyrobek.getCenaiPrevedena().floatValue() * (float)pocet).floatValue();
                    float slevaVyrobek = 0.0f;
                    double procentoVyrobek = 0.0;
                    if (kupon != null) {
                        if (kuponVyrobky.size() > 0) {
                            procentoVyrobek = 0.0;
                            if (kuponVyrobky.get(vyrobek.getId()) != null) {
                                procentoVyrobek = procento;
                            }
                        } else if (kuponZnacka != null && kuponZnacka.trim().length() > 0) {
                            if (vyrobek.getZnacka().equalsIgnoreCase(kuponZnacka)) {
                                procentoVyrobek = procento;
                            }
                        } else {
                            procentoVyrobek = procento;
                        }
                    }
                    slevaVyrobek = new Float(Math.round(vyrobek.getCenaiPrevedena() * procentoVyrobek)).floatValue();
                    double cenaVyrobkuPoSleve = cenaVyrobku - (double)slevaVyrobek;
                    celkovaSleva += (double)(slevaVyrobek * (float)pocet);
                    celkovaCenaPoSleve += cenaVyrobkuPoSleve * (double)pocet;
                    PolozkaObjednavky polozka = new PolozkaObjednavky();
                    polozka.setCenaKus(vyrobek.getCenaiPrevedena());
                    polozka.setIdSklad(vyrobek.getId());
                    polozka.setKs(pocet);
                    polozka.setNazev(vyrobek.getNazevVyplneny());
                    polozka.setObjednavka(objednavka);
                    polozka.setCodeSklad(vyrobek.getCodeSklad());
                    polozka.setZnacka(vyrobek.getZnacka());
                    polozka.setPhe1(vyrobek.getPhe1() != null ? vyrobek.getPhe1().getCena() : 0.0);
                    polozka.setPhe2(vyrobek.getPhe2() != null ? vyrobek.getPhe2().getCena() : 0.0);
                    polozka.setSleva(new Double(slevaVyrobek));
                    objednavka.getPolozkaObjednavkies().add(polozka);
                    polozka.setT(new Date());
                    if (ulozit) {
                        hsess.save((Object)polozka);
                    }
                    celkovaCastka += (double)pocet * (vyrobek.getCenaiPrevedena() - (double)slevaVyrobek);
                    if (vyrobek.getCenaDoprava() == null || !(vyrobek.getCenaDoprava() > nejvyssiDopravne)) continue;
                    nejvyssiDopravne = vyrobek.getCenaDoprava();
                }
                naklady += nejvyssiDopravne;
                if (!(form.getPlatba() != null && form.getPlatba().length() != 0 || form.getDoprava() != null && form.getDoprava().length() != 0 || form.getDopravne() == null)) {
                    naklady = form.getDopravne();
                }
                objednavka.setDopravne(naklady);
                if (doprava != null && doprava.getId().equalsIgnoreCase("osobni")) {
                    objednavka.setDopravne(doprava.getCastka());
                }
                if (doprava != null && doprava.getOdpustit() < celkovaCastka) {
                    objednavka.setDopravne(new Double(0.0));
                }
                if (ulozit) {
                    String ids = objednavka.getId().toString();
                    String cislo = this.getUpraveneCislo(sablonaCisla, objednavka.getDatum(), ids);
                    objednavka.setCislo(cislo);
                }
                if (kupon != null) {
                    objednavka.setKupon(kupon.getNazevDlouhy());
                }
                objednavka.setObchod(idObchod);
                if (kupon != null) {
                    objednavka.setPoznObchod(kupon.getNazevDlouhy());
                }
            }
            vysledek.put("objednavka", objednavka);
            if (ulozit) {
                HibernateUtil.orezStringy(objednavka);
                hsess.flush();
                if (idObchod.equalsIgnoreCase("tescoma") || idObchod.equalsIgnoreCase("novypanasonic") || idObchod.equalsIgnoreCase("dostal2010")) {
                    this.odesliMailDostal(objednavka, res.getMessage("mail.host"), res.getMessage("mail.from"), res.getMessage("mail.to"), res.getMessage("mail.1"), String.valueOf(cesta) + "pages" + File.separator + "reklam_mail.txt", String.valueOf(cesta) + "pages" + File.separator + "uvod_mail.txt", mobil);
                } else if (idObchod.equalsIgnoreCase("zlatobrilianty")) {
                    this.odesliMailMujStyl(objednavka, res.getMessage("mail.host"), res.getMessage("mail.from"), res.getMessage("mail.to"), res.getMessage("mail.1"), res);
                } else if (idObchod.equalsIgnoreCase("postele")) {
                    this.odesliMailPostele(objednavka, res.getMessage("mail.host"), res.getMessage("mail.from"), res.getMessage("mail.to"), res.getMessage("mail.1"), res);
                } else if (idObchod.equalsIgnoreCase("hrnce")) {
                    this.odesliMailWald(objednavka, res.getMessage("mail.host"), res.getMessage("mail.from"), res.getMessage("mail.to"), res.getMessage("mail.1"));
                } else if (idObchod.equalsIgnoreCase("zvykacky")) {
                    this.odesliMailZvykacky(objednavka, res.getMessage("mail.host"), res.getMessage("mail.from"), res.getMessage("mail.to"), res.getMessage("mail.1"));
                }
            }
        }
        catch (MessagingException e) {
            return vysledek;
        }
        catch (HibernateException e) {
            vysledek.put("chyba", res.getMessage("validace.objednavka.nezdar", (Object)e.getMessage()));
            hsess.getTransaction().rollback();
            System.out.println("objvybav");
            e.printStackTrace();
        }
        catch (Exception e) {
            vysledek.put("chyba", res.getMessage("validace.objednavka.nezdar", (Object)e.getMessage()));
            System.out.println("objeshop");
            e.printStackTrace();
        }
        return vysledek;
    }

    public String getUpraveneCislo(String sablona, Date date, String sid) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        SimpleDateFormat formatter = new SimpleDateFormat(sablona);
        String vysledek = formatter.format(cal.getTime());
        vysledek = String.valueOf(vysledek.substring(0, vysledek.length() - sid.length())) + sid;
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages, MessageResources res) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    private List validacniChyby(ActionMessages messages, MessageResources res) {
        ArrayList<String> vysledek = new ArrayList<String>();
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            while (iter.hasNext()) {
                ActionMessage message = (ActionMessage)iter.next();
                vysledek.add(res.getMessage(message.getKey(), message.getValues()));
            }
        }
        return vysledek;
    }

    public Map nacteniDopravy(org.hibernate.Session hsess) {
        HashMap<String, List> vysledek = new HashMap<String, List>();
        List dopravy = hsess.createQuery("from Doprava doprava order by doprava.razeni").list();
        vysledek.put("dopravy", dopravy);
        List platby = hsess.createQuery("from Platba platba order by platba.razeni").list();
        vysledek.put("platby", platby);
        return vysledek;
    }

    public Double nactiCenuDopravy(String idDopravy, org.hibernate.Session hsess) {
        Double vysledek = new Double(0.0);
        if (idDopravy != null && idDopravy.length() > 0) {
            try {
                Doprava doprava = (Doprava)hsess.get(Doprava.class, (Serializable)((Object)idDopravy));
                if (doprava != null) {
                    vysledek = doprava.getCastka();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vysledek;
    }

    public Doprava nactiDopravu(String idDoprava, org.hibernate.Session hsess) {
        Doprava vysledek = null;
        if (idDoprava != null && idDoprava.length() > 0) {
            vysledek = (Doprava)hsess.get(Doprava.class, (Serializable)((Object)idDoprava));
        }
        return vysledek;
    }

    public Platba nactiPlatbu(String idPlatba, org.hibernate.Session hsess) {
        Platba vysledek = null;
        if (idPlatba != null && idPlatba.length() > 0) {
            vysledek = (Platba)hsess.get(Platba.class, (Serializable)((Object)idPlatba));
        }
        return vysledek;
    }

    public String nakupText(Objednavka obj) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        StringBuffer vysl = new StringBuffer();
        float celkovaCena = 0.0f;
        for (PolozkaObjednavky polozka : obj.getPolozkaObjednavkies()) {
            int pocet = 0;
            try {
                pocet = polozka.getKs();
            }
            catch (Exception e) {
                pocet = 0;
            }
            celkovaCena += polozka.getCenaKus().floatValue() * (float)pocet;
            if (pocet <= 0) continue;
            vysl.append(polozka.getCodeSklad());
            vysl.append("\t");
            if (polozka.getZnacka() != null) {
                vysl.append(polozka.getZnacka());
                vysl.append(" ");
            }
            vysl.append(polozka.getNazev());
            vysl.append("\t");
            vysl.append(pocet);
            vysl.append(" ks\t");
            vysl.append(nf.format(polozka.getCenaKus().floatValue() * (float)pocet));
            vysl.append('\n');
        }
        vysl.append("-----------------------------------------------------------------------------\n");
        vysl.append("Dopravn\u00e9:\t\t\t\t\t\t");
        vysl.append(nf.format(obj.getDopravne()));
        vysl.append('\n');
        float cenaOdvoz = 0.0f;
        if (obj.getOdvoz().booleanValue()) {
            vysl.append("Odvoz star\u00e9ho spot\u0159ebi\u010de:\t\t\t\t\t\t");
            vysl.append("299 K\u010d");
            vysl.append('\n');
            cenaOdvoz = 299.0f;
        }
        vysl.append("Celkem k \u00fahrad\u011b:\t\t\t\t\t");
        vysl.append(nf.format((double)celkovaCena + obj.getDopravne() + (double)cenaOdvoz));
        return vysl.toString();
    }

    public String osobniUdajeText(Objednavka obj) {
        StringBuffer obsah = new StringBuffer();
        if (obj != null) {
            obsah.append("Faktura\u010dn\u00ed adresa :\n");
            obsah.append("-------------------\n");
            obsah.append("firma: " + this.zobraz(obj.getNazevSpolecnosti()) + "\nI\u010c: " + this.zobraz(obj.getIc()) + "\nDI\u010c: " + this.zobraz(obj.getDic()) + "\njm\u00e9no: " + this.zobraz(obj.getJmeno()) + " " + this.zobraz(obj.getPrijmeni()) + "\nadresa: " + this.zobraz(obj.getUlice()) + " " + ", " + this.zobraz(obj.getMesto()) + ", " + this.zobraz(obj.getPsc()) + "\ntelefon: " + this.zobraz(obj.getTelefon()) + "\ne-mail: " + this.zobraz(obj.getEmail()) + "\npozn\u00e1mka:\n" + this.zobraz(obj.getPoznamka()) + "\n\n");
            obsah.append("Dodac\u00ed adresa :\n");
            obsah.append("---------------\n");
            obsah.append("firma: " + this.zobraz(obj.getDorucovaciJmeno()) + " " + this.zobraz(obj.getDorucovaciPrijmeni()) + "\nadresa: " + this.zobraz(obj.getDorucovaciUlice()) + " " + ", " + this.zobraz(obj.getDorucovaciMesto()) + ", " + this.zobraz(obj.getDorucovaciPsc()) + "\ntelefon: " + this.zobraz(obj.getDorucovaciTelefon()) + "\ne-mail: " + this.zobraz(obj.getDorucovaciEmail()) + "\n" + "\nZp\u016fsob dopravy: " + this.zobraz(obj.getDopravaNazev()) + "\n\nZp\u016fsob platby: " + this.zobraz(obj.getPlatba()) + "\n");
            if (obj.getKdyVolat() != null && obj.getKdyVolat().trim().length() > 0) {
                obsah.append("kdy volat: " + obj.getKdyVolat());
            }
        }
        return obsah.toString();
    }

    public String osobniUdajeTextZvykacky(Objednavka obj) {
        StringBuffer obsah = new StringBuffer();
        if (obj != null) {
            obsah.append("Faktura\u010dn\u00ed adresa :\n");
            obsah.append("-------------------\n");
            obsah.append("firma: " + this.zobraz(obj.getNazevSpolecnosti()) + "\nI\u010c: " + this.zobraz(obj.getIc()) + "\nDI\u010c: " + this.zobraz(obj.getDic()) + "\njm\u00e9no: " + this.zobraz(obj.getJmeno()) + " " + this.zobraz(obj.getPrijmeni()) + "\nadresa: " + this.zobraz(obj.getUlice()) + " " + ", " + this.zobraz(obj.getMesto()) + ", " + this.zobraz(obj.getPsc()) + "\ntelefon: " + this.zobraz(obj.getTelefon()) + "\ne-mail: " + this.zobraz(obj.getEmail()) + "\npozn\u00e1mka:\n" + this.zobraz(obj.getPoznamka()) + "\n\n");
            obsah.append("Dodac\u00ed adresa :\n");
            obsah.append("---------------\n");
            obsah.append("adresa: " + this.zobraz(obj.getDorucovaciUlice()) + " " + ", " + this.zobraz(obj.getDorucovaciMesto()) + ", " + this.zobraz(obj.getDorucovaciPsc()) + "\n");
        }
        return obsah.toString();
    }

    private String zobraz(String co) {
        return co == null ? "" : co;
    }

    public void odesliMailMujStyl(Objednavka obj, String mailServer, String mailFrom, String mailTo, String obchod, MessageResources res) throws MessagingException, IOException {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(0);
        Properties props = new Properties();
        props.put("mail.smtp.host", mailServer);
        Session mailsession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        StringTokenizer st = new StringTokenizer(mailTo, ",");
        while (st.hasMoreTokens()) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(st.nextToken()));
        }
        mesg.setSubject("Objednavka");
        StringBuffer obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + " / P\u0159ijet\u00ed obj. dne: " + DateFormat.getDateInstance(2, new Locale("cs")).format(new Date()) + " \u010d. obj.: " + obj.getCislo() + "\n\n");
        obsah.append("Bylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
        obsah.append("---------------------------------\n");
        obsah.append(this.nakupText(obj));
        obsah.append("\n\n");
        obsah.append(this.osobniUdajeText(obj));
        mesg.setText(obsah.toString(), "windows-1250");
        Transport.send((Message)mesg);
        mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getEmail()));
        mesg.setSubject(MimeUtility.encodeText((String)(String.valueOf(obchod.toUpperCase()) + " - ozn\u00e1men\u00ed o p\u0159ijet\u00ed objedn\u00e1vky"), (String)"windows-1250", null));
        obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + ", tel.:608 730 953, MUJ STYL s.r.o.\n");
        obsah.append("----------------------------------------------------------------------------------------------------\n\n");
        obsah.append("V\u00e1\u017een\u00e1 pan\u00ed, pane " + this.zobraz(obj.getPrijmeni()) + ",\n");
        obsah.append("D\u011bkujeme za V\u00e1\u0161 n\u00e1kup, Va\u0161e osobn\u00ed \u00fadaje:\n\n");
        obsah.append(this.osobniUdajeText(obj));
        obsah.append("\n\u010c\u00edslo objedn\u00e1vky: " + obj.getCislo());
        obsah.append("\nBylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
        obsah.append("-----------------------------------------------------------------------------\n");
        obsah.append(this.nakupText(obj));
        obsah.append("\n\nUveden\u00e9 ceny jsou v\u010detn\u011b DPH.\n");
        obsah.append("\n\nD\u011bkujeme za d\u016fv\u011bru.");
        obsah.append("\n\nZa " + obchod + ".cz\t\tMarek B\u00fabela, majitel firmy");
        obsah.append("\n");
        obsah.append("\n");
        mesg.setText(obsah.toString(), "windows-1250");
        if (obj.getDorucovaciEmail() != null && obj.getDorucovaciEmail().trim().length() > 0 && !obj.getEmail().equalsIgnoreCase(obj.getDorucovaciEmail())) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getDorucovaciEmail()));
        }
        Transport.send((Message)mesg);
    }

    public void odesliMailPostele(Objednavka obj, String mailServer, String mailFrom, String mailTo, String obchod, MessageResources res) throws MessagingException, IOException {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(0);
        Properties props = new Properties();
        props.put("mail.smtp.host", mailServer);
        Session mailsession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        StringTokenizer st = new StringTokenizer(mailTo, ",");
        while (st.hasMoreTokens()) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(st.nextToken()));
        }
        mesg.setSubject("Objednavka");
        StringBuffer obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + " / P\u0159ijet\u00ed obj. dne: " + DateFormat.getDateInstance(2, new Locale("cs")).format(new Date()) + " \u010d. obj.: " + obj.getCislo() + "\n\n");
        obsah.append("Bylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
        obsah.append("---------------------------------\n");
        obsah.append(this.nakupText(obj));
        obsah.append("\n\n");
        obsah.append(this.osobniUdajeText(obj));
        mesg.setText(obsah.toString(), "windows-1250");
        Transport.send((Message)mesg);
        mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getEmail()));
        mesg.setSubject(MimeUtility.encodeText((String)(String.valueOf(obchod.toUpperCase()) + " - ozn\u00e1men\u00ed o p\u0159ijet\u00ed objedn\u00e1vky"), (String)"windows-1250", null));
        obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + ", tel.:608 730 953, MUJ STYL s.r.o.\n");
        obsah.append("----------------------------------------------------------------------------------------------------\n\n");
        obsah.append("V\u00e1\u017een\u00e1 pan\u00ed, pane " + this.zobraz(obj.getPrijmeni()) + ",\n");
        obsah.append("D\u011bkujeme za V\u00e1\u0161 n\u00e1kup, Va\u0161e osobn\u00ed \u00fadaje:\n\n");
        obsah.append(this.osobniUdajeText(obj));
        obsah.append("\n\u010c\u00edslo objedn\u00e1vky: " + obj.getCislo());
        obsah.append("\nBylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
        obsah.append("-----------------------------------------------------------------------------\n");
        obsah.append(this.nakupText(obj));
        obsah.append("\n\nUveden\u00e9 ceny jsou v\u010detn\u011b DPH.\n");
        obsah.append("\n\nD\u011bkujeme za d\u016fv\u011bru.");
        obsah.append("\n\nZa " + obchod + ".cz\t\tMarek B\u00fabela, majitel firmy");
        obsah.append("\n");
        obsah.append("\n");
        mesg.setText(obsah.toString(), "windows-1250");
        if (obj.getDorucovaciEmail() != null && obj.getDorucovaciEmail().trim().length() > 0 && !obj.getEmail().equalsIgnoreCase(obj.getDorucovaciEmail())) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getDorucovaciEmail()));
        }
        Transport.send((Message)mesg);
    }

    public void odesliMailZvykacky(Objednavka obj, String mailServer, String mailFrom, String mailTo, String obchod) throws MessagingException, IOException {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(0);
        Properties props = new Properties();
        props.put("mail.smtp.host", mailServer);
        Session mailsession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        StringTokenizer st = new StringTokenizer(mailTo, ",");
        while (st.hasMoreTokens()) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(st.nextToken()));
        }
        mesg.setSubject("Objednavka");
        StringBuffer obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + " / P\u0159ijet\u00ed obj. dne: " + DateFormat.getDateInstance(2, new Locale("cs")).format(new Date()) + " \u010d. obj.: " + obj.getCislo() + "\n\n");
        obsah.append("Bylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
        obsah.append("---------------------------------\n");
        obsah.append(this.nakupText(obj));
        obsah.append("\n\n");
        obsah.append(this.osobniUdajeTextZvykacky(obj));
        mesg.setText(obsah.toString(), "windows-1250");
        Transport.send((Message)mesg);
        mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getEmail()));
        mesg.setSubject(MimeUtility.encodeText((String)(String.valueOf(obchod.toUpperCase()) + " - ozn\u00e1men\u00ed o p\u0159ijet\u00ed objedn\u00e1vky"), (String)"windows-1250", null));
        obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + ", tel.: 585 433 216, 608 114 511, bezplatn\u00e1 linka: 800 1 ORBIT (800 1 67248), CTS Olomouc\n");
        obsah.append("---------------------------------------------------------------------------------------------------------\n\n");
        obsah.append("V\u00e1\u017een\u00e1 pan\u00ed, pane " + this.zobraz(obj.getPrijmeni()) + ",\n");
        obsah.append("D\u011bkujeme za V\u00e1\u0161 n\u00e1kup, Va\u0161e osobn\u00ed \u00fadaje:\n\n");
        obsah.append(this.osobniUdajeTextZvykacky(obj));
        obsah.append("\n\u010c\u00edslo objedn\u00e1vky: " + obj.getCislo());
        obsah.append("\nBylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
        obsah.append("-----------------------------------------------------------------------------\n");
        obsah.append(this.nakupText(obj));
        obsah.append("\n\nUveden\u00e9 ceny jsou v\u010detn\u011b DPH.\n");
        obsah.append("\n\nD\u011bkujeme za d\u016fv\u011bru.");
        obsah.append("\n\nZa " + obchod + "\t\tJaroslav Pet\u0159\u00edk, CTS Olomouc");
        obsah.append("\n");
        obsah.append("\n");
        mesg.setText(obsah.toString(), "windows-1250");
        if (obj.getDorucovaciEmail() != null && obj.getDorucovaciEmail().trim().length() > 0 && !obj.getEmail().equalsIgnoreCase(obj.getDorucovaciEmail())) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getDorucovaciEmail()));
        }
        Transport.send((Message)mesg);
    }

    public void odesliMailZvykackyRegistrace(Uzivatel uzivatel, String mailServer, String mailFrom, String mailTo, String obchod) throws MessagingException, IOException {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(0);
        Properties props = new Properties();
        props.put("mail.smtp.host", mailServer);
        Session mailsession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        StringTokenizer st = new StringTokenizer(mailTo, ",");
        while (st.hasMoreTokens()) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(st.nextToken()));
        }
        mesg.setSubject("Registrace - po\u017eadavek na stanoven\u00ed dopravn\u00e9ho");
        StringBuffer obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + " / P\u0159ijet\u00ed registrace dne: " + DateFormat.getDateInstance(2, new Locale("cs")).format(new Date()) + "\n\n");
        obsah.append("V e-shopu se registroval nov\u00fd z\u00e1kazn\u00edk:\n");
        obsah.append("---------------------------------\n");
        if (uzivatel != null) {
            obsah.append("Faktura\u010dn\u00ed adresa :\n");
            obsah.append("-------------------\n");
            obsah.append("firma: " + this.zobraz(uzivatel.getNazevSpolecnosti()) + "\nI\u010c: " + this.zobraz(uzivatel.getIc()) + "\nDI\u010c: " + this.zobraz(uzivatel.getDic()) + "\njm\u00e9no: " + this.zobraz(uzivatel.getJmeno()) + " " + this.zobraz(uzivatel.getPrijmeni()) + "\nadresa: " + this.zobraz(uzivatel.getUlice()) + " " + ", " + this.zobraz(uzivatel.getMesto()) + ", " + this.zobraz(uzivatel.getPsc()) + "\ntelefon: " + this.zobraz(uzivatel.getTelefon()) + "\ne-mail: " + this.zobraz(uzivatel.getEmail()) + "\n\n");
            obsah.append("Dodac\u00ed adresa :\n");
            obsah.append("---------------\n");
            obsah.append("adresa: " + this.zobraz(uzivatel.getDorucovaciUlice()) + " " + ", " + this.zobraz(uzivatel.getDorucovaciMesto()) + ", " + this.zobraz(uzivatel.getDorucovaciPsc()) + "\n");
        }
        obsah.append("\n\n");
        obsah.append("Z\u00e1kazn\u00edk \u010dek\u00e1 na stanoven\u00ed dopravn\u00e9ho.\n");
        mesg.setText(obsah.toString(), "windows-1250");
        Transport.send((Message)mesg);
        mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(uzivatel.getEmail()));
        mesg.setSubject(MimeUtility.encodeText((String)(String.valueOf(obchod.toUpperCase()) + " - ozn\u00e1men\u00ed o p\u0159ijet\u00ed registrace"), (String)"windows-1250", null));
        obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + ", tel.: 585 433 216, 608 114 511, bezplatn\u00e1 linka: 800 1 ORBIT (800 1 67248), CTS Olomouc\n");
        obsah.append("---------------------------------------------------------------------------------------------------------\n\n");
        obsah.append("V\u00e1\u017een\u00e1 pan\u00ed, pane " + this.zobraz(uzivatel.getPrijmeni()) + ",\n");
        obsah.append("D\u011bkujeme za V\u00e1\u0161i registraci, Va\u0161e osobn\u00ed \u00fadaje:\n\n");
        obsah.append("Faktura\u010dn\u00ed adresa :\n");
        obsah.append("-------------------\n");
        obsah.append("firma: " + this.zobraz(uzivatel.getNazevSpolecnosti()) + "\nI\u010c: " + this.zobraz(uzivatel.getIc()) + "\nDI\u010c: " + this.zobraz(uzivatel.getDic()) + "\njm\u00e9no: " + this.zobraz(uzivatel.getJmeno()) + " " + this.zobraz(uzivatel.getPrijmeni()) + "\nadresa: " + this.zobraz(uzivatel.getUlice()) + " " + ", " + this.zobraz(uzivatel.getMesto()) + ", " + this.zobraz(uzivatel.getPsc()) + "\ntelefon: " + this.zobraz(uzivatel.getTelefon()) + "\ne-mail: " + this.zobraz(uzivatel.getEmail()) + "\n\n");
        obsah.append("Dodac\u00ed adresa :\n");
        obsah.append("---------------\n");
        obsah.append("adresa: " + this.zobraz(uzivatel.getDorucovaciUlice()) + " " + ", " + this.zobraz(uzivatel.getDorucovaciMesto()) + ", " + this.zobraz(uzivatel.getDorucovaciPsc()) + "\n");
        obsah.append("\n\n");
        obsah.append("Individu\u00e1ln\u00ed cena dopravy, kter\u00e1 se po\u010d\u00edt\u00e1 podle vzd\u00e1lenosti, V\u00e1m bude zasl\u00e1na do 48 hodin od p\u0159ijet\u00ed registrace.");
        obsah.append("\n\nZa " + obchod + "\t\tJaroslav Pet\u0159\u00edk, CTS Olomouc");
        obsah.append("\n");
        obsah.append("\n");
        mesg.setText(obsah.toString(), "windows-1250");
        Transport.send((Message)mesg);
    }

    public void odesliMailDostal(Objednavka obj, String mailServer, String mailFrom, String mailTo, String obchod, String reklamSoubor, String uvodMail, String mobil) throws MessagingException, IOException {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(2);
        Properties props = new Properties();
        props.put("mail.smtp.host", mailServer);
        Session mailsession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        StringTokenizer st = new StringTokenizer(mailTo, ",");
        while (st.hasMoreTokens()) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(st.nextToken()));
        }
        mesg.setSubject("Objednavka");
        StringBuffer obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod.toUpperCase()) + " / P\u0159ijet\u00ed obj. dne: " + DateFormat.getDateInstance(2, new Locale("cs")).format(new Date()) + "\n\n");
        obsah.append("N\u00e1zev objedn\u00e1vky: " + obj.getJmeno() + ", " + obj.getPrijmeni() + "\n\n");
        obsah.append("Bylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
        obsah.append("---------------------------------\n");
        float celkovaCena = 0.0f;
        for (PolozkaObjednavky element : obj.getPolozkaObjednavkies()) {
            double celkovaCenaElementu = 0.0;
            double phe = element.getPhe1() != null ? element.getPhe1() : 0.0;
            double phe2 = element.getPhe2() != null ? element.getPhe2() : 0.0;
            obsah.append(String.valueOf(element.getZnacka()) + " " + element.getNazev() + "\t" + element.getKs() + " ks " + "\t" + numberFormat.format(element.getCenaKusPoSleve()) + " /ks \n");
            if (phe > 0.0 || phe2 > 0.0) {
                obsah.append("Cena v\u010detn\u011b PHE " + numberFormat.format(phe + phe2) + " /ks");
            } else {
                obsah.append("\n");
            }
            celkovaCenaElementu = element.getCenaKusPoSleve() * (double)element.getKs().intValue();
            celkovaCena = (float)((double)celkovaCena + celkovaCenaElementu);
        }
        obsah.append("\nDoprava (" + obj.getDopravaNazev() + "): " + numberFormat.format(obj.getDopravne()) + "\n");
        float cenaOdvoz = 0.0f;
        if (obj.getOdvoz().booleanValue()) {
            obsah.append("Odvoz star\u00e9ho spot\u0159ebi\u010de: 299 K\u010d\n");
            cenaOdvoz = 299.0f;
        }
        celkovaCena = (float)((double)celkovaCena + obj.getDopravne());
        obsah.append("Celkov\u00e1 cena:\t\t" + numberFormat.format(celkovaCena += cenaOdvoz) + "\n");
        obsah.append("Uveden\u00e9 ceny jsou v\u010detn\u011b DPH.\n");
        obsah.append("\n");
        obsah.append(this.osobniUdajeText(obj));
        mesg.setText(obsah.toString(), "windows-1250");
        Transport.send((Message)mesg);
        mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mobil));
        mesg.setSubject("Obj. ");
        StringBuffer sms = new StringBuffer("");
        sms.append(" " + this.zobraz(obj.getPrijmeni()) + " tel. " + this.zobraz(obj.getTelefon()) + " volat: " + this.zobraz(obj.getKdyVolat()) + " co: ");
        for (PolozkaObjednavky element : obj.getPolozkaObjednavkies()) {
            sms.append(String.valueOf(element.getZnacka()) + " " + element.getNazev() + " " + element.getKs() + " ks ");
        }
        mesg.setText(UpravaRetezce.odstranDiakritiku(sms.toString()), "windows-1250");
        Transport.send((Message)mesg);
        mesg = new MimeMessage(mailsession);
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getEmail()));
        mesg.setSubject(MimeUtility.encodeText((String)(String.valueOf(obchod) + " - ozn\u00e1men\u00ed o p\u0159ijet\u00ed objedn\u00e1vky"), (String)"windows-1250", null));
        obsah = new StringBuffer("");
        obsah.append(String.valueOf(obchod) + "   DOST\u00c1L CZ s.r.o.,Palack\u00e9ho 853/2  Litovel 784 01 tlf. 585 313 313, email: markety@dostal.cz\n");
        obsah.append("--------------------------------------------------------------------------------------------------------------\n\n");
        obsah.append("V\u00e1\u017een\u00e1 pan\u00ed, pane " + this.zobraz(obj.getPrijmeni()) + ",\n");
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(uvodMail), "windows-1250"));
        obsah.append(ObjednavkaService.readerToString(br));
        obsah.append("\u010c\u00edslo objedn\u00e1vky: " + obj.getCislo() + "\n");
        obsah.append("P\u0159ijet\u00ed objedn\u00e1vky dne: " + DateFormat.getDateInstance(1, new Locale("cs")).format(new Date()) + "\n\n");
        obsah.append(this.osobniUdajeText(obj));
        obsah.append("\n\n");
        obsah.append("Bylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
        obsah.append("---------------------------------\n");
        celkovaCena = 0.0f;
        for (PolozkaObjednavky element : obj.getPolozkaObjednavkies()) {
            double celkovaCenaElementu = 0.0;
            double phe = element.getPhe1() != null ? element.getPhe1() : 0.0;
            double phe2 = element.getPhe2() != null ? element.getPhe2() : 0.0;
            obsah.append(String.valueOf(element.getZnacka()) + " " + element.getNazev() + "\t" + element.getKs() + " ks " + "\t" + numberFormat.format(element.getCenaKusPoSleve()) + " /ks ");
            if (phe > 0.0 || phe2 > 0.0) {
                obsah.append("Cena v\u010detn\u011b PHE " + numberFormat.format(phe + phe2) + " /ks\n");
            } else {
                obsah.append("\n");
            }
            celkovaCenaElementu = element.getCenaKusPoSleve() * (double)element.getKs().intValue();
            celkovaCena = (float)((double)celkovaCena + celkovaCenaElementu);
        }
        obsah.append("\nDoprava (" + obj.getDopravaNazev() + "): " + numberFormat.format(obj.getDopravne()) + "\n");
        if (obj.getOdvoz().booleanValue()) {
            obsah.append("Odvoz star\u00e9ho spot\u0159ebi\u010de: 299 K\u010d\n");
            cenaOdvoz = 299.0f;
        }
        celkovaCena = (float)((double)celkovaCena + obj.getDopravne());
        obsah.append("Celkov\u00e1 cena:\t\t" + numberFormat.format(celkovaCena += cenaOdvoz) + "\n");
        obsah.append("Uveden\u00e9 ceny jsou v\u010detn\u011b DPH.\n");
        obsah.append("\n\n");
        obsah.append("\n\nZa " + obchod + "\t\tDost\u00e1l Ji\u0159\u00ed, majitel firmy");
        obsah.append("\n");
        obsah.append("\n");
        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(reklamSoubor), "windows-1250"));
        obsah.append(ObjednavkaService.readerToString(br));
        mesg.setText(obsah.toString(), "windows-1250");
        if (obj.getDorucovaciEmail() != null && obj.getDorucovaciEmail().trim().length() > 0 && !obj.getEmail().equalsIgnoreCase(obj.getDorucovaciEmail())) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getDorucovaciEmail()));
        }
        Transport.send((Message)mesg);
    }

    public void odesliMailWald(Objednavka obj, String mailServer, String mailFrom, String mailTo, String obchod) throws MessagingException, IOException {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(0);
        Properties props = new Properties();
        props.put("mail.smtp.host", mailServer);
        Session mailsession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage mesg = new MimeMessage(mailsession);
        StringBuffer obsah = new StringBuffer("");
        mesg.setFrom((Address)new InternetAddress(mailFrom));
        StringTokenizer st = new StringTokenizer(mailTo, ",");
        while (st.hasMoreTokens()) {
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(st.nextToken()));
        }
        mesg.setSubject("Objednavka " + obj.getCislo());
        obsah = new StringBuffer("");
        obsah.append("Dodac\u00ed list, (tento doklad slou\u017e\u00ed i pro p\u0159\u00edpad reklamace)\n");
        obsah.append("---------------------------------------------------------\n\n");
        obsah.append(String.valueOf(obchod.toUpperCase()) + " / P\u0159ijet\u00ed obj. dne: " + DateFormat.getDateInstance(2, new Locale("cs")).format(new Date()) + " \u010d. obj.: " + obj.getCislo() + "\n\n");
        obsah.append("Bylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed bez DPH:\n");
        obsah.append("-----------------------------------------\n");
        obsah.append(this.nakupTextObchodnik(obj));
        obsah.append("\n\n");
        obsah.append(this.osobniUdajeText(obj));
        obsah.append("\nZbo\u017e\u00ed z\u016fst\u00e1v\u00e1 majetkem dodavatele do \u00fapln\u00e9ho uhrazen\u00ed faktury ( \u00a7445 Obchodn\u00edho z\u00e1kon\u00edku).\n");
        mesg.setText(obsah.toString(), "windows-1250");
        Transport.send((Message)mesg);
        try {
            mesg = new MimeMessage(mailsession);
            mesg.setFrom((Address)new InternetAddress(mailFrom));
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getEmail()));
            mesg.setSubject(MimeUtility.encodeText((String)(String.valueOf(obchod.toUpperCase()) + " - ozn\u00e1men\u00ed o p\u0159ijet\u00ed objedn\u00e1vky"), (String)"windows-1250", null));
            obsah = new StringBuffer("");
            obsah.append(String.valueOf(obchod.toUpperCase()) + ", tel.:386 354 663, Dom\u00e1c\u00ed pot\u0159eby U Haj\u00ed\u010dk\u016f, ul. U \u010cern\u00e9 v\u011b\u017ee 13, \u010cesk\u00e9 Bud\u011bjovice\n");
            obsah.append("----------------------------------------------------------------------------------------------------\n\n");
            obsah.append("V\u00e1\u017een\u00e1 pan\u00ed, pane " + this.zobraz(obj.getPrijmeni()) + ",\n");
            obsah.append("D\u011bkujeme za V\u00e1\u0161 n\u00e1kup, Va\u0161e osobn\u00ed \u00fadaje:\n\n");
            obsah.append(this.osobniUdajeText(obj));
            obsah.append("\n\u010c\u00edslo objedn\u00e1vky: " + obj.getCislo());
            obsah.append("\nBylo objedn\u00e1no n\u00e1sleduj\u00edc\u00ed zbo\u017e\u00ed:\n");
            obsah.append("-----------------------------------------------------------------------------\n");
            obsah.append(this.nakupText(obj));
            obsah.append("\n\nV p\u0159\u00edpad\u011b platby p\u0159evodem na \u00fa\u010det vypl\u0148te jako \u00fa\u010det p\u0159\u00edjemce 6049380267/0100 Komer\u010dn\u00ed banka. Jako variabilni symbol uve\u010fte \u010d\u00edslo objedn\u00e1vky: " + obj.getCislo());
            obsah.append("\n\nUveden\u00e9 ceny jsou v\u010detn\u011b DPH.\n");
            obsah.append("\n\nD\u011bkujeme za d\u016fv\u011bru.");
            obsah.append("\n\nZa " + obchod + "\t\tWald Anton\u00edn, majitel firmy");
            obsah.append("\n");
            obsah.append("\n");
            mesg.setText(obsah.toString(), "windows-1250");
            if (!obj.getEmail().equalsIgnoreCase(obj.getDorucovaciEmail()) && obj.getDorucovaciEmail() != null && obj.getDorucovaciEmail().length() > 0) {
                mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(obj.getDorucovaciEmail()));
            }
            Transport.send((Message)mesg);
        }
        catch (Exception e) {
            System.out.println("objednavka - chyba odeslani");
            e.printStackTrace();
        }
    }

    public String nakupTextObchodnik(Objednavka obj) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        NumberFormat nfUpr = NumberFormat.getCurrencyInstance(new Locale("cs", "CZ"));
        nfUpr.setMaximumFractionDigits(3);
        StringBuffer vysl = new StringBuffer();
        float celkovaCena = 0.0f;
        int celkovyPocet = 0;
        for (PolozkaObjednavky polozka : obj.getPolozkaObjednavkies()) {
            int pocet = 0;
            try {
                pocet = polozka.getKs();
            }
            catch (Exception e) {
                pocet = 0;
            }
            celkovaCena += polozka.getCenaKus().floatValue() * (float)pocet;
            celkovyPocet += pocet;
            if (pocet <= 0) continue;
            vysl.append(pocet);
            vysl.append(" ks\t");
            vysl.append(polozka.getCodeSklad());
            vysl.append("\t");
            vysl.append(polozka.getZnacka());
            vysl.append(" ");
            vysl.append(polozka.getNazev());
            vysl.append("\t");
            double cenaBezDph = (double)polozka.getCenaKus().floatValue() - (double)polozka.getCenaKus().floatValue() * 0.1666 * 100.0 / 100.0;
            int cenaBezDphInt = (int)(cenaBezDph * 1000.0);
            cenaBezDph = (double)cenaBezDphInt / 1000.0;
            vysl.append(nfUpr.format(cenaBezDph));
            vysl.append('\n');
        }
        vysl.append("-----------------------------------------------------------------------------\n");
        vysl.append("Dopravn\u00e9 s DPH:\t\t\t\t\t\t");
        vysl.append(nf.format(obj.getDopravne()));
        vysl.append('\n');
        vysl.append("Celkem k \u00fahrad\u011b s DPH:\t\t\t\t\t");
        vysl.append(nf.format((double)celkovaCena + obj.getDopravne()));
        vysl.append('\n');
        vysl.append("Celkem po\u010det kus\u016f:\t\t\t\t\t");
        vysl.append(celkovyPocet);
        return vysl.toString();
    }

    private void upravitObjednavkuPredUlozenim(Objednavka objednavka) {
        if (objednavka != null) {
            String psc = objednavka.getPsc();
            if (psc.length() > 5) {
                psc = psc.replaceAll(" ", "");
            }
            if (psc.length() > 5) {
                psc = psc.substring(0, 5);
            }
            objednavka.setPsc(psc);
            String dorucovaciPsc = objednavka.getDorucovaciPsc();
            if (dorucovaciPsc.length() > 5) {
                dorucovaciPsc = dorucovaciPsc.replaceAll(" ", "");
            }
            if (dorucovaciPsc.length() > 5) {
                dorucovaciPsc = dorucovaciPsc.substring(0, 5);
            }
            objednavka.setDorucovaciPsc(dorucovaciPsc);
        }
    }

    public static String readerToString(Reader is) throws IOException {
        int n;
        StringBuffer sb = new StringBuffer();
        char[] b = new char[8192];
        while ((n = is.read(b)) > 0) {
            sb.append(b, 0, n);
        }
        return sb.toString();
    }
}

