/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.www;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class StrankaNalezenych {
    private String dotaz;
    private String dotazPocet;
    private int naStranku;
    private int stranka;
    private List seznam;
    private int pocet;
    private int celkemNalezenych;
    private Session hsess;
    private boolean nativeSQL;
    private Class classNative;
    private Double maxCena;
    private Double minCena;

    public StrankaNalezenych(Session hsess, String dotaz, String dotazPocet, int naStranku, int stranka, boolean nativeSQL, Class classNative) throws HibernateException {
        this.dotaz = dotaz;
        this.stranka = stranka;
        this.hsess = hsess;
        this.dotazPocet = dotazPocet;
        if (stranka < 1) {
            this.stranka = 1;
        }
        this.naStranku = naStranku;
        if (naStranku < 1) {
            this.naStranku = 1;
        }
        this.seznam = new ArrayList();
        this.pocet = 0;
        this.nativeSQL = nativeSQL;
        this.classNative = classNative;
        this.najdi();
    }

    public StrankaNalezenych(List seznam, List pocetList) {
        this.seznam = seznam;
        this.celkemNalezenych = 0;
        if (pocetList.size() > 0) {
            this.celkemNalezenych = !this.nativeSQL ? ((Long)pocetList.get(0)).intValue() : ((BigInteger)pocetList.get(0)).intValue();
        }
        this.pocet = seznam.size();
    }

    private void najdi() throws HibernateException {
        Object q = null;
        q = !this.nativeSQL ? this.hsess.createQuery(this.dotaz) : this.hsess.createSQLQuery(this.dotaz).addEntity(this.classNative);
        q.setFirstResult((this.stranka - 1) * this.naStranku);
        q.setMaxResults(this.naStranku);
        this.seznam = q.list();
        Object qPocet = null;
        qPocet = !this.nativeSQL ? this.hsess.createQuery(this.dotazPocet) : this.hsess.createSQLQuery(this.dotazPocet);
        List pocetList = qPocet.list();
        this.celkemNalezenych = 0;
        if (pocetList.size() > 0) {
            this.celkemNalezenych = !this.nativeSQL ? ((Long)pocetList.get(0)).intValue() : ((BigInteger)pocetList.get(0)).intValue();
        }
        this.pocet = this.seznam.size();
    }

    public int getPocet() {
        return this.pocet;
    }

    public int getStranka() {
        return this.stranka;
    }

    public String toString() {
        return this.seznam.toString();
    }

    public int getCelkemNalezenych() {
        return this.celkemNalezenych;
    }

    public List getSeznam() {
        return this.seznam;
    }

    public int getNaStranku() {
        return this.naStranku;
    }

    public int getPocetStranek() {
        int vysledek = this.celkemNalezenych / this.naStranku;
        if (this.celkemNalezenych % this.naStranku != 0) {
            ++vysledek;
        }
        return vysledek;
    }

    public int getMinNalezenec() {
        int vysledek = this.stranka * this.naStranku - this.naStranku + 1;
        return vysledek;
    }

    public int getMaxNalezenec() {
        int vysledek = this.stranka * this.naStranku;
        if (vysledek > this.celkemNalezenych) {
            vysledek = this.celkemNalezenych;
        }
        return vysledek;
    }

    public Double getMinCena() {
        return this.minCena;
    }

    public void setMinCena(Double minCena) {
        this.minCena = minCena;
    }

    public Double getMaxCena() {
        return this.maxCena;
    }

    public void setMaxCena(Double maxCena) {
        this.maxCena = maxCena;
    }
}

