/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.www;

import cz.rtnext.eshop.data.Vyrobek;
import cz.rtnext.eshop.www.Nalezenec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.Session;

public class StrankaNalezenychHledani {
    private String indexDir;
    private String dotaz;
    private int naStranku;
    private int stranka;
    private ArrayList seznam;
    private int pocet;
    private int celkemNalezenych;

    public StrankaNalezenychHledani(String indexDir, String dotaz, int naStranku, int stranka, String idObchod, Session hsess) throws IOException, ParseException {
        this.indexDir = indexDir;
        this.dotaz = dotaz;
        this.stranka = stranka;
        if (stranka < 1) {
            this.stranka = 1;
        }
        this.naStranku = naStranku;
        if (naStranku < 1) {
            this.naStranku = 1;
        }
        this.seznam = new ArrayList();
        this.pocet = 0;
        this.najdi(hsess, idObchod);
    }

    private void najdi(Session hsess, String idObchod) throws IOException, ParseException {
        int MAX_POCET = 60;
        IndexSearcher is = new IndexSearcher(this.indexDir);
        String q = this.dotaz.replaceAll("-", "\\\\-");
        StringTokenizer st = new StringTokenizer(q);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String element = st.nextToken();
            try {
                Float.parseFloat(element);
                sb.append(element);
                if (!st.hasMoreTokens()) continue;
                sb.append(" ");
            }
            catch (Exception exception) {
                sb.append(String.valueOf(element) + "*");
                if (!st.hasMoreTokens()) continue;
                sb.append(" ");
            }
        }
        q = sb.toString();
        q = q.trim();
        HashMap<String, Integer> boosts = new HashMap<String, Integer>();
        boosts.put("nazev", 10);
        boosts.put("nazevKategorie", 10);
        boosts.put("nazevUpraveny", 10);
        String[] fields = new String[]{"nazev", "nazevUpraveny", "nazevKategorie", "popis", "popis2", "ostatniInformace", "znacka", "codeSklad"};
        MultiFieldQueryParser qp = new MultiFieldQueryParser(fields, (Analyzer)new CzechAnalyzer());
        qp.setAllowLeadingWildcard(true);
        qp.setDefaultOperator(QueryParser.AND_OPERATOR);
        Query query = qp.parse(q);
        TopDocs hits = is.search(query, null, MAX_POCET);
        StringBuffer idecka = new StringBuffer();
        int k = 0;
        int i = (this.stranka - 1) * this.naStranku;
        while (i < hits.totalHits && i < MAX_POCET && i < this.stranka * this.naStranku) {
            Document doc = is.doc(hits.scoreDocs[i].doc);
            if (k > 0) {
                idecka.append(',');
            }
            idecka.append('\'');
            idecka.append(doc.get("idVyrobku"));
            idecka.append('\'');
            ++this.pocet;
            ++k;
            ++i;
        }
        if (this.pocet > 0) {
            List vyrobky = hsess.createQuery("from Vyrobek vyrobek where vyrobek.id in (" + idecka.toString() + ")").list();
            HashMap<String, Vyrobek> vyrobkyMap = new HashMap<String, Vyrobek>(vyrobky.size());
            for (Vyrobek vyrobek : vyrobky) {
                vyrobkyMap.put(vyrobek.getId(), vyrobek);
            }
            int i2 = (this.stranka - 1) * this.naStranku;
            while (i2 < hits.totalHits && i2 < MAX_POCET && i2 < this.stranka * this.naStranku) {
                Document doc = is.doc(hits.scoreDocs[i2].doc);
                Vyrobek vyrobek = (Vyrobek)vyrobkyMap.get(doc.get("idVyrobku"));
                if (vyrobek != null) {
                    this.seznam.add(new Nalezenec(vyrobek, idObchod));
                }
                ++i2;
            }
        }
        this.celkemNalezenych = hits.totalHits < 60 ? hits.totalHits : 60;
        is.close();
    }

    public int getPocet() {
        return this.pocet;
    }

    public int getStranka() {
        return this.stranka;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Nalezenec element : this.seznam) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getCelkemNalezenych() {
        return this.celkemNalezenych;
    }

    public ArrayList getSeznam() {
        return this.seznam;
    }

    public int getNaStranku() {
        return this.naStranku;
    }

    public int getPocetStranek() {
        int vysledek = this.celkemNalezenych / this.naStranku;
        if (this.celkemNalezenych % this.naStranku != 0) {
            ++vysledek;
        }
        return vysledek;
    }

    public int getMinNalezenec() {
        int vysledek = this.stranka * this.naStranku - this.naStranku + 1;
        return vysledek;
    }

    public int getMaxNalezenec() {
        int vysledek = this.stranka * this.naStranku;
        if (vysledek > this.celkemNalezenych) {
            vysledek = this.celkemNalezenych;
        }
        return vysledek;
    }
}

