/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.eshop.www;

import cz.rtnext.eshop.data.Oblibeny;
import cz.rtnext.eshop.data.Uzivatel;
import cz.rtnext.eshop.form.PrihlaseniForm;
import cz.rtnext.eshop.form.RegistraceForm;
import cz.rtnext.eshop.form.ZaslaniHeslaForm;
import cz.rtnext.eshop.www.EmailService;
import cz.rtnext.eshop.www.Kosik;
import cz.rtnext.util.ConvertService;
import cz.rtnext.util.HibernateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class UzivatelService {
    public Map prihlasit(PrihlaseniForm form, Kosik kosik, ActionMapping mapping, HttpServletRequest request, MessageResources res, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        ActionErrors errors = form.validate(mapping, request);
        if (errors != null && !errors.isEmpty()) {
            vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors, res));
            vysledek.put("adminVyrobekForm", (Object)form);
            vysledek.put("kosik", kosik);
            return vysledek;
        }
        Iterator iterate = hsess.createQuery("from Uzivatel uzivatel where uzivatel.uzivatel=? and uzivatel.heslo=?").setString(0, form.getJmeno()).setString(1, form.getHeslo()).iterate();
        if (!iterate.hasNext()) {
            vysledek.put("chyba", res.getMessage("validace.prihlaseni.nezdar"));
            vysledek.put("kosik", kosik);
            return vysledek;
        }
        if (kosik == null) {
            kosik = new Kosik();
        }
        Uzivatel uzivatel = (Uzivatel)iterate.next();
        kosik.setUzivatelId(uzivatel.getId());
        kosik.setUzivatelJmeno(String.valueOf(uzivatel.getJmeno()) + " " + uzivatel.getPrijmeni());
        kosik.getOblibene().clear();
        for (Oblibeny oblibeny : uzivatel.getOblibene()) {
            kosik.getOblibene().put(oblibeny.getVyrobek().getId(), oblibeny.getVyrobek().getId());
        }
        vysledek.put("kosik", kosik);
        return vysledek;
    }

    public Map odhlasit(Kosik kosik) {
        HashMap<String, Kosik> vysledek = new HashMap<String, Kosik>();
        if (kosik == null) {
            kosik = new Kosik();
        } else {
            kosik.setUzivatelId(null);
            kosik.setUzivatelJmeno(null);
        }
        vysledek.put("kosik", kosik);
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages, MessageResources res) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    private List validacniChyby(ActionMessages messages, MessageResources res) {
        ArrayList<String> vysledek = new ArrayList<String>();
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            while (iter.hasNext()) {
                ActionMessage message = (ActionMessage)iter.next();
                vysledek.add(res.getMessage(message.getKey(), message.getValues()));
            }
        }
        return vysledek;
    }

    public Map upravUdaje(Integer id, RegistraceForm form, Kosik kosik, ActionMapping mapping, HttpServletRequest request, Session hsess, MessageResources res, boolean kontrolovatIc) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (kontrolovatIc) {
                Iterator iterate;
                boolean stejneIc = false;
                if (form != null && form.getIc() != null && form.getIc().length() > 0 && (iterate = hsess.createQuery("from Uzivatel uzivatel where uzivatel.ic=? and uzivatel.id<>?").setString(0, form.getIc()).setInteger(1, id.intValue()).iterate()).hasNext()) {
                    stejneIc = true;
                }
                if (stejneIc) {
                    errors.add("uzivatel", new ActionMessage("validace.registrace.ic_existuje"));
                }
            }
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors, res));
                vysledek.put("validacni_chyby", this.validacniChyby((ActionMessages)errors, res));
                form.setCaptcha("");
                vysledek.put("registraceFormUprava", (Object)form);
                return vysledek;
            }
            errors = new ActionMessages();
            Uzivatel polozka = (Uzivatel)hsess.load(Uzivatel.class, (Serializable)id);
            String uzivJmeno = polozka.getUzivatel();
            String heslo = polozka.getHeslo();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            polozka.setT(new Date());
            polozka.setUzivatel(uzivJmeno);
            if (polozka.getHeslo() == null || polozka.getHeslo().length() == 0) {
                polozka.setHeslo(heslo);
            }
            if (form.getZasilani() == null || form.getZasilani().length() == 0) {
                polozka.setZasilani(Boolean.FALSE);
            }
            form.setCaptcha("");
            form.setUzivatel(polozka.getUzivatel());
            vysledek.put("dopravne", polozka.getDopravne());
            vysledek.put("registraceFormUprava", (Object)form);
            hsess.flush();
            kosik.setUzivatelJmeno(String.valueOf(polozka.getJmeno()) + " " + polozka.getPrijmeni());
            vysledek.put("oznameni", res.getMessage("validace.registrace.uprava"));
        }
        catch (HibernateException e) {
            vysledek.put("chyba", res.getMessage("validace.registrace.nezdar_update", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", res.getMessage("validace.registrace.nezdar_update", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map nactiUdaje(Integer id, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Uzivatel polozka = (Uzivatel)hsess.get(Uzivatel.class, (Serializable)id);
            RegistraceForm form = new RegistraceForm();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
            ConvertService.odregistrujCeske();
            form.setHeslo("");
            form.setPotvrzeniHesla("");
            vysledek.put("registraceFormUprava", (Object)form);
            vysledek.put("dopravne", polozka.getDopravne());
        }
        catch (Exception e) {
            vysledek.put("chyba", e.getMessage());
        }
        return vysledek;
    }

    public Map noveUdaje(Kosik kosik) {
        HashMap<String, RegistraceForm> vysledek = new HashMap<String, RegistraceForm>();
        RegistraceForm form = new RegistraceForm();
        vysledek.put("registraceForm", form);
        if (kosik != null) {
            kosik.setUzivatelId(null);
            kosik.setUzivatelJmeno(null);
        }
        return vysledek;
    }

    public Map zapisUdaje(RegistraceForm form, Kosik kosik, ActionMapping mapping, HttpServletRequest request, Session hsess, MessageResources res, boolean kontrolovatIc) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Iterator iterate;
            boolean stejnyUzivatelError = false;
            if (form != null && form.getUzivatel() != null && form.getUzivatel().length() > 0 && (iterate = hsess.createQuery("from Uzivatel uzivatel where uzivatel.uzivatel=?").setString(0, form.getUzivatel()).iterate()).hasNext()) {
                stejnyUzivatelError = true;
            }
            ActionErrors errors = form.validate(mapping, request);
            if (stejnyUzivatelError) {
                errors.add("uzivatel", new ActionMessage("validace.registrace.uzivatel_existuje"));
            }
            if (kontrolovatIc) {
                Iterator iterate2;
                boolean stejneIc = false;
                if (form != null && form.getIc() != null && form.getIc().length() > 0 && (iterate2 = hsess.createQuery("from Uzivatel uzivatel where uzivatel.ic=?").setString(0, form.getIc()).iterate()).hasNext()) {
                    stejneIc = true;
                }
                if (stejneIc) {
                    errors.add("uzivatel", new ActionMessage("validace.registrace.ic_existuje"));
                }
            }
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors, res));
                vysledek.put("validacni_chyby", this.validacniChyby((ActionMessages)errors, res));
                form.setCaptcha("");
                vysledek.put("registraceForm", (Object)form);
                return vysledek;
            }
            errors = new ActionMessages();
            Uzivatel polozka = new Uzivatel();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            polozka.setT(new Date());
            hsess.save((Object)polozka);
            hsess.flush();
            if (kosik == null) {
                kosik = new Kosik();
            }
            kosik.setUzivatelId(polozka.getId());
            kosik.setUzivatelJmeno(String.valueOf(polozka.getJmeno()) + " " + polozka.getPrijmeni());
            vysledek.put("kosik", kosik);
            vysledek.put("registraceForm", (Object)form);
            kosik.setUzivatelJmeno(String.valueOf(polozka.getJmeno()) + " " + polozka.getPrijmeni());
        }
        catch (HibernateException e) {
            vysledek.put("chyba", res.getMessage("validace.registrace.nezdar_update", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", res.getMessage("validace.registrace.nezdar_update", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map poslatHeslo(ZaslaniHeslaForm form, ActionMapping mapping, HttpServletRequest request, MessageResources res, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        ActionErrors errors = form.validate(mapping, request);
        if (errors != null && !errors.isEmpty()) {
            vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors, res));
            vysledek.put("adminVyrobekForm", (Object)form);
            return vysledek;
        }
        Iterator iterate = hsess.createQuery("from Uzivatel uzivatel where uzivatel.uzivatel=? or uzivatel.email=?").setString(0, form.getJmeno()).setString(1, form.getEmail()).iterate();
        if (!iterate.hasNext()) {
            vysledek.put("chyba", res.getMessage("validace.heslo.nezdar"));
            return vysledek;
        }
        Uzivatel uzivatel = (Uzivatel)iterate.next();
        EmailService es = new EmailService();
        try {
            es.odesliMailHeslo(uzivatel, res.getMessage("mail.host"), res.getMessage("mail.from"), res.getMessage("mail.1"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vysledek;
    }
}

