/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.util;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class CeskyDoubleConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;
    private NumberFormat nf = NumberFormat.getNumberInstance(new Locale("cs", "CZ"));

    public CeskyDoubleConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public CeskyDoubleConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        try {
            return new Double(this.nf.parse(value.toString()).doubleValue());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException((Throwable)e);
        }
    }
}

