/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.util;

import cz.rtnext.util.HibernateUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;

public class HibernateSessionRequestFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        try {
            sf.getCurrentSession().beginTransaction();
            chain.doFilter(request, response);
            if (sf.getCurrentSession().getTransaction().isActive()) {
                sf.getCurrentSession().getTransaction().commit();
            }
        }
        catch (StaleObjectStateException staleEx) {
            throw staleEx;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            try {
                if (sf.getCurrentSession().getTransaction().isActive()) {
                    sf.getCurrentSession().getTransaction().rollback();
                }
            }
            catch (Throwable rbEx) {
                rbEx.printStackTrace();
            }
            throw new ServletException(ex);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

