/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.util;

import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class HibernateUtil {
    private static Configuration configuration;
    private static SessionFactory sessionFactory;

    static {
        try {
            configuration = new Configuration();
            configuration.configure();
            configuration.addResource("cz/rtnext/eshop/data/Akce.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/AkcniCena.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/TypVlastnosti.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Objednavka.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/DopravaPlatba.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Uzivatel.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Platba.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/PolozkaObjednavky.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Kategorie.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Doprava.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Parametr.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Informace.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Vyrobek.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Vlastnost.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Obchod.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Phe.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/VyrobekObrazek.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Clanek.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Informace3.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Oblibeny.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Mena.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Kupon.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/UzivatelAdministrace.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/Zbozi.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/ZboziKategorie.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/AkcniZona.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/AkcniZonaVyrobek.hbm.xml");
            configuration.addResource("cz/rtnext/eshop/data/VyrobekNavstevnost.hbm.xml");
            HibernateUtil.rebuildSessionFactory(configuration);
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static SessionFactory getSessionFactory() {
        String sfName = configuration.getProperty("hibernate.session_factory_name");
        if (sfName != null) {
            try {
                return (SessionFactory)new InitialContext().lookup(sfName);
            }
            catch (NamingException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (sessionFactory == null) {
            HibernateUtil.rebuildSessionFactory();
        }
        return sessionFactory;
    }

    public static void shutdown() {
        HibernateUtil.getSessionFactory().close();
        sessionFactory = null;
    }

    public static void rebuildSessionFactory() {
        HibernateUtil.rebuildSessionFactory(configuration);
    }

    public static void rebuildSessionFactory(Configuration cfg) {
        if (sessionFactory != null && !sessionFactory.isClosed()) {
            sessionFactory.close();
        }
        if (cfg.getProperty("hibernate.session_factory_name") != null) {
            cfg.buildSessionFactory();
        } else {
            sessionFactory = cfg.buildSessionFactory();
        }
        configuration = cfg;
    }

    public static void rollbackTransaction() {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        if (sf.getCurrentSession().getTransaction().isActive()) {
            sf.getCurrentSession().getTransaction().rollback();
            sf.getCurrentSession().beginTransaction();
        }
    }

    public static void orezStringy(Object o) {
        PersistentClass persistentClass = HibernateUtil.getConfiguration().getClassMapping(o.getClass().getName());
        Iterator iterator = persistentClass.getPropertyIterator();
        while (iterator.hasNext()) {
            try {
                Property property = (Property)iterator.next();
                if (property.getType().getReturnedClass() != String.class || property.getColumnSpan() != 1) continue;
                Iterator iterator2 = property.getColumnIterator();
                while (iterator2.hasNext()) {
                    Column column = (Column)iterator2.next();
                    String hodnota = BeanUtils.getProperty((Object)o, (String)property.getName());
                    if (hodnota == null || column.getLength() <= 0 || hodnota.length() <= column.getLength()) continue;
                    BeanUtils.setProperty((Object)o, (String)property.getName(), (Object)hodnota.substring(0, column.getLength()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

