/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSClipEvent
extends FSTransformObject {
    public static final int Load = 1;
    public static final int EnterFrame = 2;
    public static final int Unload = 4;
    public static final int MouseMove = 8;
    public static final int MouseDown = 16;
    public static final int MouseUp = 32;
    public static final int KeyDown = 64;
    public static final int KeyUp = 128;
    public static final int Data = 256;
    public static final int Initialize = 512;
    public static final int Press = 1024;
    public static final int Release = 2048;
    public static final int ReleaseOut = 4096;
    public static final int RollOver = 8192;
    public static final int RollOut = 16384;
    public static final int DragOver = 32768;
    public static final int DragOut = 65536;
    public static final int KeyPress = 131072;
    public static final int Construct = 262144;
    private int event = 0;
    private int keyCode = 0;
    private ArrayList actions = null;
    private byte[] encodedActions = null;

    public FSClipEvent(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSClipEvent(int n, ArrayList arrayList) {
        this.setEvent(n);
        this.setActions(arrayList);
    }

    public FSClipEvent(int n, byte[] byArray) {
        this.setEvent(n);
        this.setEncodedActions(byArray);
    }

    public FSClipEvent(int n, int n2, ArrayList arrayList) {
        this.setEvent(n);
        this.setKeyCode(n2);
        this.setActions(arrayList);
    }

    public FSClipEvent(int n, int n2, byte[] byArray) {
        this.setEvent(n);
        this.setKeyCode(n2);
        this.setEncodedActions(byArray);
    }

    public FSClipEvent(FSClipEvent fSClipEvent) {
        this.event = fSClipEvent.event;
        this.keyCode = fSClipEvent.keyCode;
        if (this.actions != null) {
            this.actions = new ArrayList();
            Iterator iterator = fSClipEvent.actions.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            this.encodedActions = Transform.clone(fSClipEvent.encodedActions);
        }
    }

    public void add(FSActionObject fSActionObject) {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        this.actions.add(fSActionObject);
    }

    public void setEvent(int n) {
        this.event = n;
    }

    public int getEvent() {
        return this.event;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int n) {
        this.keyCode = n;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
        this.encodedActions = null;
    }

    public ArrayList getActions() {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        return this.actions;
    }

    public byte[] getEncodedActions() {
        return this.encodedActions;
    }

    public void setEncodedActions(byte[] byArray) {
        this.encodedActions = byArray;
        this.actions = null;
    }

    public Object clone() {
        FSClipEvent fSClipEvent = (FSClipEvent)super.clone();
        if (this.actions != null) {
            fSClipEvent.actions = new ArrayList();
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                fSClipEvent.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            fSClipEvent.encodedActions = Transform.clone(this.encodedActions);
        }
        return fSClipEvent;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSClipEvent fSClipEvent = (FSClipEvent)object;
            bl = this.event == fSClipEvent.event;
            bl = bl && this.keyCode == fSClipEvent.keyCode;
            bl = this.actions != null ? this.actions.equals(fSClipEvent.actions) : Transform.equals(this.encodedActions, fSClipEvent.encodedActions);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "event", this.event);
            Transform.append(stringBuffer, "keyCode", this.keyCode);
            if (this.actions != null) {
                Transform.append(stringBuffer, "actions", this.actions, n);
            } else {
                stringBuffer.append("actions = <data>; ");
            }
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = 4 + (fSCoder.context[2] > 5 ? 4 : 2);
        n += (this.event & 0x20000) != 0 ? 1 : 0;
        if (this.actions != null) {
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                FSActionObject fSActionObject = (FSActionObject)iterator.next();
                n += fSActionObject.length(fSCoder);
                n += fSActionObject.getType() > 128 ? 3 : 1;
            }
        } else {
            n += this.encodedActions.length;
        }
        return ++n;
    }

    public void encode(FSCoder fSCoder) {
        FSActionObject fSActionObject;
        Iterator iterator;
        int n = fSCoder.context[2] > 5 ? 4 : 2;
        int n2 = 1;
        if (this.actions != null) {
            iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                fSActionObject = (FSActionObject)iterator.next();
                n2 += fSActionObject.getLength();
                n2 += fSActionObject.getType() > 128 ? 3 : 1;
            }
        } else {
            n2 += this.encodedActions.length;
        }
        int n3 = (this.event & 0x20000) != 0 ? 1 : 0;
        fSCoder.writeWord(this.event, n);
        fSCoder.writeWord(n2 += n3, 4);
        if ((this.event & 0x20000) != 0) {
            fSCoder.writeWord(this.keyCode, 1);
        }
        if (this.actions != null) {
            iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                fSActionObject = (FSActionObject)iterator.next();
                int n4 = fSCoder.getPointer();
                int n5 = fSActionObject.getLength();
                int n6 = fSCoder.getPointer() + (fSActionObject.getType() > 128 ? 24 : 8);
                int n7 = n6 + (n5 << 3);
                fSActionObject.encode(fSCoder);
                fSCoder.setPointer(n7);
                int n8 = fSCoder.getPointer() - n7 >> 3;
                if (n8 == 0) continue;
                fSCoder.context[14] = 1;
                fSCoder.context[15] = fSActionObject.getType();
                fSCoder.context[16] = n4 >>> 3;
                fSCoder.context[17] = n7 - n4 >>> 3;
                fSCoder.context[13] = n8;
            }
        } else {
            fSCoder.writeBytes(this.encodedActions);
        }
        fSCoder.writeWord(0, 1);
    }

    public void decode(FSCoder fSCoder) {
        int n = fSCoder.context[2] > 5 ? 4 : 2;
        this.event = fSCoder.readWord(n, false);
        int n2 = fSCoder.readWord(4, false);
        if ((this.event & 0x20000) != 0) {
            this.keyCode = fSCoder.readWord(1, false);
            --n2;
        }
        if (fSCoder.context[18] == 1) {
            this.actions = new ArrayList();
            while (n2 > 1) {
                int n3 = fSCoder.getPointer();
                this.actions.add(FSMovie.decodeAction(fSCoder));
                n2 -= fSCoder.getPointer() - n3 >>> 3;
            }
        } else {
            this.encodedActions = new byte[n2 - 1];
            fSCoder.readBytes(this.encodedActions);
        }
        fSCoder.readWord(1, false);
    }
}

