/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSMovieEvent;
import com.flagstone.transform.FSMovieListener;
import java.io.UnsupportedEncodingException;

public class FSCoder {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    private FSMovieListener listener = null;
    String encoding = "UTF8";
    private int byteOrder = 0;
    private byte[] data = null;
    private int ptr = 0;
    private int end = 0;
    public static final int TransparentColors = 0;
    static final int Action = 1;
    public static final int Version = 2;
    static final int Type = 3;
    static final int Empty = 4;
    static final int Identifier = 5;
    static final int NumberOfFillBits = 6;
    static final int NumberOfLineBits = 7;
    static final int NumberOfAdvanceBits = 8;
    static final int NumberOfGlyphBits = 9;
    static final int NumberOfShapeBits = 10;
    static final int ArrayCountExtended = 11;
    static final int WideCodes = 12;
    static final int Delta = 13;
    static final int CodingError = 14;
    static final int TypeInError = 15;
    static final int StartOfError = 16;
    static final int ExpectedLength = 17;
    static final int DecodeActions = 18;
    static final int DecodeShapes = 19;
    static final int DecodeGlyphs = 20;
    int[] context = new int[21];

    static int size(int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MIN_VALUE;
        if (bl) {
            n = n < 0 ? -n : n;
            for (n3 = 32; (n & n4) == 0 && n3 > 0; --n3) {
                n4 >>>= 1;
            }
            n2 = n3 < 32 ? n3 + 1 : n3;
        } else {
            for (n3 = 32; (n & n4) == 0 && n3 > 0; --n3) {
                n4 >>>= 1;
            }
            n2 = n3;
        }
        return n2;
    }

    static int size(int[] nArray, boolean bl) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.max(n, FSCoder.size(nArray[i], bl));
        }
        return n;
    }

    static int fixedShortSize(float f) {
        float f2 = f * 256.0f;
        return FSCoder.size((int)f2, true);
    }

    static int fixedShortSize(float[] fArray) {
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            n = Math.max(n, FSCoder.fixedShortSize(fArray[i]));
        }
        return n;
    }

    static int fixedSize(float f) {
        float f2 = f * 65536.0f;
        return FSCoder.size((int)f2, true);
    }

    static int fixedSize(float[] fArray) {
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            n = Math.max(n, FSCoder.fixedSize(fArray[i]));
        }
        return n;
    }

    static int strlen(String string, String string2, boolean bl) {
        int n = 0;
        if (string != null) {
            try {
                n += string.getBytes(string2).length;
                n += bl ? 1 : 0;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return n;
    }

    static int strlen(String string, boolean bl) {
        int n = 0;
        if (string != null) {
            try {
                n += string.getBytes("UTF8").length;
                n += bl ? 1 : 0;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return n;
    }

    public FSCoder(int n, int n2) {
        this.clearContext();
        this.byteOrder = n;
        this.data = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            this.data[i] = 0;
        }
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public FSCoder(int n, byte[] byArray) {
        this.clearContext();
        this.byteOrder = n;
        this.data = byArray;
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    void setListener(FSMovieListener fSMovieListener) {
        this.listener = fSMovieListener;
    }

    FSMovieListener getListener() {
        return this.listener;
    }

    void beginObject(String string) {
        if (this.listener != null) {
            this.listener.logEvent(new FSMovieEvent(this.context[1], 0, this.ptr, 0, string));
        }
    }

    void endObject(String string) {
        if (this.listener != null) {
            this.listener.logEvent(new FSMovieEvent(this.context[1], 1, this.ptr, 0, string));
        }
    }

    void logValue(Object object, int n, int n2) {
        if (this.listener != null) {
            this.listener.logEvent(new FSMovieEvent(this.context[1], 3, n, n2, object));
        }
    }

    void logError(String string, int n, int n2) {
        if (this.listener != null) {
            this.listener.logEvent(new FSMovieEvent(this.context[1], 2, n, n2, string));
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public byte[] getData() {
        int n = this.ptr + 7 >> 3;
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, 0, byArray, 0, n);
        return byArray;
    }

    public void setData(int n, byte[] byArray) {
        this.byteOrder = n;
        this.data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public void addCapacity(int n) {
        int n2 = (this.end >>> 3) + n;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
        this.end = this.data.length << 3;
    }

    public int getCapacity() {
        return this.end >>> 3;
    }

    public int getPointer() {
        return this.ptr;
    }

    public void setPointer(int n) {
        if (n < 0 || n > this.end) {
            throw new IllegalArgumentException();
        }
        this.ptr = n;
    }

    public void adjustPointer(int n) {
        this.ptr += n;
        if (this.ptr < 0) {
            this.ptr = 0;
        } else if (this.ptr >= this.end) {
            this.ptr = this.end;
        }
    }

    public void alignToByte() {
        this.ptr = this.ptr + 7 & 0xFFFFFFF8;
    }

    public boolean eof() {
        return this.ptr >= this.end;
    }

    public int readBits(int n, boolean bl) {
        int n2 = 0;
        if (n < 0 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        if (n == 0) {
            return 0;
        }
        int n3 = this.ptr >> 3;
        int n4 = this.data.length - n3 > 4 ? 0 : (4 - (this.data.length - n3)) * 8;
        int n5 = 32;
        while (n5 > n4) {
            n2 |= (this.data[n3] & 0xFF) << n5 - 8;
            n5 -= 8;
            ++n3;
        }
        n2 <<= this.ptr % 8;
        n2 = bl ? (n2 >>= 32 - n) : (n2 >>>= 32 - n);
        this.ptr += n;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
        return n2;
    }

    public void writeBits(int n, int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        if (this.ptr + 32 > this.end) {
            this.addCapacity(this.data.length / 2 + 4);
        }
        int n3 = this.ptr >> 3;
        n <<= 32 - n2;
        n >>>= this.ptr % 8;
        n |= this.data[n3] << 24;
        int n4 = 24;
        while (n4 >= 0) {
            this.data[n3] = (byte)(n >>> n4);
            n4 -= 8;
            ++n3;
        }
        this.ptr += n2;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
    }

    public int readWord(int n, boolean bl) {
        int n2 = 0;
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        int n3 = this.ptr >> 3;
        if (n3 + n > this.data.length) {
            n = this.data.length - n3;
        }
        int n4 = n * 8;
        if (this.byteOrder == 0) {
            int n5 = 0;
            while (n5 < n4) {
                n2 += (this.data[n3] & 0xFF) << n5;
                n5 += 8;
                this.ptr += 8;
                ++n3;
            }
        } else {
            int n6 = 0;
            while (n6 < n4) {
                n2 <<= 8;
                n2 += this.data[n3] & 0xFF;
                n6 += 8;
                this.ptr += 8;
                ++n3;
            }
        }
        if (bl) {
            n2 <<= 32 - n4;
            n2 >>= 32 - n4;
        }
        return n2;
    }

    public void writeWord(int n, int n2) {
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        int n3 = n2 * 8;
        if (this.ptr + n3 > this.end) {
            this.addCapacity(this.data.length / 2 + n2);
        }
        if (this.byteOrder == 0) {
            int n4 = this.ptr >>> 3;
            int n5 = 0;
            while (n5 < n3) {
                this.data[n4] = (byte)n;
                n5 += 8;
                this.ptr += 8;
                n >>>= 8;
                ++n4;
            }
        } else {
            int n6 = this.ptr + n3 - 8 >>> 3;
            int n7 = 0;
            while (n7 < n3) {
                this.data[n6] = (byte)n;
                n7 += 8;
                this.ptr += 8;
                n >>>= 8;
                --n6;
            }
        }
    }

    public int readBytes(byte[] byArray) {
        int n = 0;
        if (byArray == null || byArray.length == 0) {
            return n;
        }
        int n2 = this.ptr >>> 3;
        int n3 = byArray.length;
        if (n2 + n3 > this.data.length) {
            n3 = this.data.length - n2;
        }
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = this.data[n2];
            ++n4;
            this.ptr += 8;
            ++n2;
            ++n;
        }
        return n;
    }

    public int writeBytes(byte[] byArray) {
        int n = 0;
        if (this.ptr + (byArray.length << 3) > this.end) {
            this.addCapacity(this.data.length / 2 + byArray.length);
        }
        if (byArray == null || byArray.length == 0) {
            return n;
        }
        int n2 = this.ptr >>> 3;
        int n3 = byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            this.data[n2] = byArray[n4];
            ++n4;
            this.ptr += 8;
            ++n2;
            ++n;
        }
        return n;
    }

    public int scanBits(int n, boolean bl) {
        int n2 = this.ptr;
        int n3 = this.readBits(n, bl);
        this.ptr = n2;
        return n3;
    }

    public int scanWord(int n, boolean bl) {
        int n2 = this.ptr;
        int n3 = this.readWord(n, bl);
        this.ptr = n2;
        return n3;
    }

    public float readFixedBits(int n, int n2) {
        float f = 1 << n2;
        float f2 = (float)this.readBits(n, true) / f;
        return f2;
    }

    public void writeFixedBits(float f, int n, int n2) {
        float f2 = 1 << n2;
        this.writeBits((int)(f * f2), n);
    }

    public float readFixedWord(int n, int n2) {
        float f = 1 << n2 * 8;
        int n3 = this.readWord(n2, false);
        int n4 = this.readWord(n, true) << n2 * 8;
        return (float)(n4 + n3) / f;
    }

    public void writeFixedWord(float f, int n, int n2) {
        float f2 = 1 << n2 * 8;
        int n3 = (int)(f * f2);
        int n4 = (int)f;
        this.writeWord(n3, n2);
        this.writeWord(n4, n);
    }

    public double readDouble() {
        int n = this.readWord(4, false);
        int n2 = this.readWord(4, false);
        long l = (long)n << 32;
        return Double.longBitsToDouble(l |= (long)n2 & 0xFFFFFFFFL);
    }

    public void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        int n = (int)l;
        int n2 = (int)(l >>> 32);
        this.writeWord(n2, 4);
        this.writeWord(n, 4);
    }

    public String readString(int n) {
        return this.readString(n, this.encoding);
    }

    public String readString(int n, String string) {
        if (n == 0) {
            return "";
        }
        String string2 = null;
        byte[] byArray = new byte[n];
        int n2 = this.readBytes(byArray);
        try {
            string2 = new String(byArray, 0, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "";
        }
        return string2;
    }

    public String readString() {
        return this.readString(this.encoding);
    }

    public String readString(String string) {
        String string2 = null;
        int n = this.ptr >> 3;
        int n2 = 0;
        while (n < this.data.length && this.data[n++] != 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.readBytes(byArray);
        try {
            string2 = new String(byArray, 0, n3, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "";
        }
        this.readWord(1, false);
        ++n3;
        return string2;
    }

    public int writeString(String string) {
        return this.writeString(string, this.encoding);
    }

    public int writeString(String string, String string2) {
        int n = 0;
        try {
            n = this.writeBytes(string.getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return n;
    }

    public boolean findBits(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = this.ptr;
        while (this.ptr < this.end) {
            if (this.scanBits(n2, false) == n) {
                bl = true;
                break;
            }
            this.ptr += n3;
        }
        if (!bl) {
            this.ptr = n4;
        }
        return bl;
    }

    public boolean findWord(int n, int n2, int n3) {
        boolean bl = false;
        while (this.ptr < this.end) {
            if (this.scanWord(n2, false) == n) {
                bl = true;
                break;
            }
            this.ptr += n3;
        }
        return bl;
    }

    private void clearContext() {
        for (int i = 0; i < this.context.length; ++i) {
            this.context[i] = 0;
        }
    }

    public int getContext(int n) {
        return this.context[n];
    }

    public void setContext(int n, int n2) {
        this.context[n] = n2;
    }
}

