/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.Transform;

public class FSDefineImage2
extends FSDefineObject {
    private int width = 0;
    private int height = 0;
    private int pixelSize = 8;
    private int tableSize = 0;
    private byte[] compressedData = null;

    public FSDefineImage2(FSCoder fSCoder) {
        super(36, 0);
        this.extendLength = true;
        this.decode(fSCoder);
    }

    public FSDefineImage2(int n, int n2, int n3, int n4, byte[] byArray) {
        super(36, n);
        this.extendLength = true;
        this.setWidth(n2);
        this.setHeight(n3);
        this.setPixelSize(8);
        this.setTableSize(n4);
        this.setCompressedData(byArray);
    }

    public FSDefineImage2(int n, int n2, int n3, byte[] byArray) {
        super(36, n);
        this.extendLength = true;
        this.setWidth(n2);
        this.setHeight(n3);
        this.setPixelSize(32);
        this.setTableSize(0);
        this.setCompressedData(byArray);
    }

    public FSDefineImage2(FSDefineImage2 fSDefineImage2) {
        super(fSDefineImage2);
        this.width = fSDefineImage2.width;
        this.height = fSDefineImage2.height;
        this.pixelSize = fSDefineImage2.pixelSize;
        this.tableSize = fSDefineImage2.tableSize;
        this.compressedData = Transform.clone(fSDefineImage2.compressedData);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public byte[] getCompressedData() {
        return this.compressedData;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setPixelSize(int n) {
        this.pixelSize = n;
    }

    public void setTableSize(int n) {
        this.tableSize = n;
    }

    public void setCompressedData(byte[] byArray) {
        this.compressedData = byArray;
    }

    public Object clone() {
        FSDefineImage2 fSDefineImage2 = (FSDefineImage2)super.clone();
        fSDefineImage2.compressedData = Transform.clone(this.compressedData);
        return fSDefineImage2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineImage2 fSDefineImage2 = (FSDefineImage2)object;
            bl = this.pixelSize == fSDefineImage2.pixelSize;
            bl = bl && this.width == fSDefineImage2.width;
            bl = bl && this.height == fSDefineImage2.height;
            bl = bl && this.tableSize == fSDefineImage2.tableSize;
            bl = bl && Transform.equals(this.compressedData, fSDefineImage2.compressedData);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "pixelSize", this.pixelSize);
            Transform.append(stringBuffer, "width", this.width);
            Transform.append(stringBuffer, "height", this.height);
            Transform.append(stringBuffer, "tableSize", this.tableSize);
            Transform.append(stringBuffer, "compressedData", "<data>");
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 5;
        this.length += this.pixelSize == 8 ? 1 : 0;
        this.length += this.compressedData.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.beginObject(this.name());
        super.encode(fSCoder);
        switch (this.pixelSize) {
            case 8: {
                fSCoder.writeWord(3, 1);
                break;
            }
            case 32: {
                fSCoder.writeWord(5, 1);
            }
        }
        fSCoder.writeWord(this.width, 2);
        fSCoder.writeWord(this.height, 2);
        if (this.pixelSize == 8) {
            fSCoder.writeWord(this.tableSize - 1, 1);
        }
        fSCoder.writeBytes(this.compressedData);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        switch (fSCoder.readWord(1, false)) {
            case 3: {
                this.pixelSize = 8;
                break;
            }
            case 5: {
                this.pixelSize = 32;
            }
        }
        this.width = fSCoder.readWord(2, false);
        this.height = fSCoder.readWord(2, false);
        if (this.pixelSize == 8) {
            this.tableSize = fSCoder.readWord(1, false) + 1;
            this.compressedData = new byte[this.length - 8];
            fSCoder.readBytes(this.compressedData);
        } else {
            this.compressedData = new byte[this.length - 7];
            fSCoder.readBytes(this.compressedData);
        }
        fSCoder.endObject(this.name());
    }
}

