/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;

public class FSGradient
extends FSTransformObject {
    private int ratio = 0;
    private FSColor color = null;

    public FSGradient(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSGradient(int n, FSColor fSColor) {
        this.setRatio(n);
        this.setColor(fSColor);
    }

    public FSGradient(FSGradient fSGradient) {
        this.ratio = fSGradient.ratio;
        this.color = new FSColor(fSGradient.color);
    }

    public int getRatio() {
        return this.ratio;
    }

    public FSColor getColor() {
        return this.color;
    }

    public void setRatio(int n) {
        this.ratio = n;
    }

    public void setColor(FSColor fSColor) {
        this.color = fSColor;
    }

    public Object clone() {
        FSGradient fSGradient = (FSGradient)super.clone();
        fSGradient.color = this.color != null ? (FSColor)this.color.clone() : null;
        return fSGradient;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSGradient fSGradient = (FSGradient)object;
            boolean bl2 = bl = this.ratio == fSGradient.ratio;
            bl = this.color != null ? bl && this.color.equals(fSGradient.color) : bl && this.color == fSGradient.color;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "ratio", this.ratio);
            Transform.append(stringBuffer, "color", this.color, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = 1;
        return n += this.color.length(fSCoder);
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.writeWord(this.ratio, 1);
        this.color.encode(fSCoder);
    }

    public void decode(FSCoder fSCoder) {
        this.ratio = fSCoder.readWord(1, false);
        this.color = new FSColor(fSCoder);
    }
}

