/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineSound;
import com.flagstone.transform.FSSoundStreamBlock;
import com.flagstone.transform.FSSoundStreamHead2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.DataFormatException;

public class FSSoundConstructor {
    private static final int[] riffSignature = new int[]{82, 73, 70, 70};
    private static final int[] wavSignature = new int[]{87, 65, 86, 69};
    private static final int FMT = 544501094;
    private static final int DATA = 1635017060;
    private static final int MPEG1 = 3;
    private static final int[] frameSizeMP3 = new int[]{576, 576, 576, 1152};
    private static final int[] channelCount = new int[]{2, 2, 2, 1};
    private static final int[][] bitRates = new int[][]{{-1, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {-1, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1}};
    private static final int[][] samplingRates = new int[][]{{11025, -1, -1, -1}, {-1, -1, -1, -1}, {22050, -1, -1, -1}, {44100, -1, -1, -1}};
    private int format = 3;
    private int numberOfChannels = 0;
    private int samplesPerChannel = 0;
    private int sampleRate = 0;
    private int sampleSize = 0;
    private byte[] sound = null;
    private int[][] frameTable = null;
    private int samplesPerFrame = 0;

    public FSSoundConstructor() {
    }

    public FSSoundConstructor(String string) throws IOException, DataFormatException {
        this.setSound(string);
    }

    public int getFormat() {
        return this.format;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public int getSamplesPerChannel() {
        return this.samplesPerChannel;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public byte[] getSound() {
        byte[] byArray = new byte[this.sound.length];
        System.arraycopy(this.sound, 0, byArray, 0, this.sound.length);
        return byArray;
    }

    public void setSound(String string) throws IOException, DataFormatException {
        if (string.toLowerCase().endsWith(".mp3")) {
            this.decodeMP3(this.dataFromFile(string));
        } else if (string.toLowerCase().endsWith(".wav")) {
            this.decodeWAV(string);
        }
    }

    public void setSound(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.format = n;
        this.numberOfChannels = n2;
        this.samplesPerChannel = n3;
        this.sampleRate = n4;
        this.sampleSize = n5;
        this.sound = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.sound, 0, byArray.length);
        if (n == 2) {
            this.initFrameTable(byArray);
        }
    }

    public FSDefineSound defineSound(int n) {
        byte[] byArray = null;
        switch (this.format) {
            case 1: 
            case 3: {
                byArray = new byte[this.sound.length];
                System.arraycopy(this.sound, 0, byArray, 0, this.sound.length);
                break;
            }
            case 2: {
                byArray = new byte[2 + this.sound.length];
                byArray[0] = 0;
                byArray[1] = 0;
                System.arraycopy(this.sound, 0, byArray, 2, this.sound.length);
            }
        }
        return new FSDefineSound(n, this.format, this.sampleRate, this.numberOfChannels, this.sampleSize, this.samplesPerChannel, byArray);
    }

    public FSSoundStreamHead2 streamHeader(int n) {
        return new FSSoundStreamHead2(this.format, this.sampleRate, this.numberOfChannels, this.sampleSize, this.sampleRate, this.numberOfChannels, this.sampleSize, n, 0);
    }

    public FSSoundStreamBlock streamBlock(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        byte[] byArray = null;
        switch (this.format) {
            case 3: {
                n3 = n * n2;
                n4 = n3 * this.sampleSize * this.numberOfChannels;
                n5 = n2 * this.sampleSize * this.numberOfChannels;
                n6 = this.sound.length - n4;
                n7 = n6 < n5 ? n6 : n5;
                byArray = new byte[n7];
                System.arraycopy(this.sound, n4, byArray, 0, n7);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                n8 = (n + 1) * n2 / this.samplesPerFrame;
                n9 = n * n2 / this.samplesPerFrame;
                n10 = n8 - n9;
                n11 = n10 * this.samplesPerFrame;
                n12 = n * n2 - n9 * this.samplesPerFrame;
                n7 = 4;
                int n13 = 0;
                int n14 = n9;
                while (n13 < n10) {
                    n7 += this.frameTable[n14][1];
                    ++n13;
                    ++n14;
                }
                byArray = new byte[n7];
                byArray[0] = (byte)n11;
                byArray[1] = (byte)(n11 >> 8);
                byArray[2] = (byte)n12;
                byArray[3] = (byte)(n12 >> 8);
                n13 = 4;
                n14 = 0;
                int n15 = n9;
                while (n14 < n10) {
                    System.arraycopy(this.sound, this.frameTable[n15][0], byArray, n13, this.frameTable[n15][1]);
                    n13 += this.frameTable[n15][1];
                    ++n14;
                    ++n15;
                }
                break;
            }
        }
        if (byArray != null) {
            return new FSSoundStreamBlock(byArray);
        }
        return null;
    }

    private void decodeWAV(String string) throws FileNotFoundException, IOException, DataFormatException {
        int n;
        FSCoder fSCoder = new FSCoder(0, this.dataFromFile(string));
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        for (n = 0; n < 4; ++n) {
            if (fSCoder.readWord(1, false) == riffSignature[n]) continue;
            throw new DataFormatException("Not a valid RIFF file");
        }
        fSCoder.readWord(4, false);
        for (n = 0; n < 4; ++n) {
            if (fSCoder.readWord(1, false) == wavSignature[n]) continue;
            throw new DataFormatException("Not a valid WAV file");
        }
        while (bl) {
            n3 = fSCoder.readWord(4, false);
            n2 = fSCoder.readWord(4, false);
            n = fSCoder.getPointer();
            switch (n3) {
                case 544501094: {
                    this.decodeFMT(fSCoder);
                    break;
                }
                case 1635017060: {
                    this.decodeDATA(fSCoder, n2);
                    n2 += n2 % 2;
                    break;
                }
                default: {
                    fSCoder.adjustPointer(n2 << 3);
                }
            }
            int n4 = n + (n2 << 3);
            fSCoder.setPointer(n4);
            bl = !fSCoder.eof();
        }
    }

    private void decodeFMT(FSCoder fSCoder) throws DataFormatException {
        this.format = 3;
        if (fSCoder.readWord(2, false) != 1) {
            throw new DataFormatException("Compressed WAV files are not currently supported.");
        }
        this.numberOfChannels = fSCoder.readWord(2, false);
        this.sampleRate = fSCoder.readWord(4, false);
        fSCoder.readWord(4, false);
        fSCoder.readWord(2, false);
        this.sampleSize = fSCoder.readWord(2, false) / 8;
    }

    private void decodeDATA(FSCoder fSCoder, int n) {
        this.samplesPerChannel = n / (this.sampleSize * this.numberOfChannels);
        this.sound = new byte[n];
        fSCoder.readBytes(this.sound);
        fSCoder.adjustPointer(n % 2 * 8);
    }

    private void decodeMP3(byte[] byArray) throws DataFormatException {
        int n;
        int n2;
        FSCoder fSCoder = new FSCoder(1, byArray);
        int n3 = 0;
        int n4 = 0;
        this.format = 2;
        this.sampleSize = 2;
        while (!fSCoder.eof()) {
            if (fSCoder.scanWord(3, false) == 0x494433) {
                fSCoder.adjustPointer(24);
                fSCoder.adjustPointer(8);
                fSCoder.adjustPointer(8);
                fSCoder.adjustPointer(1);
                fSCoder.adjustPointer(1);
                fSCoder.adjustPointer(1);
                n2 = fSCoder.readBits(1, false);
                fSCoder.adjustPointer(4);
                n = n2 == 1 ? 10 : 0;
                n += fSCoder.readWord(1, false) << 23;
                n += fSCoder.readWord(1, false) << 15;
                n += fSCoder.readWord(1, false) << 7;
                fSCoder.adjustPointer((n += fSCoder.readWord(1, false)) << 3);
                continue;
            }
            if (fSCoder.scanWord(3, false) == 5521735) {
                fSCoder.adjustPointer(1024);
                continue;
            }
            if (fSCoder.scanBits(11, false) == 2047) {
                if (n3 == 0) {
                    n4 = fSCoder.getPointer();
                }
                fSCoder.adjustPointer(this.MP3FrameSize(fSCoder) << 3);
                ++n3;
                continue;
            }
            fSCoder.setPointer(byArray.length << 3);
        }
        n2 = byArray.length - (n4 >> 3);
        this.sound = new byte[n2];
        System.arraycopy(byArray, n4 >> 3, this.sound, 0, n2);
        this.frameTable = new int[n3][2];
        for (n = 0; n < n3; ++n) {
            this.frameTable[n][0] = -1;
            this.frameTable[n][1] = 0;
        }
        fSCoder.setPointer(n4);
        n = 0;
        while (fSCoder.findBits(2047, 11, 8)) {
            this.frameTable[n][0] = fSCoder.getPointer() - n4 + 16 >> 3;
            fSCoder.adjustPointer(11);
            int n5 = fSCoder.readBits(2, false);
            this.samplesPerFrame = frameSizeMP3[n5];
            if (fSCoder.readBits(2, false) != 1) {
                throw new DataFormatException("Flash only supports MPEG Layer 3");
            }
            fSCoder.readBits(1, false);
            int n6 = bitRates[n5][fSCoder.readBits(4, false)];
            if (n6 == -1) {
                throw new DataFormatException("Unsupported Bit-rate");
            }
            this.sampleRate = samplingRates[n5][fSCoder.readBits(2, false)];
            if (this.sampleRate == -1) {
                throw new DataFormatException("Unsupported Sampling-rate");
            }
            int n7 = fSCoder.readBits(1, false);
            fSCoder.readBits(1, false);
            this.numberOfChannels = channelCount[fSCoder.readBits(2, false)];
            fSCoder.adjustPointer(6);
            this.samplesPerChannel += this.samplesPerFrame;
            int n8 = (n5 == 3 ? 144 : 72) * n6 * 1000 / this.sampleRate + n7 - 4;
            this.frameTable[n++][1] = 4 + n8;
            fSCoder.adjustPointer(n8 << 3);
        }
    }

    private byte[] dataFromFile(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    private void initFrameTable(byte[] byArray) {
        FSCoder fSCoder = new FSCoder(0, byArray);
        fSCoder.findBits(2047, 11, 8);
        int n = fSCoder.getPointer();
        int n2 = 0;
        while (fSCoder.findBits(2047, 11, 8)) {
            fSCoder.adjustPointer(this.MP3FrameSize(fSCoder) << 3);
            ++n2;
        }
        this.frameTable = new int[n2][2];
        fSCoder.setPointer(n);
        int n3 = 0;
        while (fSCoder.findBits(2047, 11, 8)) {
            this.frameTable[n3][0] = fSCoder.getPointer() - n + 16 >> 3;
            fSCoder.adjustPointer(11);
            int n4 = fSCoder.readBits(2, false);
            fSCoder.adjustPointer(3);
            int n5 = bitRates[n4][fSCoder.readBits(4, false)];
            int n6 = samplingRates[n4][fSCoder.readBits(2, false)];
            int n7 = fSCoder.readBits(1, false);
            this.frameTable[n3++][1] = 4 + ((n4 == 3 ? 144 : 72) * n5 * 1000 / n6 + n7) - 4;
            fSCoder.adjustPointer((this.MP3FrameSize(fSCoder) << 3) - 23);
        }
    }

    private int MP3FrameSize(FSCoder fSCoder) {
        int n = 4;
        fSCoder.adjustPointer(11);
        int n2 = fSCoder.readBits(2, false);
        fSCoder.adjustPointer(3);
        int n3 = bitRates[n2][fSCoder.readBits(4, false)];
        int n4 = samplingRates[n2][fSCoder.readBits(2, false)];
        int n5 = fSCoder.readBits(1, false);
        fSCoder.adjustPointer(-23);
        return n += (n2 == 3 ? 144 : 72) * n3 * 1000 / n4 + n5 - 4;
    }
}

