/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.struts.action.ActionForm;

public class FormUtils {
    private static final String FORM_MODE_KEY = "fr.improve.struts.taglib.layout.util.FormUtils.FORM_MODE_KEY";
    private static final String USER_FORM_MODE_KEY = "fr.improve.struts.taglib.layout.util.FormUtils.USER_FORM_MODE_KEY";
    public static final int CREATE_MODE = 0;
    public static final int EDIT_MODE = 1;
    public static final int INSPECT_MODE = 2;
    private static final String FIELD_STYLECLASS_KEY = "fr.improve.struts.taglib.layout.util.FormUtils.FIELD_STYLECLASS_KEY";
    private static final String FIELD_MODE_KEY = "fr.improve.struts.taglib.layout.util.FormUtils.FIELD_MODE_KEY";
    private static final String FIELD_STYLE_KEY = "fr.improve.struts.taglib.layout.util.FormUtils.FIELD_STYLE_KEY";
    private static final String FIELD_VALUES_STYLE_KEY = "fr.improve.struts.taglib.layout.util.FormUtils.FIELD_VALUES_STYLE_KEY";

    private static Map getFormModes(HttpSession in_session) {
        if (in_session == null) {
            return new HashMap();
        }
        HashMap lc_map = (HashMap)in_session.getAttribute(FORM_MODE_KEY);
        if (lc_map == null) {
            lc_map = new HashMap();
            in_session.setAttribute(FORM_MODE_KEY, lc_map);
        }
        return lc_map;
    }

    private static Map getFieldModes(HttpSession in_session, ActionForm in_form) {
        HashMap lc_mapField;
        HashMap lc_mapForm = null;
        if (in_session != null) {
            lc_mapForm = (HashMap)in_session.getAttribute(FIELD_MODE_KEY);
        }
        if (lc_mapForm == null) {
            lc_mapForm = new HashMap();
            if (in_session != null) {
                in_session.setAttribute(FIELD_MODE_KEY, lc_mapForm);
            }
        }
        if ((lc_mapField = (HashMap)lc_mapForm.get(in_form.getClass())) == null) {
            lc_mapField = new HashMap();
            lc_mapForm.put(in_form.getClass(), lc_mapField);
        }
        return lc_mapField;
    }

    public static void setFormDisplayMode(HttpServletRequest in_request, ActionForm in_form, int in_mode) {
        if (in_form == null) {
            throw new IllegalArgumentException("in_form cannot be null");
        }
        Map lc_map = FormUtils.getFormModes(in_request.getSession());
        lc_map.put(in_form.getClass(), new Integer(in_mode));
    }

    public static void setFormDisplayMode(HttpServletRequest in_request, ActionForm in_form, String in_mode) {
        if (in_form == null) {
            throw new IllegalArgumentException("in_form cannot be null");
        }
        if (in_mode == null || in_mode.trim().length() == 0) {
            throw new IllegalArgumentException("in_mode cannot be null or empty");
        }
        Map lc_map = FormUtils.getFormModes(in_request.getSession());
        Integer lc_int = FormUtils.getUserFormMode(in_request, in_mode);
        lc_map.put(in_form.getClass(), lc_int);
    }

    private static Integer getUserFormMode(HttpServletRequest in_request, String in_mode) {
        Integer lc_int;
        HashMap<String, Integer> lc_map = (HashMap<String, Integer>)in_request.getSession().getAttribute(USER_FORM_MODE_KEY);
        if (lc_map == null) {
            lc_map = new HashMap<String, Integer>();
            lc_map.put("create", new Integer(0));
            lc_map.put("edit", new Integer(1));
            lc_map.put("inspect", new Integer(2));
            in_request.getSession().setAttribute(USER_FORM_MODE_KEY, lc_map);
        }
        if ((lc_int = (Integer)lc_map.get(in_mode)) == null) {
            lc_int = new Integer(lc_map.size());
            lc_map.put(in_mode, lc_int);
        }
        return lc_int;
    }

    public static void setFieldDisplayMode(HttpServletRequest in_request, ActionForm in_form, String in_fieldName, int in_mode) {
        if (in_form == null) {
            throw new IllegalArgumentException("in_form cannot be null");
        }
        if (in_fieldName == null) {
            throw new IllegalArgumentException("in_fieldName cannot be null");
        }
        Map lc_field = FormUtils.getFieldModes(in_request.getSession(), in_form);
        lc_field.put(in_fieldName, new Integer(in_mode));
    }

    public static int getFormDisplayMode(PageContext in_page) {
        Object lc_form = in_page.findAttribute("org.apache.struts.taglib.html.BEAN");
        if (lc_form == null) {
            return 1;
        }
        return FormUtils.getFormDisplayMode(in_page.getSession(), (ActionForm)lc_form);
    }

    public static Integer getFieldDisplayMode(PageContext in_page, String in_fieldName) {
        Object lc_form = in_page.findAttribute("org.apache.struts.taglib.html.BEAN");
        if (lc_form == null) {
            return null;
        }
        return FormUtils.getFieldDisplayMode(in_page.getSession(), (ActionForm)lc_form, in_fieldName);
    }

    public static int getFormDisplayMode(HttpServletRequest in_request, ActionForm in_form) {
        return FormUtils.getFormDisplayMode(in_request.getSession(), in_form);
    }

    public static Integer getFieldDisplayMode(HttpServletRequest in_request, ActionForm in_form, String in_fieldName) {
        return FormUtils.getFieldDisplayMode(in_request.getSession(), in_form, in_fieldName);
    }

    protected static int getFormDisplayMode(HttpSession in_session, ActionForm in_form) {
        Map lc_map = FormUtils.getFormModes(in_session);
        if (in_form == null) {
            return 1;
        }
        Integer lc_mode = (Integer)lc_map.get(in_form.getClass());
        if (lc_mode == null) {
            return 1;
        }
        return lc_mode;
    }

    protected static Integer getFieldDisplayMode(HttpSession in_session, ActionForm in_form, String in_fieldName) {
        if (in_form == null) {
            return null;
        }
        if (in_fieldName == null) {
            return null;
        }
        Map lc_map = FormUtils.getFieldModes(in_session, in_form);
        Integer lc_mode = (Integer)lc_map.get(in_fieldName);
        if (lc_mode == null) {
            return null;
        }
        return lc_mode;
    }

    public static short computeFieldDisplayMode(PageContext in_pageContext, String in_mode) {
        int lc_formMode = FormUtils.getFormDisplayMode(in_pageContext);
        if (in_mode == null) {
            throw new IllegalArgumentException("The specified mode is null");
        }
        if (in_mode.indexOf(58) == -1) {
            if (lc_formMode >= 3) {
                return 1;
            }
            int lc_modePosition = lc_formMode * 2;
            if (in_mode.length() < lc_modePosition) {
                throw new IllegalArgumentException("Bad form / field display mode (" + lc_formMode + ";" + in_mode);
            }
            char lc_char = in_mode.charAt(lc_modePosition);
            switch (Character.toUpperCase(lc_char)) {
                case 'E': {
                    return 2;
                }
                case 'I': {
                    return 1;
                }
                case 'H': {
                    return 3;
                }
                case 'N': {
                    return 0;
                }
                case 'S': {
                    return 4;
                }
                case 'P': {
                    return 5;
                }
                case 'R': {
                    return 6;
                }
                case 'D': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
            }
            throw new IllegalArgumentException("Bad field display mode " + lc_char);
        }
        StringTokenizer tokenizer = new StringTokenizer(in_mode, ",;:");
        while (tokenizer.hasMoreTokens()) {
            String lc_mode = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The specified mode " + in_mode + " is invalid.");
            }
            String lc_fieldMode = tokenizer.nextToken();
            if (FormUtils.getUserFormMode((HttpServletRequest)in_pageContext.getRequest(), lc_mode) != lc_formMode) continue;
            switch (Character.toUpperCase(lc_fieldMode.charAt(0))) {
                case 'E': {
                    return 2;
                }
                case 'I': {
                    return 1;
                }
                case 'H': {
                    return 3;
                }
                case 'N': {
                    return 0;
                }
                case 'S': {
                    return 4;
                }
                case 'P': {
                    return 5;
                }
                case 'R': {
                    return 6;
                }
                case 'D': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
            }
        }
        switch (lc_formMode) {
            case 0: 
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public static int computeVisibilityMode(PageContext in_pageContext, String in_mode) {
        int lc_formMode = FormUtils.getFormDisplayMode(in_pageContext);
        int lc_visible = 78;
        if (in_mode == null) {
            throw new IllegalArgumentException("The specified mode is null");
        }
        if (in_mode.indexOf(58) == -1) {
            int lc_displayMode;
            if (lc_formMode >= 3) {
                return 0;
            }
            if (in_mode == null || in_mode.length() != 5) {
                throw new IllegalArgumentException("The specified mode" + in_mode + " is invalid");
            }
            switch (lc_formMode) {
                case 0: {
                    lc_displayMode = in_mode.charAt(0);
                    break;
                }
                case 1: {
                    lc_displayMode = in_mode.charAt(2);
                    break;
                }
                case 2: {
                    lc_displayMode = in_mode.charAt(4);
                    break;
                }
                default: {
                    lc_displayMode = 68;
                }
            }
            lc_visible = lc_displayMode;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(in_mode, ",;:");
            while (tokenizer.hasMoreTokens()) {
                String lc_mode = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("The specified mode " + in_mode + " is invalid.");
                }
                String lc_visibility = tokenizer.nextToken();
                if (FormUtils.getUserFormMode((HttpServletRequest)in_pageContext.getRequest(), lc_mode) != lc_formMode) continue;
                lc_visible = lc_visibility.charAt(0);
                break;
            }
        }
        if (lc_visible == 68 || lc_visible == 100) {
            return 2;
        }
        if (lc_visible == 70 || lc_visible == 102) {
            return 7;
        }
        if (lc_visible == 67 || lc_visible == 99) {
            return 8;
        }
        return 0;
    }

    private static Map getFieldStyleClass(HttpServletRequest in_request) {
        HashMap lc_map = (HashMap)in_request.getAttribute(FIELD_STYLECLASS_KEY);
        if (lc_map == null) {
            lc_map = new HashMap();
            in_request.setAttribute(FIELD_STYLECLASS_KEY, lc_map);
        }
        return lc_map;
    }

    private static Map getFieldStyle(HttpServletRequest in_request) {
        HashMap lc_map = (HashMap)in_request.getAttribute(FIELD_STYLE_KEY);
        if (lc_map == null) {
            lc_map = new HashMap();
            in_request.setAttribute(FIELD_STYLE_KEY, lc_map);
        }
        return lc_map;
    }

    public static void setFieldStyleClass(HttpServletRequest in_request, String in_fieldName, String in_styleClass) {
        FormUtils.getFieldStyleClass(in_request).put(in_fieldName, in_styleClass);
    }

    public static void setFieldStyle(HttpServletRequest in_request, String in_fieldName, String in_style) {
        FormUtils.getFieldStyle(in_request).put(in_fieldName, in_style);
    }

    public static String getFieldStyleClass(PageContext in_pageContext, String in_fieldName) {
        return (String)FormUtils.getFieldStyleClass((HttpServletRequest)in_pageContext.getRequest()).get(in_fieldName);
    }

    public static String getFieldStyle(PageContext in_pageContext, String in_fieldName) {
        return (String)FormUtils.getFieldStyle((HttpServletRequest)in_pageContext.getRequest()).get(in_fieldName);
    }

    public static String getFieldValueStyle(PageContext in_pageContext) {
        List lc_list = (List)in_pageContext.getRequest().getAttribute(FIELD_VALUES_STYLE_KEY);
        if (lc_list == null || lc_list.isEmpty()) {
            return "";
        }
        StringBuffer lc_style = new StringBuffer();
        int i = 0;
        while (i < lc_list.size()) {
            lc_style.append(lc_list.get(i));
            ++i;
        }
        return lc_style.toString();
    }

    public static void addFieldValueStyle(PageContext in_pageContext, String in_style) {
        ArrayList<String> lc_list = (ArrayList<String>)in_pageContext.getRequest().getAttribute(FIELD_VALUES_STYLE_KEY);
        if (lc_list == null) {
            lc_list = new ArrayList<String>();
            in_pageContext.getRequest().setAttribute(FIELD_VALUES_STYLE_KEY, lc_list);
        }
        lc_list.add(in_style);
    }

    public static void removeFieldValueStyle(PageContext in_pageContext) {
        List lc_list = (List)in_pageContext.getRequest().getAttribute(FIELD_VALUES_STYLE_KEY);
        lc_list.remove(lc_list.size() - 1);
    }
}

