/*
 * Decompiled with CFR 0.152.
 */
package cn.bluejoe.elfinder.impl;

import cn.bluejoe.elfinder.service.FsItem;
import cn.bluejoe.elfinder.service.FsSecurityChecker;
import cn.bluejoe.elfinder.service.FsService;
import cn.bluejoe.elfinder.service.FsServiceConfig;
import cn.bluejoe.elfinder.service.FsVolume;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class DefaultFsService
implements FsService {
    FsSecurityChecker _securityChecker;
    FsServiceConfig _serviceConfig;
    Map<FsVolume, String> _volumeIds = new HashMap<FsVolume, String>();
    FsVolume[] _volumes;
    String[][] escapes = new String[][]{{"+", "_P"}, {"-", "_M"}, {"/", "_S"}, {".", "_D"}, {"=", "_E"}};

    @Override
    public FsServiceConfig getServiceConfig() {
        return this._serviceConfig;
    }

    public void setServiceConfig(FsServiceConfig serviceConfig) {
        this._serviceConfig = serviceConfig;
    }

    @Override
    public FsItem fromHash(String hash) {
        FsVolume[] fsVolumeArray = this._volumes;
        int n = this._volumes.length;
        int n2 = 0;
        while (n2 < n) {
            FsVolume v = fsVolumeArray[n2];
            String prefix = String.valueOf(this.getVolumeId(v)) + "_";
            if (hash.equals(prefix)) {
                return v.getRoot();
            }
            if (hash.startsWith(prefix)) {
                String localHash = hash.substring(prefix.length());
                String[][] stringArray = this.escapes;
                int n3 = this.escapes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] pair = stringArray[n4];
                    localHash = localHash.replace(pair[1], pair[0]);
                    ++n4;
                }
                String relativePath = new String(Base64.decodeBase64((String)localHash));
                return v.fromPath(relativePath);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getHash(FsItem item) throws IOException {
        String relativePath = item.getVolume().getPath(item);
        String base = new String(Base64.encodeBase64((byte[])relativePath.getBytes()));
        String[][] stringArray = this.escapes;
        int n = this.escapes.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair = stringArray[n2];
            base = base.replace(pair[0], pair[1]);
            ++n2;
        }
        return String.valueOf(this.getVolumeId(item.getVolume())) + "_" + base;
    }

    @Override
    public FsSecurityChecker getSecurityChecker() {
        return this._securityChecker;
    }

    @Override
    public String getVolumeId(FsVolume volume) {
        return this._volumeIds.get(volume);
    }

    @Override
    public FsVolume[] getVolumes() {
        return this._volumes;
    }

    public void setSecurityChecker(FsSecurityChecker securityChecker) {
        this._securityChecker = securityChecker;
    }

    public void setVolumes(FsVolume[] volumes) {
        this._volumes = volumes;
        char vid = 'A';
        FsVolume[] fsVolumeArray = volumes;
        int n = volumes.length;
        int n2 = 0;
        while (n2 < n) {
            FsVolume volume = fsVolumeArray[n2];
            this._volumeIds.put(volume, "" + vid);
            vid = (char)(vid + '\u0001');
            ++n2;
        }
    }
}

